/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.MessageType;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NotificationGroup {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.notification.NotificationGroup");
    private static final Map<String, NotificationGroup> ourRegisteredGroups = ContainerUtil.newConcurrentMap();
    @NotNull
    private final String myDisplayId;
    @NotNull
    private final NotificationDisplayType myDisplayType;
    private final boolean myLogByDefault;
    @Nullable
    private final String myToolWindowId;
    private final Icon myIcon;
    private String myParentId;

    public NotificationGroup(@NotNull String displayId, @NotNull NotificationDisplayType defaultDisplayType, boolean logByDefault) {
        if (displayId == null) {
            NotificationGroup.$$$reportNull$$$0(0);
        }
        if (defaultDisplayType == null) {
            NotificationGroup.$$$reportNull$$$0(1);
        }
        this(displayId, defaultDisplayType, logByDefault, null);
    }

    public NotificationGroup(@NotNull String displayId, @NotNull NotificationDisplayType defaultDisplayType, boolean logByDefault, @Nullable String toolWindowId) {
        if (displayId == null) {
            NotificationGroup.$$$reportNull$$$0(2);
        }
        if (defaultDisplayType == null) {
            NotificationGroup.$$$reportNull$$$0(3);
        }
        this(displayId, defaultDisplayType, logByDefault, toolWindowId, null);
    }

    public NotificationGroup(@NotNull String displayId, @NotNull NotificationDisplayType defaultDisplayType, boolean logByDefault, @Nullable String toolWindowId, @Nullable Icon icon) {
        if (displayId == null) {
            NotificationGroup.$$$reportNull$$$0(4);
        }
        if (defaultDisplayType == null) {
            NotificationGroup.$$$reportNull$$$0(5);
        }
        this.myDisplayId = displayId;
        this.myDisplayType = defaultDisplayType;
        this.myLogByDefault = logByDefault;
        this.myToolWindowId = toolWindowId;
        this.myIcon = icon;
        if (ourRegisteredGroups.containsKey(displayId)) {
            LOG.info("Notification group " + displayId + " is already registered", new Throwable());
        }
        ourRegisteredGroups.put(displayId, this);
    }

    @NotNull
    public static NotificationGroup balloonGroup(@NotNull String displayId) {
        if (displayId == null) {
            NotificationGroup.$$$reportNull$$$0(6);
        }
        NotificationGroup notificationGroup = new NotificationGroup(displayId, NotificationDisplayType.BALLOON, true);
        if (notificationGroup == null) {
            NotificationGroup.$$$reportNull$$$0(7);
        }
        return notificationGroup;
    }

    @NotNull
    public static NotificationGroup logOnlyGroup(@NotNull String displayId) {
        if (displayId == null) {
            NotificationGroup.$$$reportNull$$$0(8);
        }
        NotificationGroup notificationGroup = new NotificationGroup(displayId, NotificationDisplayType.NONE, true);
        if (notificationGroup == null) {
            NotificationGroup.$$$reportNull$$$0(9);
        }
        return notificationGroup;
    }

    @NotNull
    public static NotificationGroup toolWindowGroup(@NotNull String displayId, @NotNull String toolWindowId, boolean logByDefault) {
        if (displayId == null) {
            NotificationGroup.$$$reportNull$$$0(10);
        }
        if (toolWindowId == null) {
            NotificationGroup.$$$reportNull$$$0(11);
        }
        NotificationGroup notificationGroup = new NotificationGroup(displayId, NotificationDisplayType.TOOL_WINDOW, logByDefault, toolWindowId);
        if (notificationGroup == null) {
            NotificationGroup.$$$reportNull$$$0(12);
        }
        return notificationGroup;
    }

    @NotNull
    public static NotificationGroup toolWindowGroup(@NotNull String displayId, @NotNull String toolWindowId) {
        if (displayId == null) {
            NotificationGroup.$$$reportNull$$$0(13);
        }
        if (toolWindowId == null) {
            NotificationGroup.$$$reportNull$$$0(14);
        }
        NotificationGroup notificationGroup = NotificationGroup.toolWindowGroup(displayId, toolWindowId, true);
        if (notificationGroup == null) {
            NotificationGroup.$$$reportNull$$$0(15);
        }
        return notificationGroup;
    }

    @NotNull
    public String getDisplayId() {
        String string = this.myDisplayId;
        if (string == null) {
            NotificationGroup.$$$reportNull$$$0(16);
        }
        return string;
    }

    @Nullable
    public Icon getIcon() {
        return this.myIcon;
    }

    public Notification createNotification(@NotNull String content, @NotNull MessageType type) {
        if (content == null) {
            NotificationGroup.$$$reportNull$$$0(17);
        }
        if (type == null) {
            NotificationGroup.$$$reportNull$$$0(18);
        }
        return this.createNotification(content, type.toNotificationType());
    }

    @NotNull
    public Notification createNotification(@NotNull String content, @NotNull NotificationType type) {
        if (content == null) {
            NotificationGroup.$$$reportNull$$$0(19);
        }
        if (type == null) {
            NotificationGroup.$$$reportNull$$$0(20);
        }
        Notification notification = this.createNotification("", content, type, null);
        if (notification == null) {
            NotificationGroup.$$$reportNull$$$0(21);
        }
        return notification;
    }

    @NotNull
    public Notification createNotification(@NotNull String title, @NotNull String content, @NotNull NotificationType type, @Nullable NotificationListener listener2) {
        if (title == null) {
            NotificationGroup.$$$reportNull$$$0(22);
        }
        if (content == null) {
            NotificationGroup.$$$reportNull$$$0(23);
        }
        if (type == null) {
            NotificationGroup.$$$reportNull$$$0(24);
        }
        Notification notification = new Notification(this.myDisplayId, title, content, type, listener2);
        if (notification == null) {
            NotificationGroup.$$$reportNull$$$0(25);
        }
        return notification;
    }

    @NotNull
    public Notification createNotification() {
        Notification notification = this.createNotification(NotificationType.INFORMATION);
        if (notification == null) {
            NotificationGroup.$$$reportNull$$$0(26);
        }
        return notification;
    }

    @NotNull
    public Notification createNotification(@NotNull NotificationType type) {
        if (type == null) {
            NotificationGroup.$$$reportNull$$$0(27);
        }
        Notification notification = this.createNotification(null, null, null, type, null);
        if (notification == null) {
            NotificationGroup.$$$reportNull$$$0(28);
        }
        return notification;
    }

    @NotNull
    public Notification createNotification(@Nullable String title, @Nullable String subtitle, @Nullable String content, @NotNull NotificationType type) {
        if (type == null) {
            NotificationGroup.$$$reportNull$$$0(29);
        }
        Notification notification = this.createNotification(title, subtitle, content, type, null);
        if (notification == null) {
            NotificationGroup.$$$reportNull$$$0(30);
        }
        return notification;
    }

    @NotNull
    public Notification createNotification(@Nullable String title, @Nullable String subtitle, @Nullable String content, @NotNull NotificationType type, @Nullable NotificationListener listener2) {
        if (type == null) {
            NotificationGroup.$$$reportNull$$$0(31);
        }
        Notification notification = new Notification(this.myDisplayId, this.myIcon, title, subtitle, content, type, listener2);
        if (notification == null) {
            NotificationGroup.$$$reportNull$$$0(32);
        }
        return notification;
    }

    @Nullable
    public String getParentId() {
        return this.myParentId;
    }

    @NotNull
    public NotificationGroup setParentId(@NotNull String parentId) {
        if (parentId == null) {
            NotificationGroup.$$$reportNull$$$0(33);
        }
        this.myParentId = parentId;
        NotificationGroup notificationGroup = this;
        if (notificationGroup == null) {
            NotificationGroup.$$$reportNull$$$0(34);
        }
        return notificationGroup;
    }

    @NotNull
    public NotificationDisplayType getDisplayType() {
        NotificationDisplayType notificationDisplayType = this.myDisplayType;
        if (notificationDisplayType == null) {
            NotificationGroup.$$$reportNull$$$0(35);
        }
        return notificationDisplayType;
    }

    public boolean isLogByDefault() {
        return this.myLogByDefault;
    }

    @Nullable
    public String getToolWindowId() {
        return this.myToolWindowId;
    }

    @Nullable
    public static NotificationGroup findRegisteredGroup(String displayId) {
        return ourRegisteredGroups.get(displayId);
    }

    @NotNull
    public static Iterable<NotificationGroup> getAllRegisteredGroups() {
        Collection<NotificationGroup> collection = ourRegisteredGroups.values();
        if (collection == null) {
            NotificationGroup.$$$reportNull$$$0(36);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 15: 
            case 16: 
            case 21: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 36: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 15: 
            case 16: 
            case 21: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 36: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayId";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultDisplayType";
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 15: 
            case 16: 
            case 21: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/notification/NotificationGroup";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindowId";
                break;
            }
            case 17: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 18: 
            case 20: 
            case 24: 
            case 27: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/notification/NotificationGroup";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "balloonGroup";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "logOnlyGroup";
                break;
            }
            case 12: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "toolWindowGroup";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayId";
                break;
            }
            case 21: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createNotification";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "setParentId";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayType";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllRegisteredGroups";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "balloonGroup";
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 15: 
            case 16: 
            case 21: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 36: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "logOnlyGroup";
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "toolWindowGroup";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 29: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createNotification";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "setParentId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 15: 
            case 16: 
            case 21: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

