/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.psi.PsiComment;
import com.intellij.util.IncorrectOperationException;

public class DocCommentPolicy<T extends PsiComment> {
    public static final int ASIS = 0;
    public static final int MOVE = 1;
    public static final int COPY = 2;
    private final int myJavaDocPolicy;

    public DocCommentPolicy(int javaDocPolicy) {
        this.myJavaDocPolicy = javaDocPolicy;
    }

    public void processCopiedJavaDoc(T newDocComment, T docComment, boolean willOldBeDeletedAnyway) throws IncorrectOperationException {
        if (this.myJavaDocPolicy == 2 || docComment == null) {
            return;
        }
        if (this.myJavaDocPolicy == 1) {
            docComment.delete();
        } else if (this.myJavaDocPolicy == 0 && newDocComment != null && !willOldBeDeletedAnyway) {
            newDocComment.delete();
        }
    }

    public void processNewJavaDoc(T newDocComment) throws IncorrectOperationException {
        if (this.myJavaDocPolicy == 0 && newDocComment != null) {
            newDocComment.delete();
        }
    }

    public void processOldJavaDoc(T oldDocComment) throws IncorrectOperationException {
        if (this.myJavaDocPolicy == 1 && oldDocComment != null) {
            oldDocComment.delete();
        }
    }

    public int getJavaDocPolicy() {
        return this.myJavaDocPolicy;
    }
}

