/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.pydev;

import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.pydev.AbstractCommand;
import com.jetbrains.python.debugger.pydev.AbstractFrameCommand;
import com.jetbrains.python.debugger.pydev.ProtocolFrame;
import com.jetbrains.python.debugger.pydev.ProtocolParser;
import com.jetbrains.python.debugger.pydev.RemoteDebugger;

public class ConsoleExecCommand
extends AbstractFrameCommand<String> {
    private final String myExpression;

    public ConsoleExecCommand(RemoteDebugger debugger, String threadId, String frameId, String expression) {
        super(debugger, 121, threadId, frameId);
        this.myExpression = expression;
    }

    @Override
    protected void buildPayload(AbstractCommand.Payload payload) {
        super.buildPayload(payload);
        payload.add("FRAME").add(this.myExpression);
    }

    @Override
    public boolean isResponseExpected() {
        return true;
    }

    @Override
    protected AbstractCommand.ResponseProcessor<String> createResponseProcessor() {
        return new AbstractCommand.ResponseProcessor<String>(){

            @Override
            protected String parseResponse(ProtocolFrame response) throws PyDebuggerException {
                PyDebugValue value = ProtocolParser.parseValue(response.getPayload(), (PyFrameAccessor)ConsoleExecCommand.this.getDebugger().getDebugProcess());
                return value.getValue();
            }
        };
    }
}

