/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.Gray;
import com.intellij.ui.SeparatorOrientation;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;

public class SeparatorComponent
extends JComponent {
    private int myVGap = 3;
    private Color myColor = Color.lightGray;
    private Color myShadow = Gray._240;
    private int myHGap = 1;
    private SeparatorOrientation myOrientation = SeparatorOrientation.HORIZONTAL;

    public SeparatorComponent() {
    }

    public SeparatorComponent(int aVerticalGap) {
        this.myVGap = aVerticalGap;
        this.setBorder(JBUI.Borders.empty(this.myVGap, 0));
    }

    public SeparatorComponent(int aVerticalGap, int aHorizontalGap) {
        this.myVGap = aVerticalGap;
        this.myHGap = aHorizontalGap;
        this.setBorder(JBUI.Borders.empty(this.myVGap, 0));
    }

    public SeparatorComponent(int aVerticalGap, Color aColor, Color aShadowColor) {
        this(aVerticalGap, 1, aColor, aShadowColor);
    }

    public SeparatorComponent(int aVerticalGap, int horizontalGap, Color aColor, Color aShadowColor) {
        this.myVGap = aVerticalGap;
        this.myHGap = horizontalGap;
        this.myColor = aColor;
        this.myShadow = aShadowColor;
        this.setBorder(JBUI.Borders.empty(this.myVGap, 0));
    }

    public SeparatorComponent(Color color, SeparatorOrientation orientation) {
        this.myColor = color;
        this.myOrientation = orientation;
        this.myShadow = null;
        this.myHGap = 0;
        this.myVGap = 0;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (!this.isVisible()) {
            return;
        }
        if (this.myColor == null) {
            return;
        }
        g.setColor(this.myColor);
        if (this.myOrientation != SeparatorOrientation.VERTICAL) {
            g.drawLine(this.myHGap, this.myVGap, this.getWidth() - this.myHGap - 1, this.myVGap);
            if (this.myShadow != null) {
                g.setColor(this.myShadow);
                g.drawLine(this.myHGap + 1, this.myVGap + 1, this.getWidth() - this.myHGap, this.myVGap + 1);
            }
        } else {
            g.drawLine(this.myHGap, this.myVGap, this.myHGap, this.getHeight() - this.myVGap - 1);
            if (this.myShadow != null) {
                g.setColor(this.myShadow);
                g.drawLine(this.myHGap + 1, this.myVGap + 1, this.myHGap + 1, this.getHeight() - this.myVGap);
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.myOrientation != SeparatorOrientation.VERTICAL) {
            return new Dimension(0, this.myVGap * 2 + 1);
        }
        return new Dimension(this.myHGap * 2 + 1, 1 + (this.myShadow != null ? 1 : 0));
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension size = this.getPreferredSize();
        if (this.myOrientation != SeparatorOrientation.VERTICAL) {
            size.width = Integer.MAX_VALUE;
        } else {
            size.height = Integer.MAX_VALUE;
        }
        return size;
    }
}

