/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.rt.execution;

import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public class ForkedDebuggerHelper {
    public static final String DEBUG_SETUP_PREFIX = "-agentlib:jdwp=transport=dt_socket,server=n,suspend=y,address=";
    public static final String DEBUG_FORK_SOCKET_PARAM = "-forkSocket";

    public static String setupDebugger(String processName, int debugPort) {
        String setup = "";
        try {
            int debugAddress;
            if (debugPort > -1 && (debugAddress = ForkedDebuggerHelper.findAvailableSocketPort()) > -1) {
                setup = DEBUG_SETUP_PREFIX + debugAddress;
                ForkedDebuggerHelper.send(debugAddress, processName, debugPort);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return setup;
    }

    public static void processFinished(String processName, int debugPort) {
        ForkedDebuggerHelper.send(0, processName, debugPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void send(int signal, String processName, int debugPort) {
        try {
            Socket socket = new Socket("127.0.0.1", debugPort);
            try {
                DataOutputStream stream = new DataOutputStream(socket.getOutputStream());
                try {
                    stream.writeInt(signal);
                    stream.writeUTF(processName);
                    int n = socket.getInputStream().read();
                }
                finally {
                    stream.close();
                }
            }
            finally {
                socket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int findAvailableSocketPort() throws IOException {
        ServerSocket serverSocket = new ServerSocket(0);
        try {
            int port = serverSocket.getLocalPort();
            ServerSocket serverSocket2 = serverSocket;
            synchronized (serverSocket2) {
                try {
                    serverSocket.wait(1L);
                }
                catch (InterruptedException e) {
                    System.err.println(e);
                }
            }
            int n = port;
            return n;
        }
        finally {
            serverSocket.close();
        }
    }
}

