/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.actions;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PythonMinicondaLocator;
import com.jetbrains.python.actions.InstallCondaActionImpl;
import java.io.File;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0007J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\rH\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\rH\u0002J$\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\r2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00160\u0015H\u0007J\f\u0010\u0017\u001a\u00020\u0018*\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0005\u001a\u00020\u00068FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\n\u0010\u000b\u0012\u0004\b\u0007\u0010\u0002\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/python/actions/InstallCondaActionImpl;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "defaultDirectoryFile", "Ljava/io/File;", "defaultDirectoryFile$annotations", "getDefaultDirectoryFile", "()Ljava/io/File;", "defaultDirectoryFile$delegate", "Lkotlin/Lazy;", "beatifyPath", "", "path", "checkPath", "getCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "installationHandler", "Lcom/intellij/execution/process/CapturingProcessHandler;", "indicationFunction", "Lkotlin/Function1;", "", "checkCondaWrite", "", "intellij.python.community.impl"})
public final class InstallCondaActionImpl {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private static final Logger LOG;
    @NotNull
    private static final Lazy defaultDirectoryFile$delegate;
    public static final InstallCondaActionImpl INSTANCE;

    static {
        InstallCondaActionImpl installCondaActionImpl;
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(InstallCondaActionImpl.class), "defaultDirectoryFile", "getDefaultDirectoryFile()Ljava/io/File;"))};
        INSTANCE = installCondaActionImpl = new InstallCondaActionImpl();
        Logger logger = Logger.getInstance(InstallCondaActionImpl.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Insta\u2026daActionImpl::class.java)");
        LOG = logger;
        defaultDirectoryFile$delegate = LazyKt.lazy((Function0)defaultDirectoryFile.2.INSTANCE);
    }

    @JvmStatic
    public static /* synthetic */ void defaultDirectoryFile$annotations() {
    }

    @NotNull
    public static final File getDefaultDirectoryFile() {
        Lazy lazy = defaultDirectoryFile$delegate;
        InstallCondaActionImpl installCondaActionImpl = INSTANCE;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return (File)lazy.getValue();
    }

    @JvmStatic
    @NotNull
    public static final CapturingProcessHandler installationHandler(@NotNull String path, @NotNull Function1<? super String, Unit> indicationFunction) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull(indicationFunction, (String)"indicationFunction");
        CapturingProcessHandler handler = new CapturingProcessHandler(INSTANCE.getCommandLine(path));
        handler.addProcessListener((ProcessListener)new ProcessAdapter(indicationFunction){
            final /* synthetic */ Function1 $indicationFunction;

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                Intrinsics.checkParameterIsNotNull(outputType, (String)"outputType");
                if (outputType == ProcessOutputTypes.STDOUT || outputType == ProcessOutputTypes.STDERR) {
                    String[] stringArray = StringUtil.splitByLines((String)event.getText());
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String line2;
                        String string = line2 = stringArray[i];
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"line");
                        this.$indicationFunction.invoke((Object)string);
                    }
                }
            }
            {
                this.$indicationFunction = $captured_local_variable$0;
            }
        });
        return handler;
    }

    @JvmStatic
    @NotNull
    public static final String beatifyPath(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        if (!SystemInfo.isWindows && !StringsKt.startsWith$default((String)path, (String)"/", (boolean)false, (int)2, null)) {
            CharSequence charSequence = path;
            boolean bl = false;
            if (!StringsKt.isBlank((CharSequence)charSequence)) {
                String string;
                String string2 = SystemProperties.getUserHome();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"SystemProperties.getUserHome()");
                String home = string2;
                if (StringsKt.startsWith$default((String)path, (String)"~", (boolean)false, (int)2, null)) {
                    String string3 = path;
                    int n = 1;
                    StringBuilder stringBuilder = new StringBuilder().append(home);
                    boolean bl2 = false;
                    String string4 = string3.substring(n);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
                    String string5 = string4;
                    string = stringBuilder.append(string5).toString();
                } else {
                    String string6 = new File(home, path).getAbsolutePath();
                    string = string6;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"File(home, path).absolutePath");
                }
                return string;
            }
        }
        return path;
    }

    private final boolean checkCondaWrite(@NotNull File $this$checkCondaWrite) {
        boolean bl;
        if ($this$checkCondaWrite.exists()) {
            bl = $this$checkCondaWrite.canWrite();
        } else {
            File file = $this$checkCondaWrite.getParentFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"parentFile");
            bl = this.checkCondaWrite(file);
        }
        return bl;
    }

    private final GeneralCommandLine getCommandLine(String path) {
        GeneralCommandLine generalCommandLine;
        String string = PythonMinicondaLocator.INSTANCE.getMinicondaInstallerPath();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String installerPath = string;
        if (SystemInfo.isWindows) {
            generalCommandLine = new GeneralCommandLine(new String[]{installerPath, "/InstallationType=JustMe", "/AddToPath=0", "/RegisterPython=0", "/S", "/D=" + path});
        } else if (SystemInfo.isLinux || SystemInfo.isMac) {
            generalCommandLine = new GeneralCommandLine(new String[]{"bash", installerPath, "-b", "-p", path});
        } else {
            LOG.error(SystemInfo.OS_NAME + " isn't expected as a operation system");
            throw (Throwable)new IllegalArgumentException("OS " + SystemInfo.OS_NAME + " isn't supported for Miniconda installation");
        }
        return generalCommandLine;
    }

    @JvmStatic
    @Nullable
    public static final String checkPath(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        if (StringsKt.isBlank((CharSequence)path)) {
            return PyBundle.message("action.SetupMiniconda.installDirectoryMissing", new Object[0]);
        }
        File pathFile = new File(path);
        if (pathFile.exists()) {
            return PyBundle.message("action.SetupMiniconda.installDirectoryIsNotEmpty", path);
        }
        if (!INSTANCE.checkCondaWrite(pathFile)) {
            return PyBundle.message("action.SetupMiniconda.canNotWriteToInstallationDirectory", path);
        }
        if (!PythonMinicondaLocator.isInstallerExists()) {
            return PyBundle.message("action.SetupMiniconda.installerMissing", new Object[0]);
        }
        return null;
    }

    private InstallCondaActionImpl() {
    }
}

