/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.intentions.PyBaseIntentionAction;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.PyYieldExpression;
import com.jetbrains.python.refactoring.PyRefactoringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PyConvertMethodToPropertyIntention
extends PyBaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("INTN.convert.method.to.property", new Object[0]);
        if (string == null) {
            PyConvertMethodToPropertyIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = PyBundle.message("INTN.convert.method.to.property", new Object[0]);
        if (string == null) {
            PyConvertMethodToPropertyIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor2, PsiFile file) {
        if (project == null) {
            PyConvertMethodToPropertyIntention.$$$reportNull$$$0(2);
        }
        if (!(file instanceof PyFile)) {
            return false;
        }
        PsiElement element = PyUtil.findNonWhitespaceAtOffset(file, editor2.getCaretModel().getOffset());
        PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class);
        if (function == null) {
            return false;
        }
        PyClass containingClass = function.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        if (function.getParameterList().getParameters().length > 1) {
            return false;
        }
        PyDecoratorList decoratorList = function.getDecoratorList();
        if (decoratorList != null) {
            return false;
        }
        final boolean[] available = new boolean[]{false};
        function.accept(new PyRecursiveElementVisitor(){

            @Override
            public void visitPyReturnStatement(PyReturnStatement node) {
                if (node.getExpression() != null) {
                    available[0] = true;
                }
            }

            @Override
            public void visitPyYieldExpression(PyYieldExpression node) {
                available[0] = true;
            }
        });
        return available[0];
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Override
    public void doInvoke(@NotNull Project project, Editor editor2, PsiFile file) throws IncorrectOperationException {
        PsiElement element;
        PyFunction problemFunction;
        if (project == null) {
            PyConvertMethodToPropertyIntention.$$$reportNull$$$0(3);
        }
        if ((problemFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)(element = PyUtil.findNonWhitespaceAtOffset(file, editor2.getCaretModel().getOffset())), PyFunction.class)) == null) {
            return;
        }
        PyClass containingClass = problemFunction.getContainingClass();
        if (containingClass == null) {
            return;
        }
        List<UsageInfo> usages = PyRefactoringUtil.findUsages(problemFunction, false);
        if (!PyConvertMethodToPropertyIntention.prepareForWrite(file, usages)) {
            return;
        }
        WriteAction.run(() -> {
            PyUtil.addDecorator(problemFunction, "@property");
            PyConvertMethodToPropertyIntention.deleteUsages(usages);
        });
    }

    private static boolean prepareForWrite(PsiFile file, List<UsageInfo> usages) {
        ArrayList toWrite = ContainerUtil.newArrayList((Object[])new PsiElement[]{file});
        toWrite.addAll(ContainerUtil.mapNotNull(usages, UsageInfo::getElement));
        return FileModificationService.getInstance().preparePsiElementsForWrite((Collection)toWrite);
    }

    private static void deleteUsages(List<UsageInfo> usages) {
        for (UsageInfo usage : usages) {
            PyArgumentList argumentList;
            PsiElement parent;
            PsiElement usageElement = usage.getElement();
            if (!(usageElement instanceof PyReferenceExpression) || !((parent = usageElement.getParent()) instanceof PyCallExpression) || (argumentList = ((PyCallExpression)parent).getArgumentList()) == null) continue;
            argumentList.delete();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/intentions/PyConvertMethodToPropertyIntention";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/PyConvertMethodToPropertyIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doInvoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

