/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.google.common.collect.Lists;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeTooltip;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.TooltipWithClickableLinks;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.labels.ActionLink;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.python.debugger.PyDebuggerOptionsProvider;
import com.jetbrains.python.debugger.PySignatureCacheManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class PyDebuggerConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private final PyDebuggerOptionsProvider mySettings;
    private JPanel myMainPanel;
    private JCheckBox myAttachToSubprocess;
    private JCheckBox mySaveSignatures;
    private JCheckBox mySupportGevent;
    private JBCheckBox mySupportQt;
    private JBLabel warningIcon;
    private ComboBox<String> myPyQtBackend;
    private ActionLink myActionLink;
    private JBTextField myAttachProcessFilter;
    private JBLabel myAttachFilterLabel;
    private final List<String> myPyQtBackendsList;
    private final Project myProject;

    public PyDebuggerConfigurable(Project project, PyDebuggerOptionsProvider settings) {
        Object[] objectArray = new String[]{"Auto", "PyQt4", "PyQt5", "PySide", "PySide2"};
        this.$$$setupUI$$$();
        this.myPyQtBackendsList = Lists.newArrayList((Object[])objectArray);
        this.myProject = project;
        this.mySettings = settings;
        this.myPyQtBackendsList.forEach(e -> this.myPyQtBackend.addItem(e));
        this.mySupportQt.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PyDebuggerConfigurable.this.myPyQtBackend.setEnabled(PyDebuggerConfigurable.this.mySupportQt.isSelected());
            }
        });
        this.myAttachFilterLabel.setText("<html>For <b>Attach To Process</b> show processes with names containing:</html>");
    }

    public String getDisplayName() {
        return "Python Debugger";
    }

    public String getHelpTopic() {
        return "reference.idesettings.debugger.python";
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            PyDebuggerConfigurable.$$$reportNull$$$0(0);
        }
        return string;
    }

    public JComponent createComponent() {
        return this.myMainPanel;
    }

    public boolean isModified() {
        return this.myAttachToSubprocess.isSelected() != this.mySettings.isAttachToSubprocess() || this.mySaveSignatures.isSelected() != this.mySettings.isSaveCallSignatures() || this.mySupportGevent.isSelected() != this.mySettings.isSupportGeventDebugging() || this.mySupportQt.isSelected() != this.mySettings.isSupportQtDebugging() || this.myPyQtBackend.getSelectedItem() != null && !this.myPyQtBackend.getSelectedItem().equals(this.mySettings.getPyQtBackend()) || !this.myAttachProcessFilter.getText().equals(this.mySettings.getAttachProcessFilter());
    }

    public void apply() throws ConfigurationException {
        this.mySettings.setAttachToSubprocess(this.myAttachToSubprocess.isSelected());
        this.mySettings.setSaveCallSignatures(this.mySaveSignatures.isSelected());
        this.mySettings.setSupportGeventDebugging(this.mySupportGevent.isSelected());
        this.mySettings.setSupportQtDebugging(this.mySupportQt.isSelected());
        this.mySettings.setPyQtBackend(this.myPyQtBackendsList.get(this.myPyQtBackend.getSelectedIndex()));
        this.mySettings.setAttachProcessFilter(this.myAttachProcessFilter.getText());
    }

    public void reset() {
        this.myAttachToSubprocess.setSelected(this.mySettings.isAttachToSubprocess());
        this.mySaveSignatures.setSelected(this.mySettings.isSaveCallSignatures());
        this.mySupportGevent.setSelected(this.mySettings.isSupportGeventDebugging());
        this.mySupportQt.setSelected(this.mySettings.isSupportQtDebugging());
        this.myPyQtBackend.setSelectedItem((Object)this.mySettings.getPyQtBackend());
        this.myAttachProcessFilter.setText(this.mySettings.getAttachProcessFilter());
    }

    public void disposeUIResources() {
    }

    private void createUIComponents() {
        this.warningIcon = new JBLabel(AllIcons.General.BalloonWarning);
        IdeTooltipManager.getInstance().setCustomTooltip((JComponent)this.warningIcon, (IdeTooltip)new TooltipWithClickableLinks.ForBrowser((JComponent)this.warningIcon, "This option may slow down the debugger"));
        this.myActionLink = new ActionLink("Clear caches", new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                PySignatureCacheManager.getInstance(PyDebuggerConfigurable.this.myProject).clearCache();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/python/debugger/PyDebuggerConfigurable$2", "actionPerformed"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/debugger/PyDebuggerConfigurable", "getId"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBTextField jBTextField;
        JBLabel jBLabel;
        ComboBox comboBox;
        JBCheckBox jBCheckBox;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 6, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myAttachToSubprocess = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Attach to subprocess automatically while debugging");
        jPanel2.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 5, 8, 0, 3, 3, null, null, null));
        this.mySaveSignatures = jCheckBox2 = new JCheckBox();
        jCheckBox2.setActionCommand("Save call signatures");
        jCheckBox2.setLabel("Collect run-time types information for code insight");
        jCheckBox2.setText("Collect run-time types information for code insight");
        jPanel2.add((Component)jCheckBox2, new GridConstraints(1, 0, 1, 3, 8, 0, 3, 3, null, null, null));
        this.mySupportGevent = jCheckBox = new JCheckBox();
        jCheckBox.setText("Gevent compatible");
        jPanel2.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 5, 8, 0, 3, 3, null, null, null));
        this.mySupportQt = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("PyQt compatible");
        jPanel2.add((Component)jBCheckBox, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        JBLabel jBLabel2 = this.warningIcon;
        jPanel2.add((Component)jBLabel2, new GridConstraints(1, 3, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myPyQtBackend = comboBox = new ComboBox();
        jPanel2.add((Component)comboBox, new GridConstraints(3, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("                                             ");
        jPanel2.add((Component)jBLabel3, new GridConstraints(3, 2, 1, 1, 4, 0, 0, 0, null, null, null));
        ActionLink actionLink = this.myActionLink;
        actionLink.setText("Clear caches");
        jPanel2.add((Component)actionLink, new GridConstraints(1, 4, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(1, 5, 1, 1, 0, 1, 6, 1, null, new Dimension(75, 11), null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(2, 0, 1, 3, 0, 2, 1, 6, null, null, null));
        this.myAttachFilterLabel = jBLabel = new JBLabel();
        jBLabel.setText(" For Attach To Process show processes with names containing:");
        jBLabel.putClientProperty((Object)"html.disable", (Object)Boolean.FALSE);
        jPanel.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAttachProcessFilter = jBTextField = new JBTextField();
        jBTextField.setEnabled(true);
        jBTextField.setText("python");
        jPanel.add((Component)jBTextField, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 3, null, new Dimension(150, -1), null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(1, 2, 1, 1, 0, 1, 2, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

