/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation.docstrings;

import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class DocStringBuilder<This extends DocStringBuilder> {
    private final List<String> myLines = new ArrayList<String>();

    @NotNull
    public This addLine(@NotNull String line2) {
        if (line2 == null) {
            DocStringBuilder.$$$reportNull$$$0(0);
        }
        This This = this.addLine(line2, this.myLines.size());
        if (This == null) {
            DocStringBuilder.$$$reportNull$$$0(1);
        }
        return This;
    }

    @NotNull
    public This addLine(@NotNull String line2, int index) {
        if (line2 == null) {
            DocStringBuilder.$$$reportNull$$$0(2);
        }
        this.myLines.add(index, line2);
        DocStringBuilder docStringBuilder = this;
        if (docStringBuilder == null) {
            DocStringBuilder.$$$reportNull$$$0(3);
        }
        return (This)docStringBuilder;
    }

    @NotNull
    public This addEmptyLine() {
        This This = this.addLine("", this.myLines.size());
        if (This == null) {
            DocStringBuilder.$$$reportNull$$$0(4);
        }
        return This;
    }

    @NotNull
    public This addEmptyLine(int index) {
        This This = this.addLine("", index);
        if (This == null) {
            DocStringBuilder.$$$reportNull$$$0(5);
        }
        return This;
    }

    @NotNull
    public List<String> getLines() {
        List<String> list = Collections.unmodifiableList(this.myLines);
        if (list == null) {
            DocStringBuilder.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public String buildContent(int indent, boolean indentFirst) {
        String string = this.buildContent(StringUtil.repeatSymbol((char)' ', (int)indent), indentFirst);
        if (string == null) {
            DocStringBuilder.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String buildContent(@NotNull String indentation, boolean indentFirst) {
        if (indentation == null) {
            DocStringBuilder.$$$reportNull$$$0(8);
        }
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (String line2 : this.myLines) {
            if (!first) {
                result.append('\n');
            }
            if (!StringUtil.isEmptyOrSpaces((String)line2)) {
                if (!first || indentFirst) {
                    result.append(indentation);
                }
                result.append(line2);
            }
            first = false;
        }
        String string = result.toString();
        if (string == null) {
            DocStringBuilder.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/documentation/docstrings/DocStringBuilder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/documentation/docstrings/DocStringBuilder";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "addLine";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "addEmptyLine";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLines";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "buildContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addLine";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "buildContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

