/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.module;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ContentFolder;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.actions.ContentEntryEditingAction;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.python.module.PyContentEntriesEditor;
import java.awt.Color;
import javax.swing.Icon;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PyRootTypeProvider {
    public static final ExtensionPointName<PyRootTypeProvider> EP_NAME = ExtensionPointName.create((String)"Pythonid.pyRootTypeProvider");
    protected final VirtualFilePointerListener DUMMY_LISTENER = new VirtualFilePointerListener(){};

    public abstract void reset(@NotNull Disposable var1, PyContentEntriesEditor var2, @NotNull Module var3);

    public abstract void apply(Module var1);

    public abstract boolean isModified(Module var1);

    public abstract boolean isMine(ContentFolder var1);

    public void removeRoot(ContentEntry contentEntry, @NotNull VirtualFilePointer root, ModifiableRootModel model) {
        if (root == null) {
            PyRootTypeProvider.$$$reportNull$$$0(0);
        }
        this.getRoots().remove((Object)contentEntry, (Object)root);
    }

    public abstract MultiMap<ContentEntry, VirtualFilePointer> getRoots();

    public abstract Icon getIcon();

    public abstract String getName();

    public String getNamePlural() {
        return this.getName() + "s";
    }

    public abstract Color getColor();

    @Nullable
    public CustomShortcutSet getShortcut() {
        return null;
    }

    public void disposeUIResources(@NotNull Module module2) {
        if (module2 == null) {
            PyRootTypeProvider.$$$reportNull$$$0(1);
        }
    }

    private void addRoot(VirtualFilePointer root, PyContentEntriesEditor editor2) {
        editor2.getContentEntryEditor().addRoot(this, root);
        editor2.getWarningPanel().getValidatorsManager().validate();
    }

    protected void removeRoot(VirtualFile selectedFile, PyContentEntriesEditor editor2, ModifiableRootModel model) {
        editor2.getContentEntryEditor().removeRoot(null, selectedFile.getUrl(), this);
        editor2.getWarningPanel().getValidatorsManager().validate();
    }

    protected boolean hasRoot(VirtualFile file, PyContentEntriesEditor editor2) {
        PyContentEntriesEditor.MyContentEntryEditor entryEditor = editor2.getContentEntryEditor();
        return entryEditor.getRoot(this, file.getUrl()) != null;
    }

    public abstract ContentEntryEditingAction createRootEntryEditingAction(JTree var1, Disposable var2, PyContentEntriesEditor var3, ModifiableRootModel var4);

    public abstract ContentFolder[] createFolders(ContentEntry var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/module/PyRootTypeProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "removeRoot";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "disposeUIResources";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected class RootEntryEditingAction
    extends ContentEntryEditingAction {
        private final Disposable myDisposable;
        private final PyContentEntriesEditor myEditor;
        private final ModifiableRootModel myModel;

        public RootEntryEditingAction(JTree tree, Disposable disposable, PyContentEntriesEditor editor2, ModifiableRootModel model) {
            super(tree);
            Presentation templatePresentation = this.getTemplatePresentation();
            templatePresentation.setText(PyRootTypeProvider.this.getNamePlural());
            templatePresentation.setDescription(PyRootTypeProvider.this.getName() + " Folders");
            templatePresentation.setIcon(PyRootTypeProvider.this.getIcon());
            this.myDisposable = disposable;
            this.myEditor = editor2;
            this.myModel = model;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            VirtualFile[] selectedFiles;
            if (e == null) {
                RootEntryEditingAction.$$$reportNull$$$0(0);
            }
            return (selectedFiles = this.getSelectedFiles()).length != 0 && PyRootTypeProvider.this.hasRoot(selectedFiles[0], this.myEditor);
        }

        public void setSelected(@NotNull AnActionEvent e, boolean isSelected) {
            if (e == null) {
                RootEntryEditingAction.$$$reportNull$$$0(1);
            }
            VirtualFile[] selectedFiles = this.getSelectedFiles();
            assert (selectedFiles.length != 0);
            for (VirtualFile selectedFile : selectedFiles) {
                boolean wasSelected = PyRootTypeProvider.this.hasRoot(selectedFile, this.myEditor);
                if (isSelected) {
                    if (wasSelected) continue;
                    VirtualFilePointer root = VirtualFilePointerManager.getInstance().create(selectedFile, this.myDisposable, PyRootTypeProvider.this.DUMMY_LISTENER);
                    PyRootTypeProvider.this.addRoot(root, this.myEditor);
                    continue;
                }
                if (!wasSelected) continue;
                PyRootTypeProvider.this.removeRoot(selectedFile, this.myEditor, this.myModel);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/jetbrains/python/module/PyRootTypeProvider$RootEntryEditingAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

