/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.run;

import com.google.common.net.HostAndPort;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.Key;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import com.jetbrains.python.run.PyRemoteProcessStarterManagerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyRemoteProcessStarter {
    public static final Key<Boolean> OPEN_FOR_INCOMING_CONNECTION = Key.create((String)"OPEN_FOR_INCOMING_CONNECTION");
    public static final Key<HostAndPort> WEB_SERVER_HOST_AND_PORT = new Key("WEB_SERVER_HOST_AND_PORT");

    public ProcessHandler startRemoteProcess(@NotNull Sdk sdk, @NotNull GeneralCommandLine commandLine, @Nullable Project project, @Nullable PyRemotePathMapper pathMapper) throws ExecutionException {
        PythonRemoteInterpreterManager manager;
        if (sdk == null) {
            PyRemoteProcessStarter.$$$reportNull$$$0(0);
        }
        if (commandLine == null) {
            PyRemoteProcessStarter.$$$reportNull$$$0(1);
        }
        if ((manager = PythonRemoteInterpreterManager.getInstance()) != null) {
            ProcessHandler processHandler;
            try {
                processHandler = this.doStartRemoteProcess(sdk, commandLine, manager, project, pathMapper);
            }
            catch (ExecutionException e) {
                Application application = ApplicationManager.getApplication();
                if (application != null && (application.isUnitTestMode() || application.isHeadlessEnvironment())) {
                    throw new RuntimeException(e);
                }
                throw new ExecutionException("Can't run remote python interpreter: " + e.getMessage(), (Throwable)e);
            }
            ProcessTerminatedListener.attach((ProcessHandler)processHandler);
            return processHandler;
        }
        throw new PythonRemoteInterpreterManager.PyRemoteInterpreterExecutionException();
    }

    protected ProcessHandler doStartRemoteProcess(@NotNull Sdk sdk, @NotNull GeneralCommandLine commandLine, @NotNull PythonRemoteInterpreterManager manager, @Nullable Project project, @Nullable PyRemotePathMapper pathMapper) throws ExecutionException {
        if (sdk == null) {
            PyRemoteProcessStarter.$$$reportNull$$$0(2);
        }
        if (commandLine == null) {
            PyRemoteProcessStarter.$$$reportNull$$$0(3);
        }
        if (manager == null) {
            PyRemoteProcessStarter.$$$reportNull$$$0(4);
        }
        SdkAdditionalData data = sdk.getSdkAdditionalData();
        assert (data instanceof PyRemoteSdkAdditionalDataBase);
        PyRemoteSdkAdditionalDataBase pyRemoteSdkAdditionalDataBase = (PyRemoteSdkAdditionalDataBase)data;
        PyRemotePathMapper extendedPathMapper = manager.setupMappings(project, pyRemoteSdkAdditionalDataBase, pathMapper);
        try {
            return PyRemoteProcessStarterManagerUtil.getManager(pyRemoteSdkAdditionalDataBase).startRemoteProcess(project, commandLine, manager, pyRemoteSdkAdditionalDataBase, extendedPathMapper);
        }
        catch (InterruptedException e) {
            throw new ExecutionException((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/run/PyRemoteProcessStarter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "startRemoteProcess";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doStartRemoteProcess";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

