/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.ide.DataManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.reference.SoftReference;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.ExceptionFix;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkCredentialsHolder;
import com.intellij.remote.VagrantBasedCredentialsHolder;
import com.intellij.remote.VagrantNotStartedException;
import com.intellij.remote.ext.CredentialsCase;
import com.intellij.remote.ext.LanguageCaseCollector;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.PythonHelper;
import com.jetbrains.python.codeInsight.typing.PyTypeShed;
import com.jetbrains.python.codeInsight.userSkeletons.PyUserSkeletonsUtil;
import com.jetbrains.python.facet.PythonFacetSettings;
import com.jetbrains.python.packaging.PyCondaPackageManagerImpl;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.search.PyProjectScopeBuilder;
import com.jetbrains.python.remote.PyCredentialsContribution;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import com.jetbrains.python.run.PyVirtualEnvReader;
import com.jetbrains.python.sdk.InvalidSdkException;
import com.jetbrains.python.sdk.PreferredSdkComparator;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.PyRemoteSdkValidator;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkUpdater;
import com.jetbrains.python.sdk.add.PyAddSdkDialog;
import com.jetbrains.python.sdk.flavors.CPythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import com.jetbrains.python.sdk.pipenv.PyPipEnvSdkAdditionalData;
import com.jetbrains.python.sdk.skeletons.PySkeletonRefresher;
import icons.PythonIcons;
import java.awt.Component;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PythonSdkType
extends SdkType {
    public static final String REMOTE_SOURCES_DIR_NAME = "remote_sources";
    private static final Logger LOG = Logger.getInstance(PythonSdkType.class);
    private static final String[] WINDOWS_EXECUTABLE_SUFFIXES = new String[]{"cmd", "exe", "bat", "com"};
    private static final int MINUTE = 60000;
    @NonNls
    private static final String SKELETONS_TOPIC = "Skeletons";
    private static final String[] DIRS_WITH_BINARY = new String[]{"", "bin", "Scripts", "net45"};
    private static final String[] UNIX_BINARY_NAMES = new String[]{"jython", "pypy", "python", "python3"};
    private static final String[] WIN_BINARY_NAMES = new String[]{"jython.bat", "ipy.exe", "pypy.exe", "python.exe", "python3.exe"};
    private static final Key<WeakReference<Component>> SDK_CREATOR_COMPONENT_KEY = Key.create((String)"#com.jetbrains.python.sdk.creatorComponent");
    private static final Predicate<Sdk> REMOTE_SDK_PREDICATE = PythonSdkType::isRemote;
    private static final Key<Map<String, String>> ENVIRONMENT_KEY = Key.create((String)"ENVIRONMENT_KEY");
    public static final String SKELETON_DIR_NAME = "python_stubs";
    public static final OrderRootType BUILTIN_ROOT_TYPE = OrderRootType.CLASSES;

    public static PythonSdkType getInstance() {
        return (PythonSdkType)SdkType.findInstance(PythonSdkType.class);
    }

    private PythonSdkType() {
        super("Python SDK");
    }

    public Icon getIcon() {
        return PythonIcons.Python.Python;
    }

    @NotNull
    public String getHelpTopic() {
        if ("reference.project.structure.sdk.python" == null) {
            PythonSdkType.$$$reportNull$$$0(0);
        }
        return "reference.project.structure.sdk.python";
    }

    @NotNull
    public Icon getIconForAddAction() {
        Icon icon = PythonFileType.INSTANCE.getIcon();
        if (icon == null) {
            PythonSdkType.$$$reportNull$$$0(1);
        }
        return icon;
    }

    @NotNull
    @NonNls
    public static String getBuiltinsFileName(@NotNull Sdk sdk) {
        LanguageLevel level;
        if (sdk == null) {
            PythonSdkType.$$$reportNull$$$0(2);
        }
        String string = (level = PythonSdkType.getLanguageLevelForSdk(sdk)).isPython2() ? "__builtin__.py" : "builtins.py";
        if (string == null) {
            PythonSdkType.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NonNls
    @Nullable
    public String suggestHomePath() {
        Sdk[] existingSdks = ProjectJdkTable.getInstance().getAllJdks();
        List<PyDetectedSdk> sdks = PySdkExtKt.detectSystemWideSdks(null, Arrays.asList(existingSdks));
        PyDetectedSdk latest = StreamEx.of(sdks).findFirst().orElse(null);
        if (latest != null) {
            return latest.getHomePath();
        }
        return null;
    }

    public static boolean hasValidSdk() {
        for (Sdk sdk : ProjectJdkTable.getInstance().getAllJdks()) {
            if (!(sdk.getSdkType() instanceof PythonSdkType)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidSdkHome(@Nullable String path) {
        return PythonSdkFlavor.getFlavor(path) != null;
    }

    public static boolean isInvalid(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkType.$$$reportNull$$$0(4);
        }
        if (PythonSdkType.isRemote(sdk)) {
            return PyRemoteSdkValidator.Companion.isInvalid(sdk);
        }
        VirtualFile interpreter = sdk.getHomeDirectory();
        return interpreter == null || !interpreter.exists();
    }

    public static boolean isRemote(@Nullable Sdk sdk) {
        return PySdkUtil.isRemote(sdk);
    }

    public static boolean isVagrant(@Nullable Sdk sdk) {
        if (sdk != null && sdk.getSdkAdditionalData() instanceof PyRemoteSdkAdditionalDataBase) {
            PyRemoteSdkAdditionalDataBase data = (PyRemoteSdkAdditionalDataBase)sdk.getSdkAdditionalData();
            return data.connectionCredentials().getRemoteConnectionType() == CredentialsType.VAGRANT;
        }
        return false;
    }

    public static boolean isRemote(@Nullable String sdkPath) {
        return PythonSdkType.isRemote(PythonSdkType.findSdkByPath(sdkPath));
    }

    @NotNull
    public FileChooserDescriptor getHomeChooserDescriptor() {
        final boolean isWindows = SystemInfo.isWindows;
        FileChooserDescriptor fileChooserDescriptor = new FileChooserDescriptor(true, false, false, false, false, false){

            public void validateSelectedFiles(@NotNull VirtualFile[] files) throws Exception {
                if (files == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (files.length != 0 && !PythonSdkType.this.isValidSdkHome(files[0].getPath())) {
                    throw new Exception(PyBundle.message("sdk.error.invalid.interpreter.name.$0", files[0].getName()));
                }
            }

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                if (!file.isDirectory() && isWindows) {
                    String path = file.getPath();
                    boolean looksExecutable = false;
                    for (String ext : WINDOWS_EXECUTABLE_SUFFIXES) {
                        if (!path.endsWith(ext)) continue;
                        looksExecutable = true;
                        break;
                    }
                    return looksExecutable && super.isFileVisible(file, showHiddenFiles);
                }
                return super.isFileVisible(file, showHiddenFiles);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/jetbrains/python/sdk/PythonSdkType$1", "validateSelectedFiles"));
            }
        }.withTitle(PyBundle.message("sdk.select.path", new Object[0])).withShowHiddenFiles(SystemInfo.isUnix);
        if (fileChooserDescriptor == null) {
            PythonSdkType.$$$reportNull$$$0(5);
        }
        return fileChooserDescriptor;
    }

    public boolean supportsCustomCreateUI() {
        return true;
    }

    public void showCustomCreateUI(@NotNull SdkModel sdkModel, @NotNull JComponent parentComponent, @NotNull Consumer<Sdk> sdkCreatedCallback) {
        if (sdkModel == null) {
            PythonSdkType.$$$reportNull$$$0(6);
        }
        if (parentComponent == null) {
            PythonSdkType.$$$reportNull$$$0(7);
        }
        if (sdkCreatedCallback == null) {
            PythonSdkType.$$$reportNull$$$0(8);
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)parentComponent));
        PyAddSdkDialog.show(project, null, Arrays.asList(sdkModel.getSdks()), sdk -> {
            if (sdk != null) {
                sdk.putUserData(SDK_CREATOR_COMPONENT_KEY, new WeakReference<JComponent>(parentComponent));
                sdkCreatedCallback.consume(sdk);
            }
        });
    }

    public static boolean isVirtualEnv(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkType.$$$reportNull$$$0(9);
        }
        String path = sdk.getHomePath();
        return PythonSdkType.isVirtualEnv(path);
    }

    @Contract(value="null -> false")
    public static boolean isVirtualEnv(@Nullable String path) {
        return path != null && PythonSdkType.getVirtualEnvRoot(path) != null;
    }

    public static boolean isConda(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkType.$$$reportNull$$$0(10);
        }
        return PyCondaPackageManagerImpl.isConda(sdk);
    }

    public static boolean isConda(@Nullable String sdkPath) {
        return PyCondaPackageManagerImpl.isConda(sdkPath);
    }

    public static boolean isCondaVirtualEnv(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkType.$$$reportNull$$$0(11);
        }
        return PyCondaPackageManagerImpl.isCondaVirtualEnv(sdk);
    }

    @Nullable
    public Sdk getVirtualEnvBaseSdk(Sdk sdk) {
        if (PythonSdkType.isVirtualEnv(sdk)) {
            PythonSdkFlavor flavor = PythonSdkFlavor.getFlavor(sdk);
            String version = this.getVersionString(sdk);
            if (flavor != null && version != null) {
                for (Sdk baseSdk : PythonSdkType.getAllSdks()) {
                    if (PythonSdkType.isRemote(baseSdk)) continue;
                    PythonSdkFlavor baseFlavor = PythonSdkFlavor.getFlavor(baseSdk);
                    if (PythonSdkType.isVirtualEnv(baseSdk) || !flavor.equals(baseFlavor) || !version.equals(this.getVersionString(baseSdk))) continue;
                    return baseSdk;
                }
            }
        }
        return null;
    }

    @Nullable
    public static File getVirtualEnvRoot(@NotNull String binaryPath) {
        String rootPath;
        File bin;
        if (binaryPath == null) {
            PythonSdkType.$$$reportNull$$$0(12);
        }
        if ((bin = new File(binaryPath).getParentFile()) != null && (rootPath = bin.getParent()) != null) {
            File activate;
            File root = new File(rootPath);
            File activateThis = new File(bin, "activate_this.py");
            if (activateThis.exists() && (activate = PythonSdkType.findExecutableFile(bin, "activate")) != null) {
                return root;
            }
            if (new File(root, "pyvenv.cfg").exists()) {
                return root;
            }
        }
        return null;
    }

    @Nullable
    public static File findExecutableFile(File parent, String name) {
        File file;
        if (SystemInfo.isWindows) {
            for (String suffix : WINDOWS_EXECUTABLE_SUFFIXES) {
                File file2 = new File(parent, name + "." + suffix);
                if (!file2.exists()) continue;
                return file2;
            }
        } else if (SystemInfo.isUnix && (file = new File(parent, name)).exists()) {
            return file;
        }
        return null;
    }

    public static void patchCommandLineForVirtualenv(GeneralCommandLine commandLine, String sdkHome, boolean passParentEnvironment) {
        Map<String, String> virtualEnv = PythonSdkType.activateVirtualEnv(sdkHome);
        if (!virtualEnv.isEmpty()) {
            Map environment = commandLine.getEnvironment();
            for (Map.Entry<String, String> entry : virtualEnv.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (environment.containsKey(key)) {
                    if (!key.equalsIgnoreCase("PATH")) continue;
                    PythonEnvUtil.addToPathEnvVar((String)environment.get(key), value, false);
                    continue;
                }
                environment.put(key, value);
            }
        }
    }

    @NotNull
    public String suggestSdkName(@Nullable String currentSdkName, String sdkHome) {
        String name = StringUtil.notNullize((String)PythonSdkType.suggestBaseSdkName(sdkHome), (String)"Unknown");
        File virtualEnvRoot = PythonSdkType.getVirtualEnvRoot(sdkHome);
        if (virtualEnvRoot != null) {
            String path = FileUtil.getLocationRelativeToUserHome((String)virtualEnvRoot.getAbsolutePath());
            String string = name + " virtualenv at " + path;
            if (string == null) {
                PythonSdkType.$$$reportNull$$$0(13);
            }
            return string;
        }
        String string = name;
        if (string == null) {
            PythonSdkType.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Nullable
    public static String suggestBaseSdkName(@NotNull String sdkHome) {
        PythonSdkFlavor flavor;
        if (sdkHome == null) {
            PythonSdkType.$$$reportNull$$$0(15);
        }
        if ((flavor = PythonSdkFlavor.getFlavor(sdkHome)) == null) {
            return null;
        }
        return flavor.getName() + " " + (Object)((Object)flavor.getLanguageLevel(sdkHome));
    }

    @Nullable
    public AdditionalDataConfigurable createAdditionalDataConfigurable(@NotNull SdkModel sdkModel, @NotNull SdkModificator sdkModificator) {
        if (sdkModel == null) {
            PythonSdkType.$$$reportNull$$$0(16);
        }
        if (sdkModificator == null) {
            PythonSdkType.$$$reportNull$$$0(17);
        }
        return null;
    }

    public void saveAdditionalData(@NotNull SdkAdditionalData additionalData, @NotNull Element additional) {
        if (additionalData == null) {
            PythonSdkType.$$$reportNull$$$0(18);
        }
        if (additional == null) {
            PythonSdkType.$$$reportNull$$$0(19);
        }
        if (additionalData instanceof PythonSdkAdditionalData) {
            ((PythonSdkAdditionalData)additionalData).save(additional);
        }
    }

    public SdkAdditionalData loadAdditionalData(@NotNull Sdk currentSdk, @NotNull Element additional) {
        PythonRemoteInterpreterManager manager;
        if (currentSdk == null) {
            PythonSdkType.$$$reportNull$$$0(20);
        }
        if (additional == null) {
            PythonSdkType.$$$reportNull$$$0(21);
        }
        if (RemoteSdkCredentialsHolder.isRemoteSdk((String)currentSdk.getHomePath()) && (manager = PythonRemoteInterpreterManager.getInstance()) != null) {
            return manager.loadRemoteSdkData(currentSdk, additional);
        }
        PyPipEnvSdkAdditionalData pipEnvData = PyPipEnvSdkAdditionalData.load(additional);
        if (pipEnvData != null) {
            return pipEnvData;
        }
        return PythonSdkAdditionalData.load(currentSdk, additional);
    }

    public static boolean isSkeletonsPath(String path) {
        return path.contains(SKELETON_DIR_NAME);
    }

    @NotNull
    @NonNls
    public String getPresentableName() {
        if ("Python SDK" == null) {
            PythonSdkType.$$$reportNull$$$0(22);
        }
        return "Python SDK";
    }

    @NotNull
    public String sdkPath(@NotNull VirtualFile homePath) {
        VirtualFile sdkPath;
        String path;
        PythonSdkFlavor flavor;
        if (homePath == null) {
            PythonSdkType.$$$reportNull$$$0(23);
        }
        if ((flavor = PythonSdkFlavor.getFlavor(path = super.sdkPath(homePath))) != null && (sdkPath = flavor.getSdkPath(homePath)) != null) {
            String string = FileUtil.toSystemDependentName((String)sdkPath.getPath());
            if (string == null) {
                PythonSdkType.$$$reportNull$$$0(24);
            }
            return string;
        }
        String string = FileUtil.toSystemDependentName((String)path);
        if (string == null) {
            PythonSdkType.$$$reportNull$$$0(25);
        }
        return string;
    }

    public void setupSdkPaths(@NotNull Sdk sdk) {
        WeakReference ownerComponentRef;
        Component ownerComponent;
        if (sdk == null) {
            PythonSdkType.$$$reportNull$$$0(26);
        }
        Project project = (ownerComponent = (Component)SoftReference.dereference((Reference)(ownerComponentRef = (WeakReference)sdk.getUserData(SDK_CREATOR_COMPONENT_KEY)))) != null ? (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext(ownerComponent)) : (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext());
        PythonSdkUpdater.updateOrShowError(sdk, null, project, ownerComponent);
    }

    public boolean setupSdkPaths(@NotNull Sdk sdk, @NotNull SdkModel sdkModel) {
        if (sdk == null) {
            PythonSdkType.$$$reportNull$$$0(27);
        }
        if (sdkModel == null) {
            PythonSdkType.$$$reportNull$$$0(28);
        }
        return true;
    }

    public static void notifyRemoteSdkSkeletonsFail(InvalidSdkException e, @Nullable Runnable restartAction) {
        String notificationMessage;
        NotificationListener notificationListener;
        if (e.getCause() instanceof VagrantNotStartedException) {
            notificationListener = (notification2, event) -> {
                PythonRemoteInterpreterManager manager = PythonRemoteInterpreterManager.getInstance();
                if (manager != null) {
                    try {
                        VagrantNotStartedException cause = (VagrantNotStartedException)e.getCause();
                        manager.runVagrant(cause.getVagrantFolder(), cause.getMachineName());
                    }
                    catch (ExecutionException e1) {
                        throw new RuntimeException(e1);
                    }
                }
                if (restartAction != null) {
                    restartAction.run();
                }
            };
            notificationMessage = e.getMessage() + "\n<a href=\"#\">Launch vagrant and refresh skeletons</a>";
        } else if (ExceptionUtil.causedBy((Throwable)e, ExceptionFix.class)) {
            ExceptionFix fix = (ExceptionFix)ExceptionUtil.findCause((Throwable)e, ExceptionFix.class);
            notificationListener = (notification2, event) -> {
                fix.apply();
                if (restartAction != null) {
                    restartAction.run();
                }
            };
            notificationMessage = fix.getNotificationMessage(e.getMessage());
        } else {
            notificationListener = null;
            notificationMessage = e.getMessage();
        }
        Notifications.Bus.notify((Notification)new Notification(SKELETONS_TOPIC, "Couldn't refresh skeletons for remote interpreter", notificationMessage, NotificationType.WARNING, notificationListener));
    }

    @NotNull
    public static VirtualFile getSdkRootVirtualFile(@NotNull VirtualFile path) {
        VirtualFile jar;
        String suffix;
        if (path == null) {
            PythonSdkType.$$$reportNull$$$0(29);
        }
        if ((suffix = path.getExtension()) != null) {
            suffix = StringUtil.toLowerCase((String)suffix);
        }
        if (!path.isDirectory() && ("zip".equals(suffix) || "egg".equals(suffix)) && (jar = JarFileSystem.getInstance().getJarRootForLocalFile(path)) != null) {
            VirtualFile virtualFile = jar;
            if (virtualFile == null) {
                PythonSdkType.$$$reportNull$$$0(30);
            }
            return virtualFile;
        }
        VirtualFile virtualFile = path;
        if (virtualFile == null) {
            PythonSdkType.$$$reportNull$$$0(31);
        }
        return virtualFile;
    }

    public static String getSkeletonsPath(String basePath, String sdkHome) {
        String sep = File.separator;
        return PythonSdkType.getSkeletonsRootPath(basePath) + sep + FileUtil.toSystemIndependentName((String)sdkHome).hashCode() + sep;
    }

    public static String getSkeletonsRootPath(String basePath) {
        return basePath + File.separator + SKELETON_DIR_NAME;
    }

    @NotNull
    public static List<String> getSysPath(String bin_path) throws InvalidSdkException {
        String working_dir = new File(bin_path).getParent();
        Application application = ApplicationManager.getApplication();
        if (application != null && (!application.isUnitTestMode() || ApplicationInfoImpl.isInStressTest())) {
            List<String> list = PythonSdkType.getSysPathsFromScript(bin_path);
            if (list == null) {
                PythonSdkType.$$$reportNull$$$0(32);
            }
            return list;
        }
        ArrayList<String> ret = new ArrayList<String>(1);
        ret.add(working_dir);
        ArrayList<String> arrayList = ret;
        if (arrayList == null) {
            PythonSdkType.$$$reportNull$$$0(33);
        }
        return arrayList;
    }

    @NotNull
    public static List<String> getSysPathsFromScript(@NotNull String binaryPath) throws InvalidSdkException {
        GeneralCommandLine cmd;
        ProcessOutput runResult;
        if (binaryPath == null) {
            PythonSdkType.$$$reportNull$$$0(34);
        }
        if (!(runResult = PySdkUtil.getProcessOutput(cmd = PythonHelper.SYSPATH.newCommandLine(binaryPath, (List<String>)Lists.newArrayList()), new File(binaryPath).getParent(), PythonSdkType.activateVirtualEnv(binaryPath), 60000)).checkSuccess(LOG)) {
            throw new InvalidSdkException(String.format("Failed to determine Python's sys.path value:\nSTDOUT: %s\nSTDERR: %s", runResult.getStdout(), runResult.getStderr()));
        }
        List list = runResult.getStdoutLines();
        if (list == null) {
            PythonSdkType.$$$reportNull$$$0(35);
        }
        return list;
    }

    @Nullable
    public String getVersionString(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkType.$$$reportNull$$$0(36);
        }
        if (PythonSdkType.isRemote(sdk)) {
            PyRemoteSdkAdditionalDataBase data = (PyRemoteSdkAdditionalDataBase)sdk.getSdkAdditionalData();
            assert (data != null);
            String versionString = data.getVersionString();
            if (StringUtil.isEmpty((String)versionString)) {
                PythonRemoteInterpreterManager remoteInterpreterManager = PythonRemoteInterpreterManager.getInstance();
                if (remoteInterpreterManager != null) {
                    try {
                        versionString = remoteInterpreterManager.getInterpreterVersion(null, data);
                    }
                    catch (Exception e) {
                        LOG.warn("Couldn't get interpreter version:" + e.getMessage(), (Throwable)e);
                        versionString = "undefined";
                    }
                }
                data.setVersionString(versionString);
            }
            return versionString;
        }
        return this.getVersionString(sdk.getHomePath());
    }

    @Nullable
    public String getVersionString(@Nullable String sdkHome) {
        PythonSdkFlavor flavor = PythonSdkFlavor.getFlavor(sdkHome);
        return flavor != null ? flavor.getVersionString(sdkHome) : null;
    }

    public static List<Sdk> getAllSdks() {
        return ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)PythonSdkType.getInstance());
    }

    @Nullable
    public static Sdk findPythonSdk(@Nullable Module module2) {
        Facet[] facets;
        if (module2 == null) {
            return null;
        }
        Sdk sdk = ModuleRootManager.getInstance((Module)module2).getSdk();
        if (sdk != null && sdk.getSdkType() instanceof PythonSdkType) {
            return sdk;
        }
        for (Facet facet : facets = FacetManager.getInstance((Module)module2).getAllFacets()) {
            FacetConfiguration configuration = facet.getConfiguration();
            if (!(configuration instanceof PythonFacetSettings)) continue;
            return ((PythonFacetSettings)configuration).getSdk();
        }
        return null;
    }

    @Nullable
    public static Sdk findPythonSdk(@NotNull PsiElement element) {
        if (element == null) {
            PythonSdkType.$$$reportNull$$$0(37);
        }
        return PythonSdkType.findPythonSdk(ModuleUtilCore.findModuleForPsiElement((PsiElement)element));
    }

    @Nullable
    public static Sdk findSdkByPath(@Nullable String path) {
        if (path != null) {
            return PythonSdkType.findSdkByPath(PythonSdkType.getAllSdks(), path);
        }
        return null;
    }

    @Nullable
    public static Sdk findSdkByPath(List<? extends Sdk> sdkList, @Nullable String path) {
        if (path != null) {
            for (Sdk sdk : sdkList) {
                if (sdk == null || !FileUtil.pathsEqual((String)path, (String)sdk.getHomePath())) continue;
                return sdk;
            }
        }
        return null;
    }

    @NotNull
    public static LanguageLevel getLanguageLevelForSdk(@Nullable Sdk sdk) {
        PythonSdkFlavor flavor;
        if (sdk != null && sdk.getSdkType() instanceof PythonSdkType && (flavor = PythonSdkFlavor.getFlavor(sdk)) != null) {
            LanguageLevel languageLevel = flavor.getLanguageLevel(sdk);
            if (languageLevel == null) {
                PythonSdkType.$$$reportNull$$$0(38);
            }
            return languageLevel;
        }
        LanguageLevel languageLevel = LanguageLevel.getDefault();
        if (languageLevel == null) {
            PythonSdkType.$$$reportNull$$$0(39);
        }
        return languageLevel;
    }

    public boolean isRootTypeApplicable(@NotNull OrderRootType type) {
        if (type == null) {
            PythonSdkType.$$$reportNull$$$0(40);
        }
        return type == OrderRootType.CLASSES;
    }

    public boolean sdkHasValidPath(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkType.$$$reportNull$$$0(41);
        }
        if (PySdkUtil.isRemote(sdk)) {
            return true;
        }
        VirtualFile homeDir = sdk.getHomeDirectory();
        return homeDir != null && homeDir.isValid();
    }

    public static boolean isStdLib(@NotNull VirtualFile vFile, @Nullable Sdk pythonSdk2) {
        if (vFile == null) {
            PythonSdkType.$$$reportNull$$$0(42);
        }
        if (pythonSdk2 != null) {
            VirtualFile libDir;
            VirtualFile originFile = vFile;
            String originPath = vFile.getPath();
            boolean checkOnRemoteFS = false;
            PySkeletonRefresher.SkeletonHeader header = PythonSdkType.readSkeletonHeader(originFile, pythonSdk2);
            if (header != null) {
                if (ApplicationManager.getApplication().isUnitTestMode() && Objects.equals(vFile.getParent(), PySdkUtil.findSkeletonsDir(pythonSdk2))) {
                    return true;
                }
                String binaryPath = header.getBinaryFile();
                if (binaryPath.equals("(built-in)") || binaryPath.equals("(pre-generated)")) {
                    return true;
                }
                if (PythonSdkType.isRemote(pythonSdk2)) {
                    checkOnRemoteFS = true;
                    originFile = null;
                } else {
                    originFile = VfsUtil.findFileByIoFile((File)new File(binaryPath), (boolean)true);
                }
                originPath = binaryPath;
            }
            if (originFile != null) {
                originFile = (VirtualFile)ObjectUtils.notNull((Object)originFile.getCanonicalFile(), (Object)originFile);
                originPath = originFile.getPath();
            }
            if ((libDir = PyProjectScopeBuilder.findLibDir(pythonSdk2)) != null && PythonSdkType.isUnderLibDirButNotSitePackages(originFile, originPath, libDir, pythonSdk2, checkOnRemoteFS)) {
                return true;
            }
            VirtualFile venvLibDir = PyProjectScopeBuilder.findVirtualEnvLibDir(pythonSdk2);
            if (venvLibDir != null && PythonSdkType.isUnderLibDirButNotSitePackages(originFile, originPath, venvLibDir, pythonSdk2, checkOnRemoteFS)) {
                return true;
            }
            if (PyUserSkeletonsUtil.isStandardLibrarySkeleton(vFile)) {
                return true;
            }
            if (PyTypeShed.INSTANCE.isInStandardLibrary(vFile) && PyTypeShed.INSTANCE.isInside(vFile)) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static PySkeletonRefresher.SkeletonHeader readSkeletonHeader(@NotNull VirtualFile file, @NotNull Sdk pythonSdk2) {
        VirtualFile skeletonsDir;
        if (file == null) {
            PythonSdkType.$$$reportNull$$$0(43);
        }
        if (pythonSdk2 == null) {
            PythonSdkType.$$$reportNull$$$0(44);
        }
        if ((skeletonsDir = PySdkUtil.findSkeletonsDir(pythonSdk2)) != null && VfsUtilCore.isAncestor((VirtualFile)skeletonsDir, (VirtualFile)file, (boolean)false)) {
            return PySkeletonRefresher.readSkeletonHeader(VfsUtilCore.virtualToIoFile((VirtualFile)file));
        }
        return null;
    }

    @NotNull
    private static String mapToRemote(@NotNull String localRoot, @NotNull Sdk sdk) {
        RemoteSdkAdditionalData remoteSdkData;
        if (localRoot == null) {
            PythonSdkType.$$$reportNull$$$0(45);
        }
        if (sdk == null) {
            PythonSdkType.$$$reportNull$$$0(46);
        }
        if ((remoteSdkData = PyUtil.as(sdk.getSdkAdditionalData(), RemoteSdkAdditionalData.class)) != null) {
            String string = remoteSdkData.getPathMappings().convertToRemote(localRoot);
            if (string == null) {
                PythonSdkType.$$$reportNull$$$0(47);
            }
            return string;
        }
        String string = localRoot;
        if (string == null) {
            PythonSdkType.$$$reportNull$$$0(48);
        }
        return string;
    }

    private static boolean isUnderLibDirButNotSitePackages(@Nullable VirtualFile file, @NotNull String path, @NotNull VirtualFile libDir, @NotNull Sdk sdk, boolean checkOnRemoteFS) {
        String originLibDirPath;
        VirtualFile originLibDir;
        if (path == null) {
            PythonSdkType.$$$reportNull$$$0(49);
        }
        if (libDir == null) {
            PythonSdkType.$$$reportNull$$$0(50);
        }
        if (sdk == null) {
            PythonSdkType.$$$reportNull$$$0(51);
        }
        if (checkOnRemoteFS) {
            originLibDir = libDir;
            originLibDirPath = PythonSdkType.mapToRemote(originLibDir.getPath(), sdk);
        } else {
            originLibDir = (VirtualFile)ObjectUtils.notNull((Object)libDir.getCanonicalFile(), (Object)libDir);
            originLibDirPath = originLibDir.getPath();
        }
        if (checkOnRemoteFS || file == null) {
            String normalizedLidDirPath = FileUtil.toSystemIndependentName((String)originLibDirPath);
            String sitePackagesPath = normalizedLidDirPath + "/" + "site-packages";
            String normalizedPath = FileUtil.toSystemIndependentName((String)path);
            return FileUtil.startsWith((String)normalizedPath, (String)normalizedLidDirPath) && !FileUtil.startsWith((String)normalizedPath, (String)sitePackagesPath);
        }
        if (VfsUtilCore.isAncestor((VirtualFile)originLibDir, (VirtualFile)file, (boolean)false)) {
            VirtualFile sitePackagesDir = originLibDir.findChild("site-packages");
            return sitePackagesDir == null || !VfsUtilCore.isAncestor((VirtualFile)sitePackagesDir, (VirtualFile)file, (boolean)false);
        }
        return false;
    }

    @Nullable
    public static VirtualFile getSitePackagesDirectory(@NotNull Sdk pythonSdk2) {
        if (pythonSdk2 == null) {
            PythonSdkType.$$$reportNull$$$0(52);
        }
        VirtualFile libDir = PythonSdkType.isVirtualEnv(pythonSdk2) ? PyProjectScopeBuilder.findVirtualEnvLibDir(pythonSdk2) : PyProjectScopeBuilder.findLibDir(pythonSdk2);
        return libDir != null ? libDir.findChild("site-packages") : null;
    }

    @Nullable
    public static Sdk findPython2Sdk(@Nullable Module module2) {
        Sdk moduleSDK = PythonSdkType.findPythonSdk(module2);
        if (moduleSDK != null && PythonSdkType.getLanguageLevelForSdk(moduleSDK).isPython2()) {
            return moduleSDK;
        }
        return PythonSdkType.findPython2Sdk(PythonSdkType.getAllSdks());
    }

    @Nullable
    public static Sdk findPython2Sdk(@NotNull List<? extends Sdk> sdks) {
        if (sdks == null) {
            PythonSdkType.$$$reportNull$$$0(53);
        }
        for (Sdk sdk : ContainerUtil.sorted(sdks, (Comparator)PreferredSdkComparator.INSTANCE)) {
            if (!PythonSdkType.getLanguageLevelForSdk(sdk).isPython2()) continue;
            return sdk;
        }
        return null;
    }

    @Nullable
    public static Sdk findLocalCPython(@Nullable Module module2) {
        Sdk moduleSDK = PythonSdkType.findPythonSdk(module2);
        if (moduleSDK != null && !PythonSdkType.isRemote(moduleSDK) && PythonSdkFlavor.getFlavor(moduleSDK) instanceof CPythonSdkFlavor) {
            return moduleSDK;
        }
        for (Sdk sdk : ContainerUtil.sorted(PythonSdkType.getAllSdks(), (Comparator)PreferredSdkComparator.INSTANCE)) {
            if (PythonSdkType.isRemote(sdk)) continue;
            return sdk;
        }
        return null;
    }

    public static List<Sdk> getAllLocalCPythons() {
        return PythonSdkType.getAllSdks().stream().filter(REMOTE_SDK_PREDICATE.negate()).collect(Collectors.toList());
    }

    @Nullable
    public static String getPythonExecutable(@NotNull String rootPath) {
        File rootFile;
        if (rootPath == null) {
            PythonSdkType.$$$reportNull$$$0(54);
        }
        if ((rootFile = new File(rootPath)).isFile()) {
            return rootFile.getAbsolutePath();
        }
        for (String dir : DIRS_WITH_BINARY) {
            File subDir = StringUtil.isEmpty((String)dir) ? rootFile : new File(rootFile, dir);
            if (!subDir.isDirectory()) continue;
            for (String binaryName : PythonSdkType.getBinaryNames()) {
                File executable = new File(subDir, binaryName);
                if (!executable.isFile()) continue;
                return executable.getAbsolutePath();
            }
        }
        return null;
    }

    @Nullable
    public static String getExecutablePath(@NotNull String homeDirectory, @NotNull String name) {
        String resolvedPath;
        File binPath;
        File binDir;
        if (homeDirectory == null) {
            PythonSdkType.$$$reportNull$$$0(55);
        }
        if (name == null) {
            PythonSdkType.$$$reportNull$$$0(56);
        }
        if ((binDir = (binPath = new File(homeDirectory)).getParentFile()) == null) {
            return null;
        }
        File runner = new File(binDir, name);
        if (runner.exists()) {
            return LocalFileSystem.getInstance().extractPresentableUrl(runner.getPath());
        }
        runner = new File(new File(binDir, "Scripts"), name);
        if (runner.exists()) {
            return LocalFileSystem.getInstance().extractPresentableUrl(runner.getPath());
        }
        runner = new File(new File(binDir.getParentFile(), "Scripts"), name);
        if (runner.exists()) {
            return LocalFileSystem.getInstance().extractPresentableUrl(runner.getPath());
        }
        runner = new File(new File(binDir.getParentFile(), "local"), name);
        if (runner.exists()) {
            return LocalFileSystem.getInstance().extractPresentableUrl(runner.getPath());
        }
        runner = new File(new File(new File(binDir.getParentFile(), "local"), "bin"), name);
        if (runner.exists()) {
            return LocalFileSystem.getInstance().extractPresentableUrl(runner.getPath());
        }
        if (FileSystemUtil.isSymLink((String)homeDirectory) && (resolvedPath = FileSystemUtil.resolveSymLink((String)homeDirectory)) != null) {
            return PythonSdkType.getExecutablePath(resolvedPath, name);
        }
        runner = new File(new File("/usr", "bin"), name);
        if (runner.exists()) {
            return LocalFileSystem.getInstance().extractPresentableUrl(runner.getPath());
        }
        runner = new File(new File(new File("/usr", "local"), "bin"), name);
        if (runner.exists()) {
            return LocalFileSystem.getInstance().extractPresentableUrl(runner.getPath());
        }
        return null;
    }

    private static String[] getBinaryNames() {
        if (SystemInfo.isUnix) {
            return UNIX_BINARY_NAMES;
        }
        return WIN_BINARY_NAMES;
    }

    public static boolean isIncompleteRemote(Sdk sdk) {
        return PySdkUtil.isRemote(sdk) && !((PyRemoteSdkAdditionalDataBase)sdk.getSdkAdditionalData()).isValid();
    }

    public static boolean isRunAsRootViaSudo(@NotNull Sdk sdk) {
        SdkAdditionalData data;
        if (sdk == null) {
            PythonSdkType.$$$reportNull$$$0(57);
        }
        return (data = sdk.getSdkAdditionalData()) instanceof PyRemoteSdkAdditionalDataBase && ((PyRemoteSdkAdditionalDataBase)data).isRunAsRootViaSudo();
    }

    public static boolean hasInvalidRemoteCredentials(Sdk sdk) {
        if (PySdkUtil.isRemote(sdk)) {
            final Ref result = Ref.create((Object)false);
            ((PyRemoteSdkAdditionalDataBase)sdk.getSdkAdditionalData()).switchOnConnectionType(new LanguageCaseCollector<PyCredentialsContribution>(){

                protected void processLanguageContribution(PyCredentialsContribution languageContribution, Object credentials) {
                    result.set((Object)(!languageContribution.isValid(credentials) ? 1 : 0));
                }
            }.collectCases(PyCredentialsContribution.class, new CredentialsCase[]{new CredentialsCase.Vagrant(){

                public void process(VagrantBasedCredentialsHolder cred) {
                    result.set((Object)StringUtil.isEmpty((String)cred.getVagrantFolder()));
                }
            }}));
            return (Boolean)result.get();
        }
        return false;
    }

    @Deprecated
    @Nullable
    public static Sdk getSdk(@NotNull PsiElement element) {
        if (element == null) {
            PythonSdkType.$$$reportNull$$$0(58);
        }
        return PythonSdkType.findPythonSdk(element);
    }

    @NotNull
    public static String getSdkKey(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkType.$$$reportNull$$$0(59);
        }
        String string = sdk.getName();
        if (string == null) {
            PythonSdkType.$$$reportNull$$$0(60);
        }
        return string;
    }

    @Nullable
    public static Sdk findSdkByKey(@NotNull String key) {
        if (key == null) {
            PythonSdkType.$$$reportNull$$$0(61);
        }
        return ProjectJdkTable.getInstance().findJdk(key);
    }

    public boolean isLocalSdk(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkType.$$$reportNull$$$0(62);
        }
        return !PythonSdkType.isRemote(sdk);
    }

    @NotNull
    public static Map<String, String> activateVirtualEnv(@NotNull Sdk sdk) {
        Map cached;
        if (sdk == null) {
            PythonSdkType.$$$reportNull$$$0(63);
        }
        if ((cached = (Map)sdk.getUserData(ENVIRONMENT_KEY)) != null) {
            Map map2 = cached;
            if (map2 == null) {
                PythonSdkType.$$$reportNull$$$0(64);
            }
            return map2;
        }
        String sdkHome = sdk.getHomePath();
        if (sdkHome == null) {
            Map<String, String> map3 = Collections.emptyMap();
            if (map3 == null) {
                PythonSdkType.$$$reportNull$$$0(65);
            }
            return map3;
        }
        Map<String, String> environment = PythonSdkType.activateVirtualEnv(sdkHome);
        sdk.putUserData(ENVIRONMENT_KEY, environment);
        Map<String, String> map4 = environment;
        if (map4 == null) {
            PythonSdkType.$$$reportNull$$$0(66);
        }
        return map4;
    }

    @NotNull
    public static Map<String, String> activateVirtualEnv(@NotNull String sdkHome) {
        PyVirtualEnvReader reader;
        if (sdkHome == null) {
            PythonSdkType.$$$reportNull$$$0(67);
        }
        if ((reader = new PyVirtualEnvReader(sdkHome)).getActivate() != null) {
            Map<String, String> map2;
            try {
                map2 = Collections.unmodifiableMap(PyVirtualEnvReader.Companion.filterVirtualEnvVars(reader.readPythonEnv()));
            }
            catch (Exception e) {
                LOG.error("Couldn't read virtualenv variables", (Throwable)e);
            }
            if (map2 == null) {
                PythonSdkType.$$$reportNull$$$0(68);
            }
            return map2;
        }
        Map<String, String> map3 = Collections.emptyMap();
        if (map3 == null) {
            PythonSdkType.$$$reportNull$$$0(69);
        }
        return map3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 34: 
            case 36: 
            case 37: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 63: 
            case 67: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 34: 
            case 36: 
            case 37: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 63: 
            case 67: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/PythonSdkType";
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 26: 
            case 27: 
            case 36: 
            case 41: 
            case 46: 
            case 51: 
            case 57: 
            case 59: 
            case 62: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 6: 
            case 16: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkModel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentComponent";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkCreatedCallback";
                break;
            }
            case 12: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryPath";
                break;
            }
            case 15: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHome";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkModificator";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalData";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additional";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentSdk";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homePath";
                break;
            }
            case 29: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 37: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 44: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pythonSdk";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localRoot";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libDir";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdks";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homeDirectory";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpTopic";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIconForAddAction";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 34: 
            case 36: 
            case 37: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 63: 
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/PythonSdkType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuiltinsFileName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getHomeChooserDescriptor";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestSdkName";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "sdkPath";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkRootVirtualFile";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getSysPath";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getSysPathsFromScript";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevelForSdk";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "mapToRemote";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkKey";
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "activateVirtualEnv";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getBuiltinsFileName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isInvalid";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "showCustomCreateUI";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isVirtualEnv";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isConda";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isCondaVirtualEnv";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualEnvRoot";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "suggestBaseSdkName";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createAdditionalDataConfigurable";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "saveAdditionalData";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "loadAdditionalData";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "sdkPath";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "setupSdkPaths";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getSdkRootVirtualFile";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getSysPathsFromScript";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getVersionString";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "findPythonSdk";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isRootTypeApplicable";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "sdkHasValidPath";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isStdLib";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "readSkeletonHeader";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "mapToRemote";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "isUnderLibDirButNotSitePackages";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getSitePackagesDirectory";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "findPython2Sdk";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getPythonExecutable";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getExecutablePath";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "isRunAsRootViaSudo";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getSdk";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getSdkKey";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "findSdkByKey";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "isLocalSdk";
                break;
            }
            case 63: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "activateVirtualEnv";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 34: 
            case 36: 
            case 37: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 63: 
            case 67: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

