/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.indexing.IndexId;
import com.intellij.util.io.KeyDescriptor;
import java.util.Collection;
import java.util.Formatter;

public class DebugAssertions {
    private static final Logger LOG = Logger.getInstance(DebugAssertions.class);
    public static final ThreadLocal<IndexId> DEBUG_INDEX_ID = new ThreadLocal();
    public static volatile boolean DEBUG = SystemProperties.getBooleanProperty("intellij.idea.indices.debug", false);
    public static final boolean EXTRA_SANITY_CHECKS = SystemProperties.getBooleanProperty("intellij.idea.indices.debug.extra.sanity", false);

    public static void assertTrue(boolean value) {
        if (!value) {
            LOG.assertTrue(false);
        }
    }

    public static void assertTrue(boolean value, String message, Object ... args) {
        if (!value) {
            DebugAssertions.error(message, args);
        }
    }

    public static void error(String message, Object ... args) {
        LOG.error(new Formatter().format(message, args));
    }

    public static <Key> boolean equals(Collection<? extends Key> keys, Collection<? extends Key> keys2, KeyDescriptor<Key> keyDescriptor) {
        if (keys == null && keys2 == null) {
            return true;
        }
        if (keys == null || keys2 == null || keys.size() != keys2.size()) {
            return false;
        }
        LinkedHashMap<Key, Boolean> map = new LinkedHashMap<Key, Boolean>(keys.size(), 0.8f, keyDescriptor);
        for (Key key : keys) {
            map.put(key, Boolean.TRUE);
        }
        LinkedHashMap<Key, Boolean> map2 = new LinkedHashMap<Key, Boolean>(keys.size(), 0.8f, keyDescriptor);
        for (Key key : keys2) {
            map2.put(key, Boolean.TRUE);
        }
        return map.equals(map2);
    }
}

