/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.DumbAware;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.sh.ShTypes;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.ProcessingContext;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ShShebangCompletionContributor
extends CompletionContributor
implements DumbAware {
    private static final String SHEBANG_PREFIX = "#!";
    private static final List<String> ACCEPTABLE_SHELLS = Arrays.asList("/usr/bin/env bash", "/usr/bin/env sh", "/usr/bin/env zsh", "/usr/bin/env csh", "/usr/bin/env ksh", "/usr/bin/env tcsh");
    private static final CompletionProvider<CompletionParameters> SHEBANG_COMPLETION_PROVIDER = new CompletionProvider<CompletionParameters>(){

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            String defaultShebang;
            PsiElement original;
            if (parameters == null) {
                1.$$$reportNull$$$0(0);
            }
            if (context == null) {
                1.$$$reportNull$$$0(1);
            }
            if (result == null) {
                1.$$$reportNull$$$0(2);
            }
            if ((original = parameters.getOriginalPosition()) == null) {
                return;
            }
            int textLength = parameters.getOffset() - parameters.getPosition().getTextRange().getStartOffset();
            String originalText = original.getText().substring(0, textLength);
            CompletionResultSet resultSet = result.withPrefixMatcher(originalText);
            String defaultShell = EnvironmentUtil.getValue((String)"SHELL");
            if (defaultShell != null && (defaultShebang = ShShebangCompletionContributor.SHEBANG_PREFIX + defaultShell).startsWith(originalText)) {
                resultSet.addElement(ShShebangCompletionContributor.createLookupElement(defaultShebang, parameters, 10));
            }
            ACCEPTABLE_SHELLS.stream().map(shell -> ShShebangCompletionContributor.SHEBANG_PREFIX + shell).filter(shebang -> shebang.startsWith(originalText)).forEach(shebang -> resultSet.addElement(ShShebangCompletionContributor.createLookupElement(shebang, parameters, 0)));
            resultSet.stopHere();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/intellij/sh/completion/ShShebangCompletionContributor$1";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    public ShShebangCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withElementType(ShTypes.SHEBANG), SHEBANG_COMPLETION_PROVIDER);
    }

    private static LookupElement createLookupElement(@NotNull String lookupString, @NotNull CompletionParameters parameters, int priority) {
        if (lookupString == null) {
            ShShebangCompletionContributor.$$$reportNull$$$0(0);
        }
        if (parameters == null) {
            ShShebangCompletionContributor.$$$reportNull$$$0(1);
        }
        return PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)lookupString).bold(), (double)priority);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "lookupString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
        }
        objectArray[1] = "com/intellij/sh/completion/ShShebangCompletionContributor";
        objectArray[2] = "createLookupElement";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

