/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.parser;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.sh.ShTypes;
import com.intellij.sh.psi.ShFile;
import com.intellij.util.PathUtil;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShShebangParserUtil {
    private static final List<String> KNOWN_EXTENSIONS = Arrays.asList("exe", "bat", "cmd");
    private static final String PREFIX = "#!";

    private ShShebangParserUtil() {
    }

    @Nullable
    public static String getShebangExecutable(@NotNull ShFile file) {
        VirtualFile virtualFile;
        if (file == null) {
            ShShebangParserUtil.$$$reportNull$$$0(0);
        }
        if ((virtualFile = file.getVirtualFile()) != null && virtualFile.exists()) {
            String path;
            File ioFile;
            ASTNode shebang = file.getNode().findChildByType(ShTypes.SHEBANG);
            String prefix = PREFIX;
            if (shebang != null && shebang.getText().startsWith(prefix) && (ioFile = new File(path = shebang.getText().substring(prefix.length()).trim())).isAbsolute() && ioFile.canExecute()) {
                return ioFile.getAbsolutePath();
            }
        }
        return null;
    }

    @NotNull
    public static String getInterpreter(@NotNull ShFile file, @NotNull List<String> knownShells, @NotNull String defaultShell) {
        String shebang;
        if (file == null) {
            ShShebangParserUtil.$$$reportNull$$$0(1);
        }
        if (knownShells == null) {
            ShShebangParserUtil.$$$reportNull$$$0(2);
        }
        if (defaultShell == null) {
            ShShebangParserUtil.$$$reportNull$$$0(3);
        }
        String detectedInterpreter = (shebang = file.findShebang()) != null ? ShShebangParserUtil.detectInterpreter(shebang) : null;
        String string = detectedInterpreter != null && knownShells.contains(detectedInterpreter) ? detectedInterpreter : defaultShell;
        if (string == null) {
            ShShebangParserUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    private static String detectInterpreter(@Nullable String shebang) {
        if (shebang == null || !shebang.startsWith(PREFIX)) {
            return null;
        }
        String interpreterPath = ShShebangParserUtil.getInterpreterPath(shebang.substring(PREFIX.length()).trim());
        String lowerCasePath = SystemInfo.isFileSystemCaseSensitive ? interpreterPath.toLowerCase(Locale.ENGLISH) : interpreterPath;
        return ShShebangParserUtil.trimKnownExt(PathUtil.getFileName((String)lowerCasePath));
    }

    @NotNull
    private static String getInterpreterPath(@NotNull String shebang) {
        int index;
        String possiblePath;
        if (shebang == null) {
            ShShebangParserUtil.$$$reportNull$$$0(5);
        }
        String string = possiblePath = (index = shebang.indexOf(" ")) < 0 ? shebang : shebang.substring(0, index);
        if (!possiblePath.equals("/usr/bin/env")) {
            String string2 = possiblePath;
            if (string2 == null) {
                ShShebangParserUtil.$$$reportNull$$$0(6);
            }
            return string2;
        }
        String interpreterPath = shebang.substring(index + 1);
        String string3 = (index = interpreterPath.indexOf(" ")) < 0 ? interpreterPath : interpreterPath.substring(0, index);
        if (string3 == null) {
            ShShebangParserUtil.$$$reportNull$$$0(7);
        }
        return string3;
    }

    @NotNull
    private static String trimKnownExt(@NotNull String name) {
        String ext;
        if (name == null) {
            ShShebangParserUtil.$$$reportNull$$$0(8);
        }
        String string = (ext = PathUtil.getFileExtension((String)name)) != null && KNOWN_EXTENSIONS.contains(ext) ? name.substring(0, name.length() - ext.length() - 1) : name;
        if (string == null) {
            ShShebangParserUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    static String getInterpreter(@Nullable String shebang) {
        return ShShebangParserUtil.detectInterpreter(shebang);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "knownShells";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultShell";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sh/parser/ShShebangParserUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shebang";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sh/parser/ShShebangParserUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreter";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreterPath";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "trimKnownExt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getShebangExecutable";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getInterpreter";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInterpreterPath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "trimKnownExt";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

