/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.shellcheck;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sh.parser.ShShebangParserUtil;
import com.intellij.sh.psi.ShFile;
import com.intellij.sh.settings.ShSettings;
import com.intellij.sh.shellcheck.QuickFixIntention;
import com.intellij.sh.shellcheck.ShShellcheckInspection;
import com.intellij.sh.shellcheck.ShShellcheckUtil;
import com.intellij.sh.shellcheck.intention.DisableInspectionIntention;
import com.intellij.sh.shellcheck.intention.SuppressInspectionIntention;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShShellcheckExternalAnnotator
extends ExternalAnnotator<PsiFile, ShellcheckResponse> {
    private static final List<String> KNOWN_SHELLS = Arrays.asList("bash", "dash", "ksh", "sh");
    private static final String DEFAULT_SHELL = "bash";
    private static final Logger LOG = Logger.getInstance(ShShellcheckExternalAnnotator.class);

    public String getPairedBatchInspectionShortName() {
        return "ShellCheck";
    }

    @Nullable
    public PsiFile collectInformation(@NotNull PsiFile file) {
        if (file == null) {
            ShShellcheckExternalAnnotator.$$$reportNull$$$0(0);
        }
        return file instanceof ShFile ? file : null;
    }

    @Nullable
    public PsiFile collectInformation(@NotNull PsiFile file, @NotNull Editor editor, boolean hasErrors) {
        if (file == null) {
            ShShellcheckExternalAnnotator.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            ShShellcheckExternalAnnotator.$$$reportNull$$$0(2);
        }
        return this.collectInformation(file);
    }

    @Nullable
    public ShellcheckResponse doAnnotate(@NotNull PsiFile file) {
        String shellcheckExecutable;
        if (file == null) {
            ShShellcheckExternalAnnotator.$$$reportNull$$$0(3);
        }
        if (!ShShellcheckUtil.isExecutionValidPath(shellcheckExecutable = ShSettings.getShellcheckPath())) {
            return null;
        }
        String fileContent = (String)ReadAction.compute(() -> file.getText());
        try {
            GeneralCommandLine commandLine = new GeneralCommandLine().withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE).withExePath(shellcheckExecutable).withParameters(ShShellcheckExternalAnnotator.getShellcheckExecutionParams(file));
            long timestamp = file.getModificationStamp();
            Process process = commandLine.createProcess();
            ShShellcheckExternalAnnotator.writeFileContentToStdin(process, fileContent, commandLine.getCharset());
            if (process.waitFor(10L, TimeUnit.SECONDS)) {
                String output = StreamUtil.readText((InputStream)process.getInputStream(), (Charset)commandLine.getCharset());
                Type type = TypeToken.getParameterized(List.class, (Type[])new Type[]{Result.class}).getType();
                Collection results = (Collection)new Gson().fromJson(output, type);
                return results != null ? new ShellcheckResponse(results, timestamp) : null;
            }
            return null;
        }
        catch (ExecutionException | IOException | InterruptedException e) {
            LOG.error(e);
            return null;
        }
    }

    public void apply(@NotNull PsiFile file, ShellcheckResponse shellcheckResponse, @NotNull AnnotationHolder holder) {
        if (file == null) {
            ShShellcheckExternalAnnotator.$$$reportNull$$$0(4);
        }
        if (holder == null) {
            ShShellcheckExternalAnnotator.$$$reportNull$$$0(5);
        }
        super.apply(file, (Object)shellcheckResponse, holder);
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        if (document == null) {
            return;
        }
        for (Result result : shellcheckResponse.results) {
            CharSequence sequence = document.getCharsSequence();
            int startOffset = ShShellcheckUtil.calcOffset(sequence, document.getLineStartOffset(result.line - 1), result.column);
            int endOffset = ShShellcheckUtil.calcOffset(sequence, document.getLineStartOffset(result.endLine - 1), result.endColumn);
            TextRange range = TextRange.create((int)startOffset, (int)(endOffset == startOffset ? endOffset + 1 : endOffset));
            long code = result.code;
            String message = result.message;
            String scCode = "SC" + code;
            String html = "<html><p>" + StringUtil.escapeXmlEntities((String)message) + "</p><p>See <a href='https://github.com/koalaman/shellcheck/wiki/SC" + code + "'>" + scCode + "</a>.</p></html>";
            Annotation annotation = holder.createAnnotation(ShShellcheckExternalAnnotator.severity(result.level), range, message, html);
            String formattedMessage = ShShellcheckExternalAnnotator.format(message);
            Fix fix = result.fix;
            if (fix != null && !ArrayUtil.isEmpty((Object[])fix.replacements)) {
                annotation.registerFix((IntentionAction)new QuickFixIntention(formattedMessage, fix, shellcheckResponse.timestamp));
            }
            String quotedMessage = ShShellcheckExternalAnnotator.quote(formattedMessage);
            annotation.registerFix((IntentionAction)new SuppressInspectionIntention(quotedMessage, scCode, startOffset));
            annotation.registerFix((IntentionAction)new DisableInspectionIntention(quotedMessage, scCode));
        }
    }

    @NotNull
    private static HighlightSeverity severity(@Nullable String level) {
        if ("error".equals(level)) {
            HighlightSeverity highlightSeverity = HighlightSeverity.ERROR;
            if (highlightSeverity == null) {
                ShShellcheckExternalAnnotator.$$$reportNull$$$0(6);
            }
            return highlightSeverity;
        }
        if ("warning".equals(level)) {
            HighlightSeverity highlightSeverity = HighlightSeverity.WARNING;
            if (highlightSeverity == null) {
                ShShellcheckExternalAnnotator.$$$reportNull$$$0(7);
            }
            return highlightSeverity;
        }
        HighlightSeverity highlightSeverity = HighlightSeverity.WEAK_WARNING;
        if (highlightSeverity == null) {
            ShShellcheckExternalAnnotator.$$$reportNull$$$0(8);
        }
        return highlightSeverity;
    }

    @NotNull
    private static List<String> getShellcheckExecutionParams(@NotNull PsiFile file) {
        if (file == null) {
            ShShellcheckExternalAnnotator.$$$reportNull$$$0(9);
        }
        String interpreter = ShShellcheckExternalAnnotator.getInterpreter(file);
        List params = ContainerUtil.newSmartList();
        ShShellcheckInspection inspection = ShShellcheckInspection.findShShellcheckInspection((PsiElement)file);
        Collections.addAll(params, "--color=never", "--format=json", "--severity=style", "--shell=" + interpreter, "--wiki-link-count=10", "--exclude=SC1091", "-");
        inspection.getDisabledInspections().forEach(setting -> params.add("--exclude=" + setting));
        List list = params;
        if (list == null) {
            ShShellcheckExternalAnnotator.$$$reportNull$$$0(10);
        }
        return list;
    }

    private static void writeFileContentToStdin(@NotNull Process process, @NotNull String content, @NotNull Charset charset) {
        if (process == null) {
            ShShellcheckExternalAnnotator.$$$reportNull$$$0(11);
        }
        if (content == null) {
            ShShellcheckExternalAnnotator.$$$reportNull$$$0(12);
        }
        if (charset == null) {
            ShShellcheckExternalAnnotator.$$$reportNull$$$0(13);
        }
        try (OutputStream stdin = (OutputStream)ObjectUtils.assertNotNull((Object)process.getOutputStream());){
            stdin.write(content.getBytes(charset));
            stdin.flush();
        }
        catch (IOException e) {
            LOG.debug("Failed to write file content to stdin\n\n" + content, (Throwable)e);
        }
    }

    @NotNull
    private static String format(@NotNull String originalMessage) {
        if (originalMessage == null) {
            ShShellcheckExternalAnnotator.$$$reportNull$$$0(14);
        }
        String string = originalMessage.endsWith(".") ? originalMessage.substring(0, originalMessage.length() - 1) : originalMessage;
        if (string == null) {
            ShShellcheckExternalAnnotator.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    private static String quote(@NotNull String originalMessage) {
        if (originalMessage == null) {
            ShShellcheckExternalAnnotator.$$$reportNull$$$0(16);
        }
        String string = "'" + StringUtil.first((String)originalMessage, (int)60, (boolean)true) + "'";
        if (string == null) {
            ShShellcheckExternalAnnotator.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    private static String getInterpreter(@NotNull PsiFile file) {
        if (file == null) {
            ShShellcheckExternalAnnotator.$$$reportNull$$$0(18);
        }
        if (!(file instanceof ShFile)) {
            if (DEFAULT_SHELL == null) {
                ShShellcheckExternalAnnotator.$$$reportNull$$$0(19);
            }
            return DEFAULT_SHELL;
        }
        String string = ShShebangParserUtil.getInterpreter((ShFile)file, KNOWN_SHELLS, DEFAULT_SHELL);
        if (string == null) {
            ShShellcheckExternalAnnotator.$$$reportNull$$$0(20);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 15: 
            case 17: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 15: 
            case 17: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 15: 
            case 17: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sh/shellcheck/ShShellcheckExternalAnnotator";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sh/shellcheck/ShShellcheckExternalAnnotator";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "severity";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getShellcheckExecutionParams";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "format";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "quote";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectInformation";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doAnnotate";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 15: 
            case 17: 
            case 19: 
            case 20: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getShellcheckExecutionParams";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "writeFileContentToStdin";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "format";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "quote";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getInterpreter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 15: 
            case 17: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    class Replacement {
        int line;
        int column;
        int endLine;
        int endColumn;
        String replacement;

        Replacement() {
        }
    }

    class Fix {
        Replacement[] replacements;

        Fix() {
        }
    }

    class Result {
        int line;
        int endLine;
        int column;
        int endColumn;
        String level;
        String message;
        long code;
        @Nullable
        Fix fix;

        Result() {
        }
    }

    class ShellcheckResponse {
        final Collection<Result> results;
        final long timestamp;

        ShellcheckResponse(Collection<Result> results, long timestamp) {
            if (results == null) {
                ShellcheckResponse.$$$reportNull$$$0(0);
            }
            this.results = results;
            this.timestamp = timestamp;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "com/intellij/sh/shellcheck/ShShellcheckExternalAnnotator$ShellcheckResponse", "<init>"));
        }
    }
}

