/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.impl;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionData;
import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionPhase;
import com.intellij.codeInsight.completion.CompletionPhaseListener;
import com.intellij.codeInsight.completion.CompletionProcess;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.CompletionThreadingBase;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.StatisticsWeigher;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.completion.impl.CompletionSorterImpl;
import com.intellij.codeInsight.completion.impl.LiftShorterItemsClassifier;
import com.intellij.codeInsight.completion.impl.LiveTemplateWeigher;
import com.intellij.codeInsight.completion.impl.PreferStartMatching;
import com.intellij.codeInsight.completion.impl.RealPrefixMatchingWeigher;
import com.intellij.codeInsight.lookup.Classifier;
import com.intellij.codeInsight.lookup.ClassifierFactory;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.codeInsight.lookup.WeighingContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.Weigher;
import com.intellij.psi.WeighingService;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompletionServiceImpl
extends CompletionService {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.impl.CompletionServiceImpl");
    private static volatile CompletionPhase ourPhase = CompletionPhase.NoCompletion;
    private static Throwable ourPhaseTrace;
    @Nullable
    private CompletionProcess myApiCompletionProcess;

    public CompletionServiceImpl() {
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectClosing(@NotNull Project project) {
                CompletionProgressIndicator indicator;
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((indicator = CompletionServiceImpl.getCurrentCompletionProgressIndicator()) != null && indicator.getProject() == project) {
                    indicator.closeAndFinish(true);
                    CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
                } else if (indicator == null) {
                    CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/completion/impl/CompletionServiceImpl$1", "projectClosing"));
            }
        });
    }

    public void performCompletion(CompletionParameters parameters, Consumer<? super CompletionResult> consumer) {
        this.myApiCompletionProcess = parameters.getProcess();
        try {
            super.performCompletion(parameters, consumer);
        }
        finally {
            this.myApiCompletionProcess = null;
        }
    }

    public static CompletionServiceImpl getCompletionService() {
        return (CompletionServiceImpl)CompletionService.getCompletionService();
    }

    public void setAdvertisementText(@Nullable String text2) {
        if (text2 == null) {
            return;
        }
        CompletionProgressIndicator completion = CompletionServiceImpl.getCurrentCompletionProgressIndicator();
        if (completion != null) {
            completion.addAdvertisement(text2, null);
        }
    }

    protected String suggestPrefix(CompletionParameters parameters) {
        PsiElement position = parameters.getPosition();
        int offset = parameters.getOffset();
        TextRange range2 = position.getTextRange();
        assert (range2.containsOffset(offset)) : position + "; " + offset + " not in " + range2;
        return CompletionData.findPrefixStatic(position, offset);
    }

    @NotNull
    protected PrefixMatcher createMatcher(String prefix, boolean typoTolerant) {
        CamelHumpMatcher camelHumpMatcher = CompletionServiceImpl.createMatcher(prefix, true, typoTolerant);
        if (camelHumpMatcher == null) {
            CompletionServiceImpl.$$$reportNull$$$0(0);
        }
        return camelHumpMatcher;
    }

    @NotNull
    private static CamelHumpMatcher createMatcher(String prefix, boolean caseSensitive, boolean typoTolerant) {
        CamelHumpMatcher camelHumpMatcher = new CamelHumpMatcher(prefix, caseSensitive, typoTolerant);
        if (camelHumpMatcher == null) {
            CompletionServiceImpl.$$$reportNull$$$0(1);
        }
        return camelHumpMatcher;
    }

    protected CompletionResultSet createResultSet(CompletionParameters parameters, Consumer<? super CompletionResult> consumer, @NotNull CompletionContributor contributor, PrefixMatcher matcher) {
        if (contributor == null) {
            CompletionServiceImpl.$$$reportNull$$$0(2);
        }
        return new CompletionResultSetImpl(consumer, matcher, contributor, parameters, this.defaultSorter(parameters, matcher), null);
    }

    public CompletionProcess getCurrentCompletion() {
        CompletionProgressIndicator indicator = CompletionServiceImpl.getCurrentCompletionProgressIndicator();
        return indicator != null ? indicator : this.myApiCompletionProcess;
    }

    public static CompletionProgressIndicator getCurrentCompletionProgressIndicator() {
        if (CompletionServiceImpl.isPhase(CompletionPhase.BgCalculation.class, CompletionPhase.ItemsCalculated.class, CompletionPhase.CommittingDocuments.class, CompletionPhase.Synchronous.class)) {
            return CompletionServiceImpl.ourPhase.indicator;
        }
        return null;
    }

    @SafeVarargs
    public static void assertPhase(Class<? extends CompletionPhase> ... possibilities) {
        if (possibilities == null) {
            CompletionServiceImpl.$$$reportNull$$$0(3);
        }
        if (!CompletionServiceImpl.isPhase(possibilities)) {
            LOG.error(ourPhase + "; set at " + ExceptionUtil.getThrowableText((Throwable)ourPhaseTrace));
        }
    }

    @SafeVarargs
    public static boolean isPhase(Class<? extends CompletionPhase> ... possibilities) {
        if (possibilities == null) {
            CompletionServiceImpl.$$$reportNull$$$0(4);
        }
        CompletionPhase phase = CompletionServiceImpl.getCompletionPhase();
        for (Class<? extends CompletionPhase> possibility : possibilities) {
            if (!possibility.isInstance(phase)) continue;
            return true;
        }
        return false;
    }

    public static void setCompletionPhase(@NotNull CompletionPhase phase) {
        if (phase == null) {
            CompletionServiceImpl.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        CompletionPhase oldPhase = CompletionServiceImpl.getCompletionPhase();
        CompletionProgressIndicator oldIndicator = oldPhase.indicator;
        if (oldIndicator != null && !(phase instanceof CompletionPhase.BgCalculation)) {
            LOG.assertTrue(!oldIndicator.isRunning() || oldIndicator.isCanceled(), (Object)("don't change phase during running completion: oldPhase=" + oldPhase));
        }
        boolean wasCompletionRunning = CompletionServiceImpl.isRunningPhase(oldPhase);
        boolean isCompletionRunning = CompletionServiceImpl.isRunningPhase(phase);
        if (isCompletionRunning != wasCompletionRunning) {
            ((CompletionPhaseListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(CompletionPhaseListener.TOPIC)).completionPhaseChanged(isCompletionRunning);
        }
        Disposer.dispose((Disposable)oldPhase);
        ourPhase = phase;
        ourPhaseTrace = new Throwable();
    }

    private static boolean isRunningPhase(@NotNull CompletionPhase phase) {
        if (phase == null) {
            CompletionServiceImpl.$$$reportNull$$$0(6);
        }
        return phase != CompletionPhase.NoCompletion && !(phase instanceof CompletionPhase.ZombiePhase) && !(phase instanceof CompletionPhase.ItemsCalculated);
    }

    public static CompletionPhase getCompletionPhase() {
        return ourPhase;
    }

    public CompletionSorterImpl defaultSorter(CompletionParameters parameters, PrefixMatcher matcher) {
        final CompletionLocation location = new CompletionLocation(parameters);
        CompletionSorterImpl sorter = this.emptySorter();
        sorter = sorter.withClassifier(CompletionSorterImpl.weighingFactory(new LiveTemplateWeigher()));
        sorter = sorter.withClassifier(CompletionSorterImpl.weighingFactory(new PreferStartMatching()));
        for (final Weigher weigher : WeighingService.getWeighers((Key)CompletionService.RELEVANCE_KEY)) {
            String id = weigher.toString();
            if ("prefix".equals(id)) {
                sorter = sorter.withClassifier(CompletionSorterImpl.weighingFactory(new RealPrefixMatchingWeigher()));
                continue;
            }
            if ("stats".equals(id)) {
                sorter = sorter.withClassifier(new ClassifierFactory<LookupElement>("stats"){

                    @Override
                    public Classifier<LookupElement> createClassifier(Classifier<LookupElement> next) {
                        return new StatisticsWeigher.LookupStatisticsWeigher(location, next);
                    }
                });
                continue;
            }
            sorter = sorter.weigh(new LookupElementWeigher(id, true, false){

                public Comparable weigh(@NotNull LookupElement element) {
                    if (element == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return weigher.weigh((Object)element, (Object)location);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/completion/impl/CompletionServiceImpl$3", "weigh"));
                }
            });
        }
        return sorter.withClassifier("priority", true, new ClassifierFactory<LookupElement>("liftShorter"){

            @Override
            public Classifier<LookupElement> createClassifier(Classifier<LookupElement> next) {
                return new LiftShorterItemsClassifier("liftShorter", next, new LiftShorterItemsClassifier.LiftingCondition(), false);
            }
        });
    }

    public CompletionSorterImpl emptySorter() {
        return new CompletionSorterImpl(new ArrayList());
    }

    public static boolean isStartMatch(LookupElement element, WeighingContext context) {
        return CompletionServiceImpl.getItemMatcher(element, context).isStartMatch(element);
    }

    static PrefixMatcher getItemMatcher(LookupElement element, WeighingContext context) {
        PrefixMatcher itemMatcher = context.itemMatcher(element);
        String pattern = context.itemPattern(element);
        if (!pattern.equals(itemMatcher.getPrefix())) {
            return itemMatcher.cloneWithPrefix(pattern);
        }
        return itemMatcher;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/impl/CompletionServiceImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributor";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibilities";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createMatcher";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/impl/CompletionServiceImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createResultSet";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "assertPhase";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isPhase";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setCompletionPhase";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isRunningPhase";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CompletionResultSetImpl
    extends CompletionResultSet {
        private final CompletionParameters myParameters;
        private final CompletionSorterImpl mySorter;
        @Nullable
        private final CompletionResultSetImpl myOriginal;

        CompletionResultSetImpl(Consumer<? super CompletionResult> consumer, PrefixMatcher prefixMatcher, CompletionContributor contributor, CompletionParameters parameters, @NotNull CompletionSorterImpl sorter, @Nullable CompletionResultSetImpl original) {
            if (sorter == null) {
                CompletionResultSetImpl.$$$reportNull$$$0(0);
            }
            super(prefixMatcher, consumer, contributor);
            this.myParameters = parameters;
            this.mySorter = sorter;
            this.myOriginal = original;
        }

        public void addAllElements(@NotNull Iterable<? extends LookupElement> elements2) {
            if (elements2 == null) {
                CompletionResultSetImpl.$$$reportNull$$$0(1);
            }
            CompletionThreadingBase.withBatchUpdate(() -> super.addAllElements(elements2), this.myParameters.getProcess());
        }

        public void addElement(@NotNull LookupElement element) {
            if (element == null) {
                CompletionResultSetImpl.$$$reportNull$$$0(2);
            }
            ProgressManager.checkCanceled();
            if (!element.isValid()) {
                LOG.error("Invalid lookup element: " + element + " of " + element.getClass() + " in " + this.myParameters.getOriginalFile() + " of " + this.myParameters.getOriginalFile().getClass());
                return;
            }
            CompletionResult matched = CompletionResult.wrap((LookupElement)element, (PrefixMatcher)this.getPrefixMatcher(), (CompletionSorter)this.mySorter);
            if (matched != null) {
                this.passResult(matched);
            }
        }

        @NotNull
        public CompletionResultSet withPrefixMatcher(@NotNull PrefixMatcher matcher) {
            if (matcher == null) {
                CompletionResultSetImpl.$$$reportNull$$$0(3);
            }
            if (matcher.equals(this.getPrefixMatcher())) {
                CompletionResultSetImpl completionResultSetImpl = this;
                if (completionResultSetImpl == null) {
                    CompletionResultSetImpl.$$$reportNull$$$0(4);
                }
                return completionResultSetImpl;
            }
            CompletionResultSetImpl completionResultSetImpl = new CompletionResultSetImpl((Consumer<? super CompletionResult>)this.getConsumer(), matcher, this.myContributor, this.myParameters, this.mySorter, this);
            if (completionResultSetImpl == null) {
                CompletionResultSetImpl.$$$reportNull$$$0(5);
            }
            return completionResultSetImpl;
        }

        public void stopHere() {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Completion stopped\n" + DebugUtil.currentStackTrace());
            }
            super.stopHere();
            if (this.myOriginal != null) {
                this.myOriginal.stopHere();
            }
        }

        @NotNull
        public CompletionResultSet withPrefixMatcher(@NotNull String prefix) {
            if (prefix == null) {
                CompletionResultSetImpl.$$$reportNull$$$0(6);
            }
            CompletionResultSet completionResultSet = this.withPrefixMatcher(this.getPrefixMatcher().cloneWithPrefix(prefix));
            if (completionResultSet == null) {
                CompletionResultSetImpl.$$$reportNull$$$0(7);
            }
            return completionResultSet;
        }

        @NotNull
        public CompletionResultSet withRelevanceSorter(@NotNull CompletionSorter sorter) {
            if (sorter == null) {
                CompletionResultSetImpl.$$$reportNull$$$0(8);
            }
            CompletionResultSetImpl completionResultSetImpl = new CompletionResultSetImpl((Consumer<? super CompletionResult>)this.getConsumer(), this.getPrefixMatcher(), this.myContributor, this.myParameters, (CompletionSorterImpl)sorter, this);
            if (completionResultSetImpl == null) {
                CompletionResultSetImpl.$$$reportNull$$$0(9);
            }
            return completionResultSetImpl;
        }

        public void addLookupAdvertisement(@NotNull String text2) {
            if (text2 == null) {
                CompletionResultSetImpl.$$$reportNull$$$0(10);
            }
            CompletionServiceImpl.getCompletionService().setAdvertisementText(text2);
        }

        @NotNull
        public CompletionResultSet caseInsensitive() {
            PrefixMatcher matcher = this.getPrefixMatcher();
            boolean typoTolerant = matcher instanceof CamelHumpMatcher && ((CamelHumpMatcher)matcher).isTypoTolerant();
            CompletionResultSet completionResultSet = this.withPrefixMatcher(CompletionServiceImpl.createMatcher(matcher.getPrefix(), false, typoTolerant));
            if (completionResultSet == null) {
                CompletionResultSetImpl.$$$reportNull$$$0(11);
            }
            return completionResultSet;
        }

        public void restartCompletionOnPrefixChange(ElementPattern<String> prefixCondition) {
            CompletionProcess process2 = this.myParameters.getProcess();
            if (process2 instanceof CompletionProgressIndicator) {
                ((CompletionProgressIndicator)process2).addWatchedPrefix(this.myParameters.getOffset() - this.getPrefixMatcher().getPrefix().length(), prefixCondition);
            }
        }

        public void restartCompletionWhenNothingMatches() {
            CompletionProcess process2 = this.myParameters.getProcess();
            if (process2 instanceof CompletionProgressIndicator) {
                ((CompletionProgressIndicator)process2).getLookup().setStartCompletionWhenNothingMatches(true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sorter";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elements";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matcher";
                    break;
                }
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/completion/impl/CompletionServiceImpl$CompletionResultSetImpl";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/completion/impl/CompletionServiceImpl$CompletionResultSetImpl";
                    break;
                }
                case 4: 
                case 5: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withPrefixMatcher";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withRelevanceSorter";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "caseInsensitive";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "addAllElements";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "addElement";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "withPrefixMatcher";
                    break;
                }
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 11: {
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "withRelevanceSorter";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "addLookupAdvertisement";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

