/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.LineMarkersPass;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.VisibleHighlightingPassFactory;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.MarkupModelImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class LineMarkersPassFactory
implements TextEditorHighlightingPassFactory,
TextEditorHighlightingPassFactoryRegistrar {
    LineMarkersPassFactory() {
    }

    @Override
    public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar, @NotNull Project project) {
        if (registrar == null) {
            LineMarkersPassFactory.$$$reportNull$$$0(0);
        }
        if (project == null) {
            LineMarkersPassFactory.$$$reportNull$$$0(1);
        }
        registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, new int[]{4}, false, 11);
    }

    @Override
    @NotNull
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor) {
        if (file2 == null) {
            LineMarkersPassFactory.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            LineMarkersPassFactory.$$$reportNull$$$0(3);
        }
        TextRange restrictRange = FileStatusMap.getDirtyTextRange(editor, 11);
        Document document = editor.getDocument();
        Project project = file2.getProject();
        if (restrictRange == null) {
            ProgressableTextEditorHighlightingPass.EmptyPass emptyPass = new ProgressableTextEditorHighlightingPass.EmptyPass(project, document);
            if (emptyPass == null) {
                LineMarkersPassFactory.$$$reportNull$$$0(4);
            }
            return emptyPass;
        }
        ProperTextRange visibleRange = VisibleHighlightingPassFactory.calculateVisibleRange(editor);
        LineMarkersPass lineMarkersPass = new LineMarkersPass(project, file2, document, LineMarkersPassFactory.expandRangeToCoverWholeLines(document, (TextRange)visibleRange), LineMarkersPassFactory.expandRangeToCoverWholeLines(document, restrictRange));
        if (lineMarkersPass == null) {
            LineMarkersPassFactory.$$$reportNull$$$0(5);
        }
        return lineMarkersPass;
    }

    @Nullable
    private static TextRange expandRangeToCoverWholeLines(@NotNull Document document, TextRange textRange) {
        if (document == null) {
            LineMarkersPassFactory.$$$reportNull$$$0(6);
        }
        if (textRange == null) {
            return null;
        }
        return MarkupModelImpl.roundToLineBoundaries(document, textRange.getStartOffset(), textRange.getEndOffset());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/LineMarkersPassFactory";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/LineMarkersPassFactory";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createHighlightingPass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerHighlightingPassFactory";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createHighlightingPass";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "expandRangeToCoverWholeLines";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

