/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.InspectionManagerBase;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.ProblemDescriptorImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.ContentUI;
import com.intellij.ui.content.TabbedPaneContentUI;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionManagerEx
extends InspectionManagerBase {
    private final NotNullLazyValue<ContentManager> myContentManager;
    private final Set<GlobalInspectionContextImpl> myRunningContexts = new HashSet<GlobalInspectionContextImpl>();

    public InspectionManagerEx(final Project project) {
        super(project);
        this.myContentManager = ApplicationManager.getApplication().isHeadlessEnvironment() ? new NotNullLazyValue<ContentManager>(){

            @NotNull
            protected ContentManager compute() {
                ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project);
                toolWindowManager.registerToolWindow(ToolWindowId.INSPECTION, true, ToolWindowAnchor.BOTTOM, (Disposable)project);
                ContentManager contentManager = ContentFactory.SERVICE.getInstance().createContentManager((ContentUI)new TabbedPaneContentUI(), true, project);
                if (contentManager == null) {
                    1.$$$reportNull$$$0(0);
                }
                return contentManager;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionManagerEx$1", "compute"));
            }
        } : new NotNullLazyValue<ContentManager>(){

            @NotNull
            protected ContentManager compute() {
                ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project);
                ToolWindow toolWindow = toolWindowManager.registerToolWindow(ToolWindowId.INSPECTION, true, ToolWindowAnchor.BOTTOM, (Disposable)project);
                final ContentManager contentManager = toolWindow.getContentManager();
                toolWindow.setIcon(AllIcons.Toolwindows.ToolWindowInspection);
                new ContentManagerWatcher(toolWindow, contentManager);
                contentManager.addContentManagerListener((ContentManagerListener)new ContentManagerAdapter(){
                    private static final String PREFIX = "of ";

                    public void contentAdded(@NotNull ContentManagerEvent event) {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        this.handleContentSizeChanged();
                    }

                    public void contentRemoved(@NotNull ContentManagerEvent event) {
                        if (event == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        this.handleContentSizeChanged();
                    }

                    private void handleContentSizeChanged() {
                        int count = contentManager.getContentCount();
                        if (count == 1) {
                            Content content2 = contentManager.getContent(0);
                            String displayName = content2.getDisplayName();
                            if (!content2.getDisplayName().startsWith(PREFIX)) {
                                content2.setDisplayName(PREFIX + displayName);
                            }
                        } else if (count > 1) {
                            for (Content content3 : contentManager.getContents()) {
                                if (!content3.getDisplayName().startsWith(PREFIX)) continue;
                                content3.setDisplayName(content3.getDisplayName().substring(PREFIX.length()));
                            }
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        objectArray2[0] = "event";
                        objectArray2[1] = "com/intellij/codeInspection/ex/InspectionManagerEx$2$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "contentAdded";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "contentRemoved";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
                ContentManager contentManager2 = contentManager;
                if (contentManager2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                return contentManager2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionManagerEx$2", "compute"));
            }
        };
    }

    @NotNull
    public ProblemDescriptor createProblemDescriptor(@NotNull PsiElement psiElement, @NotNull String descriptionTemplate, @NotNull ProblemHighlightType highlightType, @Nullable HintAction hintAction, boolean onTheFly, LocalQuickFix ... fixes) {
        if (psiElement == null) {
            InspectionManagerEx.$$$reportNull$$$0(0);
        }
        if (descriptionTemplate == null) {
            InspectionManagerEx.$$$reportNull$$$0(1);
        }
        if (highlightType == null) {
            InspectionManagerEx.$$$reportNull$$$0(2);
        }
        ProblemDescriptorImpl problemDescriptorImpl = new ProblemDescriptorImpl(psiElement, psiElement, descriptionTemplate, fixes, highlightType, false, null, hintAction, onTheFly);
        if (problemDescriptorImpl == null) {
            InspectionManagerEx.$$$reportNull$$$0(3);
        }
        return problemDescriptorImpl;
    }

    @NotNull
    public GlobalInspectionContextImpl createNewGlobalContext(boolean reuse) {
        GlobalInspectionContextImpl globalInspectionContextImpl = this.createNewGlobalContext();
        if (globalInspectionContextImpl == null) {
            InspectionManagerEx.$$$reportNull$$$0(4);
        }
        return globalInspectionContextImpl;
    }

    @NotNull
    public GlobalInspectionContextImpl createNewGlobalContext() {
        GlobalInspectionContextImpl inspectionContext = new GlobalInspectionContextImpl(this.getProject(), this.myContentManager);
        this.myRunningContexts.add(inspectionContext);
        GlobalInspectionContextImpl globalInspectionContextImpl = inspectionContext;
        if (globalInspectionContextImpl == null) {
            InspectionManagerEx.$$$reportNull$$$0(5);
        }
        return globalInspectionContextImpl;
    }

    public void setProfile(@NotNull String name) {
        if (name == null) {
            InspectionManagerEx.$$$reportNull$$$0(6);
        }
        this.myCurrentProfileName = name;
    }

    void closeRunningContext(@NotNull GlobalInspectionContextImpl globalInspectionContext) {
        if (globalInspectionContext == null) {
            InspectionManagerEx.$$$reportNull$$$0(7);
        }
        this.myRunningContexts.remove((Object)globalInspectionContext);
    }

    @NotNull
    public Set<GlobalInspectionContextImpl> getRunningContexts() {
        Set<GlobalInspectionContextImpl> set = this.myRunningContexts;
        if (set == null) {
            InspectionManagerEx.$$$reportNull$$$0(8);
        }
        return set;
    }

    @NotNull
    public NotNullLazyValue<ContentManager> getContentManager() {
        NotNullLazyValue<ContentManager> notNullLazyValue = this.myContentManager;
        if (notNullLazyValue == null) {
            InspectionManagerEx.$$$reportNull$$$0(9);
        }
        return notNullLazyValue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptionTemplate";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightType";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ex/InspectionManagerEx";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalInspectionContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ex/InspectionManagerEx";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createProblemDescriptor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewGlobalContext";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunningContexts";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createProblemDescriptor";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setProfile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "closeRunningContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

