/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.StorageManagerFileWriteRequestor;
import com.intellij.configurationStore.StoreReloadManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroSubstitutor;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.UnknownMacroNotification;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.impl.ProjectMacrosUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.PathKt;
import com.intellij.util.messages.MessageBus;
import gnu.trove.THashSet;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\\\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007\u001a:\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00010\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011H\u0002\u001a2\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00010\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0017H\u0002\u001a2\u0010\u0018\u001a\u00020\b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00010\u000f2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011H\u0007\u001a\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0007\u001a\u0012\u0010 \u001a\u0004\u0018\u00010\u00012\u0006\u0010!\u001a\u00020\u001dH\u0007\u001a$\u0010\"\u001a\u0002H#\"\u0004\b\u0000\u0010#2\u000e\b\u0004\u0010$\u001a\b\u0012\u0004\u0012\u0002H#0%H\u0087\b\u00a2\u0006\u0002\u0010&\"\u001c\u0010\u0000\u001a\u0004\u0018\u00010\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0004\b\u0004\u0010\u0005\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"DEBUG_LOG", "", "getDEBUG_LOG", "()Ljava/lang/String;", "setDEBUG_LOG", "(Ljava/lang/String;)V", "NOTIFICATION_GROUP_ID", "checkUnknownMacros", "", "project", "Lcom/intellij/openapi/project/Project;", "notify", "", "showDialog", "unknownMacros", "", "substitutorToStore", "", "Lcom/intellij/openapi/components/TrackingPathMacroSubstitutor;", "Lcom/intellij/openapi/components/impl/stores/IComponentStore;", "collect", "componentManager", "Lcom/intellij/openapi/components/ComponentManager;", "", "doNotify", "macros", "getOrCreateVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "file", "Ljava/nio/file/Path;", "requestor", "Lcom/intellij/configurationStore/StorageManagerFileWriteRequestor;", "readProjectNameFile", "nameFile", "runAsWriteActionIfNeeded", "T", "runnable", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.platform.ide.impl"})
public final class StorageUtilKt {
    @NotNull
    public static final String NOTIFICATION_GROUP_ID = "Load Error";
    @Nullable
    private static String DEBUG_LOG;

    @Nullable
    public static final String getDEBUG_LOG() {
        return DEBUG_LOG;
    }

    public static final void setDEBUG_LOG(@Nullable String string) {
        DEBUG_LOG = string;
    }

    @ApiStatus.Internal
    public static final void doNotify(@NotNull Set<String> macros, @NotNull Project project, @NotNull Map<TrackingPathMacroSubstitutor, ? extends IComponentStore> substitutorToStore) {
        Intrinsics.checkParameterIsNotNull(macros, (String)"macros");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(substitutorToStore, (String)"substitutorToStore");
        ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)applicationNamesInfo, (String)"ApplicationNamesInfo.getInstance()");
        String productName = applicationNamesInfo.getProductName();
        String content2 = "<p><i>" + CollectionsKt.joinToString$default((Iterable)macros, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + "</i> " + (macros.size() == 1 ? "is" : "are") + " undefined. <a href=\"define\">Fix it</a></p>" + "<br>Path variables are used to substitute absolute paths in " + productName + " project files " + "and allow project file sharing in version control systems.<br>" + "Some of the files describing the current project settings contain unknown path variables " + "and " + productName + " cannot restore those paths.";
        new UnknownMacroNotification(NOTIFICATION_GROUP_ID, "Load error: undefined path variables", content2, NotificationType.ERROR, new NotificationListener(project, macros, substitutorToStore){
            final /* synthetic */ Project $project;
            final /* synthetic */ Set $macros;
            final /* synthetic */ Map $substitutorToStore;

            public final void hyperlinkUpdate(@NotNull Notification $noName_0, @NotNull HyperlinkEvent $noName_1) {
                Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                Intrinsics.checkParameterIsNotNull((Object)$noName_1, (String)"<anonymous parameter 1>");
                StorageUtilKt.access$checkUnknownMacros(this.$project, true, this.$macros, this.$substitutorToStore);
            }
            {
                this.$project = project;
                this.$macros = set;
                this.$substitutorToStore = map2;
            }
        }, (Collection<String>)macros).notify(project);
    }

    @ApiStatus.Internal
    public static final void checkUnknownMacros(@NotNull Project project, boolean notify) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        LinkedHashSet unknownMacros = new LinkedHashSet();
        LinkedHashMap substitutorToStore = new LinkedHashMap();
        StorageUtilKt.collect((ComponentManager)project, unknownMacros, substitutorToStore);
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
        Module[] moduleArray = moduleManager.getModules();
        int n = moduleArray.length;
        for (int i = 0; i < n; ++i) {
            Module module;
            Module module2 = module = moduleArray[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)module2, (String)"module");
            StorageUtilKt.collect((ComponentManager)module2, unknownMacros, substitutorToStore);
        }
        if (unknownMacros.isEmpty()) {
            return;
        }
        if (notify) {
            StorageUtilKt.doNotify(unknownMacros, project, substitutorToStore);
            return;
        }
        StorageUtilKt.checkUnknownMacros(project, false, unknownMacros, substitutorToStore);
    }

    private static final void checkUnknownMacros(Project project, boolean showDialog, Set<String> unknownMacros, Map<TrackingPathMacroSubstitutor, ? extends IComponentStore> substitutorToStore) {
        if (unknownMacros.isEmpty() || showDialog && !ProjectMacrosUtil.checkMacros(project, (Set)new THashSet((Collection)unknownMacros))) {
            return;
        }
        PathMacros pathMacros = PathMacros.getInstance();
        CollectionsKt.removeAll((Iterable)unknownMacros, (Function1)((Function1)new Function1<String, Boolean>(pathMacros){
            final /* synthetic */ PathMacros $pathMacros;

            public final boolean invoke(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                CharSequence charSequence = this.$pathMacros.getValue(it);
                boolean bl = false;
                boolean bl2 = false;
                return (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) && !this.$pathMacros.isIgnoredMacroName(it);
            }
            {
                this.$pathMacros = pathMacros;
                super(1);
            }
        }));
        if (unknownMacros.isEmpty()) {
            return;
        }
        NotificationsManager notificationManager2 = NotificationsManager.getNotificationsManager();
        Map<TrackingPathMacroSubstitutor, ? extends IComponentStore> map2 = substitutorToStore;
        boolean bl = false;
        Iterator<Map.Entry<TrackingPathMacroSubstitutor, ? extends IComponentStore>> iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Set<String> components;
            Map.Entry<TrackingPathMacroSubstitutor, ? extends IComponentStore> entry;
            Map.Entry<TrackingPathMacroSubstitutor, ? extends IComponentStore> entry2 = entry = iterator.next();
            boolean bl2 = false;
            TrackingPathMacroSubstitutor substitutor = entry2.getKey();
            entry2 = entry;
            bl2 = false;
            IComponentStore store = entry2.getValue();
            Intrinsics.checkExpressionValueIsNotNull(substitutor.getComponents((Collection<String>)unknownMacros), (String)"substitutor.getComponents(unknownMacros)");
            if (store.isReloadPossible(components)) {
                substitutor.invalidateUnknownMacros(unknownMacros);
                UnknownMacroNotification[] unknownMacroNotificationArray = (UnknownMacroNotification[])notificationManager2.getNotificationsOfType(UnknownMacroNotification.class, project);
                int n = unknownMacroNotificationArray.length;
                for (int i = 0; i < n; ++i) {
                    UnknownMacroNotification notification;
                    UnknownMacroNotification unknownMacroNotification = notification = unknownMacroNotificationArray[i];
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)unknownMacroNotification), (String)"notification");
                    Collection<String> collection = unknownMacroNotification.getMacros();
                    Intrinsics.checkExpressionValueIsNotNull(collection, (String)"notification.macros");
                    if (!unknownMacros.containsAll(collection)) continue;
                    notification.expire();
                }
                MessageBus messageBus = project.getMessageBus();
                Intrinsics.checkExpressionValueIsNotNull((Object)messageBus, (String)"project.messageBus");
                store.reloadStates(components, messageBus);
                continue;
            }
            if (Messages.showYesNoDialog((Project)project, (String)"Component could not be reloaded. Reload project?", (String)"Configuration Changed", (Icon)Messages.getQuestionIcon()) != 0) continue;
            StoreReloadManager.Companion.getInstance().reloadProject(project);
        }
    }

    private static final void collect(ComponentManager componentManager, Set<String> unknownMacros, Map<TrackingPathMacroSubstitutor, IComponentStore> substitutorToStore) {
        IComponentStore store = ServiceKt.getStateStore(componentManager);
        PathMacroSubstitutor pathMacroSubstitutor = store.getStorageManager().getMacroSubstitutor();
        if (!(pathMacroSubstitutor instanceof TrackingPathMacroSubstitutor)) {
            pathMacroSubstitutor = null;
        }
        TrackingPathMacroSubstitutor trackingPathMacroSubstitutor = (TrackingPathMacroSubstitutor)pathMacroSubstitutor;
        if (trackingPathMacroSubstitutor == null) {
            return;
        }
        TrackingPathMacroSubstitutor substitutor = trackingPathMacroSubstitutor;
        Set<String> set = substitutor.getUnknownMacros(null);
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"substitutor.getUnknownMacros(null)");
        Set<String> macros = set;
        if (macros.isEmpty()) {
            return;
        }
        unknownMacros.addAll((Collection<String>)macros);
        substitutorToStore.put(substitutor, store);
    }

    @ApiStatus.Internal
    @NotNull
    public static final VirtualFile getOrCreateVirtualFile(@NotNull Path file2, @NotNull StorageManagerFileWriteRequestor requestor) {
        Object object;
        Path parentFile;
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)requestor, (String)"requestor");
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(PathKt.getSystemIndependentPath((Path)file2));
        if (virtualFile != null) {
            return virtualFile;
        }
        Path path = parentFile = file2.getParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"parentFile");
        PathKt.createDirectories((Path)path);
        VirtualFile virtualFile2 = LocalFileSystem.getInstance().refreshAndFindFileByPath(PathKt.getSystemIndependentPath((Path)parentFile));
        if (virtualFile2 == null) {
            throw (Throwable)new IOException(ProjectBundle.message((String)"project.configuration.save.file.not.found", (Object[])new Object[]{parentFile}));
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"LocalFileSystem.getInsta\u2026.not.found\", parentFile))");
        VirtualFile parentVirtualFile = virtualFile2;
        boolean $i$f$runAsWriteActionIfNeeded = false;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isWriteAccessAllowed()) {
            boolean bl = false;
            VirtualFile virtualFile3 = parentVirtualFile.createChildData((Object)requestor, ((Object)file2.getFileName()).toString());
            object = virtualFile3;
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"parentVirtualFile.create\u2026file.fileName.toString())");
        } else {
            boolean $i$f$runWriteAction = false;
            object = ApplicationManager.getApplication().runWriteAction(new Computable<T>(parentVirtualFile, requestor, file2){
                final /* synthetic */ VirtualFile $parentVirtualFile$inlined;
                final /* synthetic */ StorageManagerFileWriteRequestor $requestor$inlined;
                final /* synthetic */ Path $file$inlined;
                {
                    this.$parentVirtualFile$inlined = virtualFile;
                    this.$requestor$inlined = storageManagerFileWriteRequestor;
                    this.$file$inlined = path;
                }

                public final T compute() {
                    boolean bl = false;
                    VirtualFile virtualFile = this.$parentVirtualFile$inlined.createChildData((Object)this.$requestor$inlined, ((Object)this.$file$inlined.getFileName()).toString());
                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"parentVirtualFile.create\u2026file.fileName.toString())");
                    return (T)virtualFile;
                }
            });
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"runAsWriteActionIfNeeded\u2026.fileName.toString())\n  }");
        return object;
    }

    @ApiStatus.Internal
    public static final <T> T runAsWriteActionIfNeeded(@NotNull Function0<? extends T> runnable2) {
        Object object;
        int $i$f$runAsWriteActionIfNeeded = 0;
        Intrinsics.checkParameterIsNotNull(runnable2, (String)"runnable");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isWriteAccessAllowed()) {
            object = runnable2.invoke();
        } else {
            boolean $i$f$runWriteAction = false;
            object = ApplicationManager.getApplication().runWriteAction(new Computable<T>(runnable2){
                final /* synthetic */ Function0 $runnable;
                {
                    this.$runnable = function0;
                }

                public final T compute() {
                    return (T)this.$runnable.invoke();
                }
            });
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    @Nullable
    public static final String readProjectNameFile(@NotNull Path nameFile) throws IOException {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)nameFile, (String)"nameFile");
        InputStream inputStream = PathKt.inputStream((Path)nameFile);
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        Reader $this$useLines$iv = new InputStreamReader(inputStream, charset);
        boolean $i$f$useLines = false;
        Closeable closeable = $this$useLines$iv;
        int n = 8192;
        boolean bl2 = false;
        closeable = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n);
        n = 0;
        Throwable throwable = null;
        try {
            String string2;
            Object v0;
            block9: {
                BufferedReader it$iv = (BufferedReader)closeable;
                boolean bl3 = false;
                Sequence line2 = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                boolean bl4 = false;
                Sequence $this$firstOrNull$iv = line2;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    String it = (String)element$iv;
                    boolean bl5 = false;
                    CharSequence charSequence = it;
                    boolean bl6 = false;
                    if (!(!(charSequence.length() == 0))) continue;
                    v0 = element$iv;
                    break block9;
                }
                v0 = null;
            }
            String string3 = v0;
            if (string3 != null) {
                String string4 = string3;
                boolean bl7 = false;
                String string5 = string4;
                if (string5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                string2 = ((Object)StringsKt.trim((CharSequence)string5)).toString();
            } else {
                string2 = null;
            }
            string = string2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return string;
    }

    public static final /* synthetic */ void access$checkUnknownMacros(Project project, boolean showDialog, Set unknownMacros, Map substitutorToStore) {
        StorageUtilKt.checkUnknownMacros(project, showDialog, unknownMacros, substitutorToStore);
    }
}

