/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.Freeze;
import com.intellij.diagnostic.ITNReporter;
import com.intellij.diagnostic.IdeErrorsDialog;
import com.intellij.diagnostic.IdePerformanceListener;
import com.intellij.diagnostic.LogMessage;
import com.intellij.diagnostic.MessagePool;
import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.diagnostic.ThreadDump;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.internal.DebugAttachDetector;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.lang.management.ThreadInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeaFreezeReporter {
    private static final int FREEZE_THRESHOLD = ApplicationManager.getApplication().isInternal() ? 5 : 25;

    public IdeaFreezeReporter() {
        Application app = ApplicationManager.getApplication();
        if (!app.isEAP() || app.isUnitTestMode() || PluginManagerCore.isRunningFromSources()) {
            return;
        }
        app.getMessageBus().connect().subscribe(IdePerformanceListener.TOPIC, (Object)new IdePerformanceListener(){
            final List<ThreadDump> myCurrentDumps = new ArrayList<ThreadDump>();
            List<StackTraceElement> myStacktraceCommonPart = null;
            volatile boolean myFreezeRecording = false;

            public void uiFreezeStarted() {
                this.myFreezeRecording = Registry.is((String)"performance.watcher.freeze.report") && !DebugAttachDetector.isAttached();
            }

            public void dumpedThreads(@NotNull File toFile, @NotNull ThreadDump dump) {
                if (toFile == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (dump == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (this.myFreezeRecording) {
                    this.myCurrentDumps.add(dump);
                    Object[] edtStack = dump.getEDTStackTrace();
                    if (edtStack != null) {
                        this.myStacktraceCommonPart = this.myStacktraceCommonPart == null ? ContainerUtil.newArrayList((Object[])edtStack) : PerformanceWatcher.getStacktraceCommonPart(this.myStacktraceCommonPart, (StackTraceElement[])edtStack);
                    }
                }
            }

            public void uiFreezeFinished(int lengthInSeconds) {
                if (!this.myFreezeRecording) {
                    return;
                }
                this.myFreezeRecording = false;
                if (lengthInSeconds > FREEZE_THRESHOLD && this.myCurrentDumps.size() >= Math.max(3, lengthInSeconds * 500 / Registry.intValue((String)"performance.watcher.unresponsive.interval.ms")) && !ContainerUtil.isEmpty(this.myStacktraceCommonPart)) {
                    Throwable t;
                    int size = Math.min(this.myCurrentDumps.size(), 20);
                    int step = this.myCurrentDumps.size() / size;
                    Attachment[] attachments = new Attachment[size];
                    for (int i = 0; i < size; ++i) {
                        Attachment attachment = new Attachment("dump-" + i + ".txt", this.myCurrentDumps.get(i * step).getRawDump());
                        attachment.setIncluded(true);
                        attachments[i] = attachment;
                    }
                    IdeaLoggingEvent event = this.createEvent(lengthInSeconds, attachments);
                    if (event != null && IdeErrorsDialog.getSubmitter(t = event.getThrowable(), IdeErrorsDialog.findPluginId(t)) instanceof ITNReporter) {
                        MessagePool.getInstance().addIdeFatalMessage(event);
                    }
                }
                this.myCurrentDumps.clear();
                this.myStacktraceCommonPart = null;
            }

            @Nullable
            private IdeaLoggingEvent createEvent(int lengthInSeconds, Attachment[] attachments) {
                List<StackTraceElement> commonStack;
                List<StackTraceElement[]> reasonStacks;
                boolean allInEdt = IdeaFreezeReporter.edts(this.myCurrentDumps).map(ThreadInfo::getThreadState).allMatch(Thread.State.RUNNABLE::equals);
                if (allInEdt) {
                    reasonStacks = IdeaFreezeReporter.edts(this.myCurrentDumps).map(ThreadInfo::getStackTrace).toList();
                } else {
                    reasonStacks = new ArrayList();
                    long causeThreadId = -1L;
                    block0: for (ThreadDump dump : this.myCurrentDumps) {
                        if (causeThreadId == -1L) {
                            String lockName;
                            Object[] threadInfos = dump.getThreadInfos();
                            ThreadInfo edt = (ThreadInfo)ContainerUtil.find((Object[])threadInfos, ThreadDumper::isEDT);
                            if (edt == null || edt.getThreadState() == Thread.State.RUNNABLE || (lockName = edt.getLockName()) == null || !lockName.contains("ReadMostlyRWLock")) continue;
                            for (Object info : threadInfos) {
                                if (((ThreadInfo)info).getThreadState() != Thread.State.RUNNABLE || ContainerUtil.find((Object[])((ThreadInfo)info).getStackTrace(), s -> "runReadAction".equals(s.getMethodName()) || "tryRunReadAction".equals(s.getMethodName())) == null) continue;
                                causeThreadId = ((ThreadInfo)info).getThreadId();
                                reasonStacks.add(((ThreadInfo)info).getStackTrace());
                                continue block0;
                            }
                            continue;
                        }
                        long finalCauseThreadId = causeThreadId;
                        ThreadInfo causeThread = (ThreadInfo)ContainerUtil.find((Object[])dump.getThreadInfos(), i -> i.getThreadId() == finalCauseThreadId);
                        if (causeThread == null) continue;
                        reasonStacks.add(causeThread.getStackTrace());
                    }
                }
                if (reasonStacks.isEmpty()) {
                    reasonStacks = IdeaFreezeReporter.edts(this.myCurrentDumps).map(ThreadInfo::getStackTrace).toList();
                }
                if (ContainerUtil.isEmpty((Collection)(commonStack = IdeaFreezeReporter.findDominantCommonStack(reasonStacks)))) {
                    commonStack = this.myStacktraceCommonPart;
                }
                if (!ContainerUtil.isEmpty((Collection)commonStack)) {
                    String edtNote = allInEdt ? "in EDT " : "";
                    return LogMessage.createEvent(new Freeze(commonStack), "Freeze " + edtNote + "for " + lengthInSeconds + " seconds", attachments);
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "toFile";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "dump";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/diagnostic/IdeaFreezeReporter$1";
                objectArray[2] = "dumpedThreads";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static StreamEx<ThreadInfo> edts(List<ThreadDump> dumps) {
        return (StreamEx)StreamEx.of(dumps).flatArray(ThreadDump::getThreadInfos).filter(ThreadDumper::isEDT);
    }

    @Nullable
    private static List<StackTraceElement> findDominantCommonStack(List<StackTraceElement[]> stacks) {
        CallTreeNode mostHitChild;
        CallTreeNode root = new CallTreeNode(null, null);
        for (StackTraceElement[] stack : stacks) {
            CallTreeNode node = root;
            for (int i = stack.length - 1; i >= 0; --i) {
                node = node.addCallee(stack[i]);
            }
        }
        int half = stacks.size() / 2;
        CallTreeNode node = root.getMostHitChild();
        if (node == null) {
            return null;
        }
        while (!node.myChildren.isEmpty() && (mostHitChild = node.getMostHitChild()) != null && mostHitChild.myTotalHits > half) {
            node = mostHitChild;
        }
        ArrayList<StackTraceElement> res2 = new ArrayList<StackTraceElement>();
        while (node != null && node.myStackTraceElement != null) {
            res2.add(node.myStackTraceElement);
            node = node.myParent;
        }
        return res2;
    }

    private static class CallTreeNode {
        final StackTraceElement myStackTraceElement;
        final CallTreeNode myParent;
        final List<CallTreeNode> myChildren = ContainerUtil.newSmartList();
        int myTotalHits = 1;

        private CallTreeNode(StackTraceElement element, CallTreeNode parent) {
            this.myStackTraceElement = element;
            this.myParent = parent;
        }

        CallTreeNode addCallee(StackTraceElement e) {
            for (CallTreeNode child2 : this.myChildren) {
                if (!PerformanceWatcher.compareStackTraceElements(child2.myStackTraceElement, e)) continue;
                ++child2.myTotalHits;
                return child2;
            }
            CallTreeNode child3 = new CallTreeNode(e, this);
            this.myChildren.add(child3);
            return child3;
        }

        @Nullable
        CallTreeNode getMostHitChild() {
            CallTreeNode currentMax = null;
            for (CallTreeNode child2 : this.myChildren) {
                if (currentMax != null && child2.myTotalHits <= currentMax.myTotalHits) continue;
                currentMax = child2;
            }
            return currentMax;
        }

        public String toString() {
            return this.myTotalHits + " " + this.myStackTraceElement;
        }
    }
}

