/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.hprof.analysis;

import com.google.common.base.Stopwatch;
import com.intellij.diagnostic.hprof.analysis.GCRootPathsTree;
import com.intellij.diagnostic.hprof.classstore.ClassDefinition;
import com.intellij.diagnostic.hprof.classstore.StaticField;
import com.intellij.diagnostic.hprof.histogram.Histogram;
import com.intellij.diagnostic.hprof.histogram.HistogramEntry;
import com.intellij.diagnostic.hprof.navigator.ObjectNavigator;
import com.intellij.diagnostic.hprof.util.IntList;
import com.intellij.diagnostic.hprof.util.PartialProgressIndicator;
import com.intellij.diagnostic.hprof.visitors.HistogramVisitor;
import com.intellij.openapi.progress.ProgressIndicator;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntProcedure;
import gnu.trove.TLongArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J\u0006\u0010\u001b\u001a\u00020\u0014J\u0016\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u0011J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u0019H\u0002J\f\u0010!\u001a\u00020\u0019*\u00020\u0003H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fj\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/diagnostic/hprof/analysis/AnalyzeGraph;", "", "nav", "Lcom/intellij/diagnostic/hprof/navigator/ObjectNavigator;", "parentList", "Lcom/intellij/diagnostic/hprof/util/IntList;", "sizesList", "visitedList", "nominatedClassNames", "", "", "includeMetaInfo", "", "(Lcom/intellij/diagnostic/hprof/navigator/ObjectNavigator;Lcom/intellij/diagnostic/hprof/util/IntList;Lcom/intellij/diagnostic/hprof/util/IntList;Lcom/intellij/diagnostic/hprof/util/IntList;Ljava/util/Set;Z)V", "nominatedInstances", "Ljava/util/HashMap;", "Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "Lgnu/trove/TIntHashSet;", "Lkotlin/collections/HashMap;", "strongRefHistogram", "Lcom/intellij/diagnostic/hprof/histogram/Histogram;", "analyze", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getParentIdForObjectId", "", "objectId", "getStrongRefHistogram", "prepareReport", "disposedObjectIDs", "setParentForObjectId", "", "parentId", "getParentId", "intellij.platform.ide.impl"})
public final class AnalyzeGraph {
    private Histogram strongRefHistogram;
    private final HashMap<ClassDefinition, TIntHashSet> nominatedInstances;
    private final ObjectNavigator nav;
    private final IntList parentList;
    private final IntList sizesList;
    private final IntList visitedList;
    private final Set<String> nominatedClassNames;
    private final boolean includeMetaInfo;

    private final long getParentId(@NotNull ObjectNavigator $this$getParentId) {
        return this.getParentIdForObjectId($this$getParentId.getId());
    }

    private final void setParentForObjectId(long objectId, long parentId) {
        this.parentList.set((int)objectId, (int)parentId);
    }

    private final long getParentIdForObjectId(long objectId) {
        return this.parentList.get((int)objectId);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String analyze(@NotNull ProgressIndicator progress) {
        void $this$sortedByDescending$iv;
        Collection<HistogramEntry> collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable tmp;
        Object $this$getOrPut$iv;
        void toVisit;
        boolean bl;
        String it;
        Intrinsics.checkParameterIsNotNull((Object)progress, (String)"progress");
        StringBuilder result2 = new StringBuilder();
        Iterator<Long> roots = this.nav.createRootsIterator();
        this.nominatedInstances.clear();
        Iterable $this$forEach$iv = this.nominatedClassNames;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            bl = false;
            ((Map)this.nominatedInstances).put(this.nav.getClassStore().get(it), new TIntHashSet());
        }
        progress.setText2("Collect all object roots");
        $this$forEach$iv = new Ref.ObjectRef();
        ((Ref.ObjectRef)$this$forEach$iv).element = new TIntArrayList();
        Object toVisit2 = new TIntArrayList();
        this.nav.getClassStore().forEachClass((Function1<? super ClassDefinition, Unit>)((Function1)new Function1<ClassDefinition, Unit>(this, (Ref.ObjectRef)toVisit){
            final /* synthetic */ AnalyzeGraph this$0;
            final /* synthetic */ Ref.ObjectRef $toVisit;

            public final void invoke(@NotNull ClassDefinition classDefinition) {
                int n;
                Intrinsics.checkParameterIsNotNull((Object)classDefinition, (String)"classDefinition");
                if (AnalyzeGraph.access$getParentIdForObjectId(this.this$0, classDefinition.getId()) == 0L) {
                    ((TIntArrayList)this.$toVisit.element).add((int)classDefinition.getId());
                    AnalyzeGraph.access$setParentForObjectId(this.this$0, classDefinition.getId(), classDefinition.getId());
                }
                Object[] $this$forEach$iv = classDefinition.getStaticFields();
                boolean $i$f$forEach = false;
                StaticField[] staticFieldArray = $this$forEach$iv;
                int n2 = staticFieldArray.length;
                for (n = 0; n < n2; ++n) {
                    StaticField element$iv;
                    StaticField it = element$iv = staticFieldArray[n];
                    boolean bl = false;
                    long objectId = it.getObjectId();
                    if (objectId == 0L) continue;
                    ((TIntArrayList)this.$toVisit.element).add((int)objectId);
                    AnalyzeGraph.access$setParentForObjectId(this.this$0, objectId, objectId);
                }
                $this$forEach$iv = classDefinition.getConstantFields();
                $i$f$forEach = false;
                staticFieldArray = $this$forEach$iv;
                n2 = staticFieldArray.length;
                for (n = 0; n < n2; ++n) {
                    StaticField element$iv;
                    StaticField objectId = element$iv = staticFieldArray[n];
                    boolean bl = false;
                    if (objectId == 0L) continue;
                    ((TIntArrayList)this.$toVisit.element).add((int)objectId);
                    AnalyzeGraph.access$setParentForObjectId(this.this$0, (long)objectId, (long)objectId);
                }
            }
            {
                this.this$0 = analyzeGraph;
                this.$toVisit = objectRef;
                super(1);
            }
        }));
        int leafCounter = 0;
        while (roots.hasNext()) {
            long rootObjectId = ((Number)roots.next()).longValue();
            ObjectNavigator.goTo$default(this.nav, rootObjectId, null, 2, null);
            if (this.getParentId(this.nav) != 0L) continue;
            ((TIntArrayList)toVisit.element).add((int)this.nav.getId());
            this.setParentForObjectId(this.nav.getId(), this.nav.getId());
        }
        StringBuilder rootObjectId = result2;
        it = "Roots count: " + ((TIntArrayList)toVisit.element).size();
        bl = false;
        StringBuilder stringBuilder = rootObjectId.append(it);
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder);
        rootObjectId = result2;
        it = "Classes count: " + this.nav.getClassStore().size();
        bl = false;
        StringBuilder stringBuilder2 = rootObjectId.append(it);
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder2, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder2);
        progress.setText2("Walking object graph");
        HashMap strongRefHistogramEntires = new HashMap();
        PartialProgressIndicator walkProgress = new PartialProgressIndicator(progress, 0.1, 0.5);
        int visitedInstancesCount = 0;
        Stopwatch stopwatch = Stopwatch.createStarted();
        TLongArrayList references = new TLongArrayList();
        int visitedCount = 0;
        while (!((TIntArrayList)toVisit.element).isEmpty()) {
            int n = 0;
            int n2 = ((TIntArrayList)toVisit.element).size();
            while (n < n2) {
                Object object;
                void i;
                int id = ((TIntArrayList)toVisit.element).get((int)i);
                ObjectNavigator.goTo$default(this.nav, id, null, 2, null);
                ++visitedInstancesCount;
                this.nav.copyReferencesTo(references);
                ClassDefinition currentObjectClass = this.nav.getClass();
                TIntHashSet tIntHashSet = this.nominatedInstances.get(currentObjectClass);
                if (tIntHashSet != null) {
                    tIntHashSet.add(id);
                }
                boolean isLeaf = true;
                int n3 = 0;
                int n4 = references.size();
                while (n3 < n4) {
                    void j;
                    long it2 = references.get((int)j);
                    if (it2 != 0L && this.getParentIdForObjectId(it2) == 0L) {
                        this.setParentForObjectId(it2, id);
                        toVisit2.add((int)it2);
                        isLeaf = false;
                    }
                    ++j;
                }
                this.visitedList.set(visitedCount++, id);
                int size = this.nav.getObjectSize();
                int sizeDivBy4 = (this.nav.getObjectSize() + 3) / 4;
                if (sizeDivBy4 == 0) {
                    sizeDivBy4 = 1;
                }
                this.sizesList.set(id, sizeDivBy4);
                $this$getOrPut$iv = strongRefHistogramEntires;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(currentObjectClass);
                if (value$iv == null) {
                    boolean bl2 = false;
                    HistogramVisitor.InternalHistogramEntry answer$iv = new HistogramVisitor.InternalHistogramEntry(currentObjectClass);
                    $this$getOrPut$iv.put(currentObjectClass, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((HistogramVisitor.InternalHistogramEntry)object).addInstance(size);
                if (isLeaf) {
                    ++leafCounter;
                }
                ++i;
            }
            walkProgress.setFraction(1.0 * (double)visitedInstancesCount / (double)this.nav.getInstanceCount());
            ((TIntArrayList)toVisit.element).resetQuick();
            tmp = (TIntArrayList)toVisit.element;
            toVisit.element = toVisit2;
            toVisit2 = tmp;
        }
        Collection collection2 = strongRefHistogramEntires.values();
        Intrinsics.checkExpressionValueIsNotNull(collection2, (String)"strongRefHistogramEntires\n        .values");
        tmp = collection2;
        AnalyzeGraph analyzeGraph = this;
        boolean $i$f$map = false;
        void id = $this$map$iv;
        Collection destination$iv$iv22 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it3;
            $this$getOrPut$iv = (HistogramVisitor.InternalHistogramEntry)item$iv$iv;
            collection = destination$iv$iv22;
            boolean bl3 = false;
            HistogramEntry histogramEntry = it3.asHistogramEntry();
            collection.add(histogramEntry);
        }
        collection = (List)destination$iv$iv22;
        $this$map$iv = collection;
        boolean $i$f$sortedByDescending = false;
        $this$mapTo$iv$iv = $this$sortedByDescending$iv;
        boolean destination$iv$iv22 = false;
        Comparator comparator2 = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                HistogramEntry it = (HistogramEntry)b;
                boolean bl2 = false;
                Comparable comparable = Long.valueOf(it.getTotalInstances());
                it = (HistogramEntry)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Long l = it.getTotalInstances();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
            }
        };
        collection = CollectionsKt.sortedWith((Iterable)$this$mapTo$iv$iv, (Comparator)comparator2);
        long l = visitedCount;
        Collection<HistogramEntry> collection3 = collection;
        analyzeGraph.strongRefHistogram = new Histogram((List<HistogramEntry>)collection3, l);
        Stopwatch stopwatchUpdateSizes = Stopwatch.createStarted();
        for (int index = visitedCount - 1; index >= 0; --index) {
            int parentId;
            int id2 = this.visitedList.get(index);
            if (id2 == (parentId = this.parentList.get(id2))) continue;
            IntList intList = this.sizesList;
            int n = parentId;
            intList.set(n, intList.get(n) + this.sizesList.get(id2));
        }
        stopwatchUpdateSizes.stop();
        if (this.includeMetaInfo) {
            StringBuilder stringBuilder3 = result2;
            String string = "Analysis completed! Visited instances: " + visitedInstancesCount + ", time: " + stopwatch;
            boolean bl4 = false;
            StringBuilder stringBuilder4 = stringBuilder3.append(string);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder4, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder4);
            stringBuilder3 = result2;
            string = "Update sizes time: " + stopwatchUpdateSizes;
            bl4 = false;
            StringBuilder stringBuilder5 = stringBuilder3.append(string);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder5, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder5);
            stringBuilder3 = result2;
            string = "Leaves found: " + leafCounter;
            bl4 = false;
            StringBuilder stringBuilder6 = stringBuilder3.append(string);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder6, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder6);
        }
        String string = result2.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"result.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String prepareReport(@NotNull ProgressIndicator progress, @NotNull TIntHashSet disposedObjectIDs) {
        void counter;
        Intrinsics.checkParameterIsNotNull((Object)progress, (String)"progress");
        Intrinsics.checkParameterIsNotNull((Object)disposedObjectIDs, (String)"disposedObjectIDs");
        StringBuilder result2 = new StringBuilder();
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = 0;
        Stopwatch stopwatch = Stopwatch.createUnstarted();
        this.nominatedInstances.forEach(new BiConsumer<ClassDefinition, TIntHashSet>(this, progress, (Ref.IntRef)counter, stopwatch, result2, disposedObjectIDs){
            final /* synthetic */ AnalyzeGraph this$0;
            final /* synthetic */ ProgressIndicator $progress;
            final /* synthetic */ Ref.IntRef $counter;
            final /* synthetic */ Stopwatch $stopwatch;
            final /* synthetic */ StringBuilder $result;
            final /* synthetic */ TIntHashSet $disposedObjectIDs;

            public final void accept(@NotNull ClassDefinition classDefinition, @NotNull TIntHashSet set) {
                Intrinsics.checkParameterIsNotNull((Object)classDefinition, (String)"classDefinition");
                Intrinsics.checkParameterIsNotNull((Object)set, (String)"set");
                this.$progress.setFraction((double)this.$counter.element / (double)AnalyzeGraph.access$getNominatedInstances$p(this.this$0).size());
                this.$progress.setText2("Processing: " + set.size() + ' ' + classDefinition.getPrettyName());
                this.$stopwatch.reset().start();
                StringsKt.appendln((StringBuilder)this.$result);
                StringBuilder stringBuilder = this.$result;
                CharSequence charSequence = "CLASS: " + classDefinition.getPrettyName() + " (" + set.size() + " objects)";
                boolean bl = false;
                StringBuilder stringBuilder2 = stringBuilder.append((String)charSequence);
                Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder2, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder2);
                GCRootPathsTree referenceRegistry = new GCRootPathsTree(this.$disposedObjectIDs, AnalyzeGraph.access$getParentList$p(this.this$0), AnalyzeGraph.access$getSizesList$p(this.this$0), AnalyzeGraph.access$getNav$p(this.this$0), classDefinition);
                set.forEach(new TIntProcedure(referenceRegistry){
                    final /* synthetic */ GCRootPathsTree $referenceRegistry;

                    public final boolean execute(int objectId) {
                        this.$referenceRegistry.registerObject(objectId);
                        return true;
                    }
                    {
                        this.$referenceRegistry = gCRootPathsTree;
                    }
                });
                this.$result.append(referenceRegistry.printTree(100, 25));
                if (AnalyzeGraph.access$getIncludeMetaInfo$p(this.this$0)) {
                    charSequence = this.$result;
                    String string = "Report for " + classDefinition.getPrettyName() + " created in " + this.$stopwatch;
                    boolean bl2 = false;
                    StringBuilder stringBuilder3 = ((StringBuilder)charSequence).append(string);
                    Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder3, (String)"append(value)");
                    StringsKt.appendln((StringBuilder)stringBuilder3);
                }
                int n = this.$counter.element;
                this.$counter.element = n + 1;
            }
            {
                this.this$0 = analyzeGraph;
                this.$progress = progressIndicator;
                this.$counter = intRef;
                this.$stopwatch = stopwatch;
                this.$result = stringBuilder;
                this.$disposedObjectIDs = tIntHashSet;
            }
        });
        progress.setFraction(1.0);
        String string = result2.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"result.toString()");
        return string;
    }

    @NotNull
    public final Histogram getStrongRefHistogram() {
        Histogram histogram = this.strongRefHistogram;
        if (histogram == null) {
            throw (Throwable)new IllegalStateException("Graph not analyzed.");
        }
        return histogram;
    }

    public AnalyzeGraph(@NotNull ObjectNavigator nav, @NotNull IntList parentList, @NotNull IntList sizesList, @NotNull IntList visitedList, @NotNull Set<String> nominatedClassNames, boolean includeMetaInfo) {
        Intrinsics.checkParameterIsNotNull((Object)nav, (String)"nav");
        Intrinsics.checkParameterIsNotNull((Object)parentList, (String)"parentList");
        Intrinsics.checkParameterIsNotNull((Object)sizesList, (String)"sizesList");
        Intrinsics.checkParameterIsNotNull((Object)visitedList, (String)"visitedList");
        Intrinsics.checkParameterIsNotNull(nominatedClassNames, (String)"nominatedClassNames");
        this.nav = nav;
        this.parentList = parentList;
        this.sizesList = sizesList;
        this.visitedList = visitedList;
        this.nominatedClassNames = nominatedClassNames;
        this.includeMetaInfo = includeMetaInfo;
        this.nominatedInstances = new HashMap();
    }

    public static final /* synthetic */ long access$getParentIdForObjectId(AnalyzeGraph $this, long objectId) {
        return $this.getParentIdForObjectId(objectId);
    }

    public static final /* synthetic */ void access$setParentForObjectId(AnalyzeGraph $this, long objectId, long parentId) {
        $this.setParentForObjectId(objectId, parentId);
    }

    public static final /* synthetic */ HashMap access$getNominatedInstances$p(AnalyzeGraph $this) {
        return $this.nominatedInstances;
    }

    public static final /* synthetic */ IntList access$getParentList$p(AnalyzeGraph $this) {
        return $this.parentList;
    }

    public static final /* synthetic */ IntList access$getSizesList$p(AnalyzeGraph $this) {
        return $this.sizesList;
    }

    public static final /* synthetic */ ObjectNavigator access$getNav$p(AnalyzeGraph $this) {
        return $this.nav;
    }

    public static final /* synthetic */ boolean access$getIncludeMetaInfo$p(AnalyzeGraph $this) {
        return $this.includeMetaInfo;
    }
}

