/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.hprof.analysis;

import com.intellij.diagnostic.hprof.histogram.Histogram;
import com.intellij.diagnostic.hprof.histogram.HistogramEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/diagnostic/hprof/analysis/ClassNomination;", "", "histogram", "Lcom/intellij/diagnostic/hprof/histogram/Histogram;", "classLimitPerCategory", "", "(Lcom/intellij/diagnostic/hprof/histogram/Histogram;I)V", "isInterestingClass", "", "name", "", "nominateClasses", "", "Lcom/intellij/diagnostic/hprof/histogram/HistogramEntry;", "intellij.platform.ide.impl"})
public final class ClassNomination {
    private final Histogram histogram;
    private final int classLimitPerCategory;

    @NotNull
    public final Set<HistogramEntry> nominateClasses() {
        HistogramEntry it;
        Object element$iv2;
        Object element$iv$iv;
        Iterator $this$filterTo$iv$iv;
        HashSet<HistogramEntry> resultClasses = new HashSet<HistogramEntry>();
        List<HistogramEntry> entries = this.histogram.getEntries();
        Iterable $this$sortedByDescending$iv = entries;
        boolean $i$f$sortedByDescending = false;
        Iterable iterable = $this$sortedByDescending$iv;
        boolean bl = false;
        Comparator comparator2 = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                HistogramEntry it = (HistogramEntry)b;
                boolean bl2 = false;
                Comparable comparable = Long.valueOf(it.getTotalInstances());
                it = (HistogramEntry)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Long l = it.getTotalInstances();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
            }
        };
        List histogramByInstances = CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator2);
        Iterable $this$filter$iv = histogramByInstances;
        boolean $i$f$filter = false;
        Iterable iterable2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = iterator.next();
            HistogramEntry it2 = (HistogramEntry)element$iv$iv;
            boolean bl2 = false;
            if (!this.isInterestingClass(it2.getClassDefinition().getName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List interestingClasses = (List)destination$iv$iv;
        Iterable $this$forEach$iv = CollectionsKt.take((Iterable)histogramByInstances, (int)this.classLimitPerCategory);
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            HistogramEntry it3 = (HistogramEntry)element$iv2;
            boolean bl3 = false;
            resultClasses.add(it3);
        }
        $this$forEach$iv = CollectionsKt.take((Iterable)interestingClasses, (int)this.classLimitPerCategory);
        $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            HistogramEntry it4 = (HistogramEntry)element$iv2;
            boolean $i$a$-forEach-ClassNomination$nominateClasses$52 = false;
            resultClasses.add(it4);
        }
        Iterable $this$sortedByDescending$iv2 = entries;
        boolean $i$f$sortedByDescending2 = false;
        element$iv2 = $this$sortedByDescending$iv2;
        boolean bl4 = false;
        Comparator $i$a$-forEach-ClassNomination$nominateClasses$52 = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                HistogramEntry it = (HistogramEntry)b;
                boolean bl2 = false;
                Comparable comparable = Long.valueOf(it.getTotalBytes());
                it = (HistogramEntry)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Long l = it.getTotalBytes();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
            }
        };
        List histogramByBytes = CollectionsKt.sortedWith(element$iv2, (Comparator)$i$a$-forEach-ClassNomination$nominateClasses$52);
        Iterable $this$sortedByDescending$iv3 = interestingClasses;
        boolean $i$f$sortedByDescending3 = false;
        Iterator iterator2 = $this$sortedByDescending$iv3;
        boolean $i$a$-forEach-ClassNomination$nominateClasses$52 = false;
        element$iv$iv = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                HistogramEntry it = (HistogramEntry)b;
                boolean bl2 = false;
                Comparable comparable = Long.valueOf(it.getTotalBytes());
                it = (HistogramEntry)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Long l = it.getTotalBytes();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
            }
        };
        List interestingClassesByBytes = CollectionsKt.sortedWith((Iterable)((Object)iterator2), element$iv$iv);
        Iterable $this$forEach$iv2 = CollectionsKt.take((Iterable)histogramByBytes, (int)this.classLimitPerCategory);
        boolean $i$f$forEach2 = false;
        for (Object element$iv3 : $this$forEach$iv2) {
            it = (HistogramEntry)element$iv3;
            boolean bl5 = false;
            resultClasses.add(it);
        }
        $this$forEach$iv2 = CollectionsKt.take((Iterable)interestingClassesByBytes, (int)this.classLimitPerCategory);
        $i$f$forEach2 = false;
        for (Object element$iv4 : $this$forEach$iv2) {
            it = (HistogramEntry)element$iv4;
            boolean bl6 = false;
            resultClasses.add(it);
        }
        return resultClasses;
    }

    private final boolean isInterestingClass(String name) {
        int n;
        String localName = name;
        int lastBracketIndex = StringsKt.lastIndexOf$default((CharSequence)localName, (char)'[', (int)0, (boolean)false, (int)6, null);
        if (lastBracketIndex >= 1) {
            String string = localName;
            n = 0;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(lastBracketIndex);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            localName = string3;
        }
        if (localName.length() == 2 && localName.charAt(0) == '[') {
            return false;
        }
        if (StringsKt.startsWith$default((String)localName, (String)"[L", (boolean)false, (int)2, null)) {
            boolean bl = StringsKt.last((CharSequence)localName) == ';';
            n = 0;
            int n2 = 0;
            if (_Assertions.ENABLED && !bl) {
                boolean bl2 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            String string = localName;
            n = 2;
            n2 = localName.length() - 1;
            boolean bl3 = false;
            String string4 = string;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            localName = string5;
        }
        return !StringsKt.startsWith$default((String)localName, (String)"java.", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)localName, (String)"com.google.common.", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)localName, (String)"kotlin.", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)localName, (String)"com.intellij.util.", (boolean)false, (int)2, null);
    }

    public ClassNomination(@NotNull Histogram histogram, int classLimitPerCategory) {
        Intrinsics.checkParameterIsNotNull((Object)histogram, (String)"histogram");
        this.histogram = histogram;
        this.classLimitPerCategory = classLimitPerCategory;
    }
}

