/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.hprof.classstore;

import com.intellij.diagnostic.hprof.classstore.ClassStore;
import com.intellij.diagnostic.hprof.classstore.InstanceField;
import com.intellij.diagnostic.hprof.classstore.StaticField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.LongUnaryOperator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u0000 42\u00020\u0001:\u00014BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000b\u00a2\u0006\u0002\u0010\u0011J\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030%2\u0006\u0010&\u001a\u00020'J\u000e\u0010(\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\u0003J\u000e\u0010*\u001a\u00020\u00002\u0006\u0010+\u001a\u00020,J\u0013\u0010-\u001a\u00020.2\b\u0010/\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0010\u00100\u001a\u0004\u0018\u00010\u00002\u0006\u0010&\u001a\u00020'J\b\u00101\u001a\u00020\bH\u0016J\u0006\u00102\u001a\u00020.J\u0006\u00103\u001a\u00020.R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0019R\u0019\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\n\n\u0002\u0010\u001e\u001a\u0004\b\u001c\u0010\u001dR\u0019\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000b\u00a2\u0006\n\n\u0002\u0010!\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0015R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0017\u00a8\u00065"}, d2={"Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "", "name", "", "id", "", "superClassId", "instanceSize", "", "superClassOffset", "refInstanceFields", "", "Lcom/intellij/diagnostic/hprof/classstore/InstanceField;", "constantFields", "", "staticFields", "Lcom/intellij/diagnostic/hprof/classstore/StaticField;", "(Ljava/lang/String;JJII[Lcom/intellij/diagnostic/hprof/classstore/InstanceField;[J[Lcom/intellij/diagnostic/hprof/classstore/StaticField;)V", "getConstantFields", "()[J", "getId", "()J", "getInstanceSize", "()I", "getName", "()Ljava/lang/String;", "prettyName", "getPrettyName", "getRefInstanceFields", "()[Lcom/intellij/diagnostic/hprof/classstore/InstanceField;", "[Lcom/intellij/diagnostic/hprof/classstore/InstanceField;", "getStaticFields", "()[Lcom/intellij/diagnostic/hprof/classstore/StaticField;", "[Lcom/intellij/diagnostic/hprof/classstore/StaticField;", "getSuperClassId", "getSuperClassOffset", "allRefFieldNames", "", "classStore", "Lcom/intellij/diagnostic/hprof/classstore/ClassStore;", "copyWithName", "newName", "copyWithRemappedIDs", "remappingFunction", "Ljava/util/function/LongUnaryOperator;", "equals", "", "other", "getSuperClass", "hashCode", "isArray", "isPrimitiveArray", "Companion", "intellij.platform.ide.impl"})
public final class ClassDefinition {
    @NotNull
    private final String name;
    private final long id;
    private final long superClassId;
    private final int instanceSize;
    private final int superClassOffset;
    @NotNull
    private final InstanceField[] refInstanceFields;
    @NotNull
    private final long[] constantFields;
    @NotNull
    private final StaticField[] staticFields;
    public static final Companion Companion = new Companion(null);

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.diagnostic.hprof.classstore.ClassDefinition");
        }
        ClassDefinition cfr_ignored_0 = (ClassDefinition)object2;
        if (this.id != ((ClassDefinition)other).id) {
            return false;
        }
        if (this.id == 0L && ((ClassDefinition)other).id == 0L) {
            return Intrinsics.areEqual((Object)this.name, (Object)((ClassDefinition)other).name);
        }
        return true;
    }

    @NotNull
    public final String getPrettyName() {
        return Companion.computePrettyName(this.name);
    }

    @Nullable
    public final ClassDefinition getSuperClass(@NotNull ClassStore classStore) {
        Intrinsics.checkParameterIsNotNull((Object)classStore, (String)"classStore");
        long l = this.superClassId;
        return l == 0L ? null : classStore.get((int)this.superClassId);
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public final boolean isArray() {
        return this.name.charAt(0) == '[';
    }

    public final boolean isPrimitiveArray() {
        return this.isArray() && this.name.length() == 2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ClassDefinition copyWithRemappedIDs(@NotNull LongUnaryOperator remappingFunction) {
        int n;
        Object[] objectArray;
        int n2;
        int n3;
        Intrinsics.checkParameterIsNotNull((Object)remappingFunction, (String)"remappingFunction");
        Function1<Long, Long> $fun$map$1 = new Function1<Long, Long>(remappingFunction){
            final /* synthetic */ LongUnaryOperator $remappingFunction;

            public final long invoke(long id) {
                return this.$remappingFunction.applyAsLong(id);
            }
            {
                this.$remappingFunction = longUnaryOperator;
                super(1);
            }
        };
        int n4 = this.constantFields.length;
        long[] lArray = new long[n4];
        int n5 = 0;
        while (n5 < n4) {
            void it;
            long l;
            n3 = n5;
            n2 = n5++;
            objectArray = lArray;
            n = 0;
            objectArray[n2] = l = $fun$map$1.invoke(this.constantFields[it]);
        }
        long[] newConstantFields = lArray;
        int n6 = this.staticFields.length;
        StaticField[] staticFieldArray = new StaticField[n6];
        n3 = 0;
        while (n3 < n6) {
            void it;
            n = n3;
            n2 = n3++;
            objectArray = staticFieldArray;
            boolean bl = false;
            StaticField oldStaticField = this.staticFields[it];
            StaticField staticField = new StaticField(oldStaticField.getName(), $fun$map$1.invoke(oldStaticField.getObjectId()));
            objectArray[n2] = (long)staticField;
        }
        StaticField[] newStaticFields = staticFieldArray;
        return new ClassDefinition(this.name, $fun$map$1.invoke(this.id), $fun$map$1.invoke(this.superClassId), this.instanceSize, this.superClassOffset, this.refInstanceFields, newConstantFields, newStaticFields);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> allRefFieldNames(@NotNull ClassStore classStore) {
        Intrinsics.checkParameterIsNotNull((Object)classStore, (String)"classStore");
        boolean bl = false;
        List result2 = new ArrayList();
        ClassDefinition currentClass = this;
        while (true) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            InstanceField[] instanceFieldArray = currentClass.refInstanceFields;
            List list2 = result2;
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            void var9_10 = $this$mapTo$iv$iv;
            int n = ((void)var9_10).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var13_14 = item$iv$iv = var9_10[i];
                collection = destination$iv$iv;
                boolean bl2 = false;
                String string = it.getName();
                collection.add(string);
            }
            collection = (List)destination$iv$iv;
            list2.addAll((Collection)collection);
            if (currentClass.getSuperClass(classStore) != null) continue;
            break;
        }
        return result2;
    }

    @NotNull
    public final ClassDefinition copyWithName(@NotNull String newName) {
        Intrinsics.checkParameterIsNotNull((Object)newName, (String)"newName");
        return new ClassDefinition(newName, this.id, this.superClassId, this.instanceSize, this.superClassOffset, this.refInstanceFields, this.constantFields, this.staticFields);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final long getId() {
        return this.id;
    }

    public final long getSuperClassId() {
        return this.superClassId;
    }

    public final int getInstanceSize() {
        return this.instanceSize;
    }

    public final int getSuperClassOffset() {
        return this.superClassOffset;
    }

    @NotNull
    public final InstanceField[] getRefInstanceFields() {
        return this.refInstanceFields;
    }

    @NotNull
    public final long[] getConstantFields() {
        return this.constantFields;
    }

    @NotNull
    public final StaticField[] getStaticFields() {
        return this.staticFields;
    }

    public ClassDefinition(@NotNull String name, long id, long superClassId, int instanceSize, int superClassOffset, @NotNull InstanceField[] refInstanceFields, @NotNull long[] constantFields, @NotNull StaticField[] staticFields) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)refInstanceFields, (String)"refInstanceFields");
        Intrinsics.checkParameterIsNotNull((Object)constantFields, (String)"constantFields");
        Intrinsics.checkParameterIsNotNull((Object)staticFields, (String)"staticFields");
        this.name = name;
        this.id = id;
        this.superClassId = superClassId;
        this.instanceSize = instanceSize;
        this.superClassOffset = superClassOffset;
        this.refInstanceFields = refInstanceFields;
        this.constantFields = constantFields;
        this.staticFields = staticFields;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a8\u0006\u0006"}, d2={"Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition$Companion;", "", "()V", "computePrettyName", "", "name", "intellij.platform.ide.impl"})
    public static final class Companion {
        @NotNull
        public final String computePrettyName(@NotNull String name) {
            String string;
            int arraySymbolsCount;
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            if (!StringsKt.startsWith$default((CharSequence)name, (char)'[', (boolean)false, (int)2, null)) {
                return name;
            }
            for (arraySymbolsCount = 0; name.length() > arraySymbolsCount && name.charAt(arraySymbolsCount) == '['; ++arraySymbolsCount) {
            }
            if (name.length() <= arraySymbolsCount) {
                return name;
            }
            char arrayType = name.charAt(arraySymbolsCount);
            String arrayString = StringsKt.repeat((CharSequence)"[]", (int)arraySymbolsCount);
            switch (arrayType) {
                case 'B': {
                    string = "byte" + arrayString;
                    break;
                }
                case 'C': {
                    string = "char" + arrayString;
                    break;
                }
                case 'D': {
                    string = "double" + arrayString;
                    break;
                }
                case 'F': {
                    string = "float" + arrayString;
                    break;
                }
                case 'I': {
                    string = "int" + arrayString;
                    break;
                }
                case 'J': {
                    string = "long" + arrayString;
                    break;
                }
                case 'L': {
                    String string2 = name;
                    int n = arraySymbolsCount + 1;
                    int n2 = name.length() - 1;
                    StringBuilder stringBuilder = new StringBuilder();
                    boolean bl = false;
                    String string3 = string2.substring(n, n2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    String string4 = string3;
                    string = stringBuilder.append(string4).append(arrayString).toString();
                    break;
                }
                case 'S': {
                    string = "short" + arrayString;
                    break;
                }
                case 'Z': {
                    string = "boolean" + arrayString;
                    break;
                }
                default: {
                    string = name;
                }
            }
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

