/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.hprof.classstore;

import com.intellij.diagnostic.hprof.classstore.ClassDefinition;
import com.intellij.diagnostic.hprof.classstore.ClassStore;
import com.intellij.diagnostic.hprof.parser.HProfEventBasedParser;
import com.intellij.diagnostic.hprof.parser.Type;
import com.intellij.diagnostic.hprof.visitors.CollectStringValuesVisitor;
import com.intellij.diagnostic.hprof.visitors.CreateClassStoreVisitor;
import gnu.trove.TLongObjectHashMap;
import gnu.trove.TObjectProcedure;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.LongUnaryOperator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0010\t\n\u0002\b\b\u0018\u0000 (2\u00020\u0001:\u0001(B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0012J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0019J\u001a\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001b0\u001dJ\u0011\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020 H\u0086\u0002J\u0011\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020!H\u0086\u0002J\u0011\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0012H\u0086\u0002J\u0010\u0010\"\u001a\u0004\u0018\u00010\u00042\u0006\u0010#\u001a\u00020\u000eJ\u000e\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u0004J\u000e\u0010&\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\u0004J\u0006\u0010'\u001a\u00020 R\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u00040\nj\b\u0012\u0004\u0012\u00020\u0004`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00040\rj\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u0004`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0011\u001a\u001e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00040\rj\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0004`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/diagnostic/hprof/classstore/ClassStore;", "", "classes", "Lgnu/trove/TLongObjectHashMap;", "Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "(Lgnu/trove/TLongObjectHashMap;)V", "classClass", "getClassClass", "()Lcom/intellij/diagnostic/hprof/classstore/ClassDefinition;", "classDefinitionToShortPrettyName", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "primitiveArrayToClassDefinition", "Ljava/util/HashMap;", "Lcom/intellij/diagnostic/hprof/parser/Type;", "Lkotlin/collections/HashMap;", "softReferenceClass", "stringToClassDefinition", "", "weakReferenceClass", "containsClass", "", "name", "createStoreWithRemappedIDs", "remappingFunction", "Ljava/util/function/LongUnaryOperator;", "forEachClass", "", "func", "Lkotlin/Function1;", "get", "id", "", "", "getClassForPrimitiveArray", "t", "getShortPrettyNameForClass", "classDefinition", "isSoftOrWeakReferenceClass", "size", "Companion", "intellij.platform.ide.impl"})
public final class ClassStore {
    private final HashMap<String, ClassDefinition> stringToClassDefinition;
    private final HashSet<ClassDefinition> classDefinitionToShortPrettyName;
    private final ClassDefinition softReferenceClass;
    private final ClassDefinition weakReferenceClass;
    @NotNull
    private final ClassDefinition classClass;
    private final HashMap<Type, ClassDefinition> primitiveArrayToClassDefinition;
    private final TLongObjectHashMap<ClassDefinition> classes;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final ClassDefinition getClassClass() {
        return this.classClass;
    }

    @NotNull
    public final ClassDefinition get(int id) {
        Object object = this.classes.get((long)id);
        if (object == null) {
            Intrinsics.throwNpe();
        }
        return (ClassDefinition)object;
    }

    @NotNull
    public final ClassDefinition get(long id) {
        Object object = this.classes.get(id);
        if (object == null) {
            Intrinsics.throwNpe();
        }
        return (ClassDefinition)object;
    }

    @NotNull
    public final ClassDefinition get(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        ClassDefinition classDefinition = this.stringToClassDefinition.get(name);
        if (classDefinition == null) {
            Intrinsics.throwNpe();
        }
        return classDefinition;
    }

    public final boolean containsClass(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return this.stringToClassDefinition.containsKey(name);
    }

    @Nullable
    public final ClassDefinition getClassForPrimitiveArray(@NotNull Type t) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)t), (String)"t");
        return this.primitiveArrayToClassDefinition.get((Object)t);
    }

    public final int size() {
        return this.classes.size();
    }

    public final boolean isSoftOrWeakReferenceClass(@NotNull ClassDefinition classDefinition) {
        Intrinsics.checkParameterIsNotNull((Object)classDefinition, (String)"classDefinition");
        return Intrinsics.areEqual((Object)classDefinition, (Object)this.softReferenceClass) || Intrinsics.areEqual((Object)classDefinition, (Object)this.weakReferenceClass);
    }

    public final void forEachClass(@NotNull Function1<? super ClassDefinition, Unit> func) {
        Intrinsics.checkParameterIsNotNull(func, (String)"func");
        this.classes.forEachValue((TObjectProcedure)new TObjectProcedure<ClassDefinition>(func){
            final /* synthetic */ Function1 $func;

            public final boolean execute(ClassDefinition it) {
                ClassDefinition classDefinition = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)classDefinition, (String)"it");
                this.$func.invoke((Object)classDefinition);
                return true;
            }
            {
                this.$func = function1;
            }
        });
    }

    @NotNull
    public final ClassStore createStoreWithRemappedIDs(@NotNull LongUnaryOperator remappingFunction) {
        Intrinsics.checkParameterIsNotNull((Object)remappingFunction, (String)"remappingFunction");
        Function1<Long, Long> $fun$map$1 = new Function1<Long, Long>(remappingFunction){
            final /* synthetic */ LongUnaryOperator $remappingFunction;

            public final long invoke(long id) {
                return this.$remappingFunction.applyAsLong(id);
            }
            {
                this.$remappingFunction = longUnaryOperator;
                super(1);
            }
        };
        TLongObjectHashMap newClasses = new TLongObjectHashMap();
        this.classes.forEachValue((TObjectProcedure)new TObjectProcedure<ClassDefinition>(newClasses, $fun$map$1, remappingFunction){
            final /* synthetic */ TLongObjectHashMap $newClasses;
            final /* synthetic */ createStoreWithRemappedIDs.1 $map$1;
            final /* synthetic */ LongUnaryOperator $remappingFunction;

            public final boolean execute(ClassDefinition it) {
                this.$newClasses.put(this.$map$1.invoke(it.getId()), (Object)it.copyWithRemappedIDs(this.$remappingFunction));
                return true;
            }
            {
                this.$newClasses = tLongObjectHashMap;
                this.$map$1 = var2_2;
                this.$remappingFunction = longUnaryOperator;
            }
        });
        return new ClassStore((TLongObjectHashMap<ClassDefinition>)newClasses);
    }

    @NotNull
    public final String getShortPrettyNameForClass(@NotNull ClassDefinition classDefinition) {
        ClassDefinition outerClass;
        Intrinsics.checkParameterIsNotNull((Object)classDefinition, (String)"classDefinition");
        if (StringsKt.contains$default((CharSequence)classDefinition.getName(), (char)'$', (boolean)false, (int)2, null) ? (outerClass = this.stringToClassDefinition.get(StringsKt.substringBefore$default((String)classDefinition.getName(), (char)'$', null, (int)2, null))) != null && this.classDefinitionToShortPrettyName.contains(outerClass) : this.classDefinitionToShortPrettyName.contains(classDefinition)) {
            return StringsKt.substringAfterLast$default((String)classDefinition.getPrettyName(), (char)'.', null, (int)2, null);
        }
        return classDefinition.getPrettyName();
    }

    public ClassStore(@NotNull TLongObjectHashMap<ClassDefinition> classes) {
        Intrinsics.checkParameterIsNotNull(classes, (String)"classes");
        this.classes = classes;
        this.stringToClassDefinition = new HashMap();
        this.classDefinitionToShortPrettyName = new HashSet();
        this.primitiveArrayToClassDefinition = new HashMap();
        this.classes.forEachValue((TObjectProcedure)new TObjectProcedure<ClassDefinition>(){

            public final boolean execute(ClassDefinition classDefinition) {
                if (stringToClassDefinition.containsKey(classDefinition.getName())) {
                    int i = 1;
                    String newName = null;
                    do {
                        newName = classDefinition.getName() + '(' + ++i + ')';
                    } while (stringToClassDefinition.containsKey(newName));
                    ((Map)stringToClassDefinition).put(newName, classDefinition.copyWithName(newName));
                } else {
                    Map map2 = stringToClassDefinition;
                    String string = classDefinition.getName();
                    ClassDefinition classDefinition2 = classDefinition;
                    Intrinsics.checkExpressionValueIsNotNull((Object)classDefinition2, (String)"classDefinition");
                    map2.put(string, classDefinition2);
                }
                return true;
            }
        });
        ClassDefinition classDefinition = this.stringToClassDefinition.get("java.lang.ref.SoftReference");
        if (classDefinition == null) {
            Intrinsics.throwNpe();
        }
        this.softReferenceClass = classDefinition;
        ClassDefinition classDefinition2 = this.stringToClassDefinition.get("java.lang.ref.WeakReference");
        if (classDefinition2 == null) {
            Intrinsics.throwNpe();
        }
        this.weakReferenceClass = classDefinition2;
        ClassDefinition classDefinition3 = this.stringToClassDefinition.get("java.lang.Class");
        if (classDefinition3 == null) {
            Intrinsics.throwNpe();
        }
        this.classClass = classDefinition3;
        Type[] $this$forEach$iv = Type.values();
        boolean $i$f$forEach = false;
        Type[] typeArray = $this$forEach$iv;
        int n = typeArray.length;
        for (int i = 0; i < n; ++i) {
            ClassDefinition classDefinition4;
            Type element$iv;
            Type type = element$iv = typeArray[i];
            boolean bl = false;
            if (type == Type.OBJECT || this.stringToClassDefinition.get(type.getClassNameOfPrimitiveArray()) == null) continue;
            boolean bl2 = false;
            boolean bl3 = false;
            ClassDefinition classDefinition5 = classDefinition4;
            boolean bl4 = false;
            this.primitiveArrayToClassDefinition.put(type, classDefinition5);
        }
        final HashMap shortNameToClassDefinition = new HashMap();
        this.classes.forEachValue((TObjectProcedure)new TObjectProcedure<ClassDefinition>(){

            public final boolean execute(ClassDefinition it) {
                if (StringsKt.contains$default((CharSequence)it.getName(), (char)'$', (boolean)false, (int)2, null)) {
                    return true;
                }
                String prettyName = it.getPrettyName();
                String shortPrettyName = StringsKt.substringAfterLast$default((String)prettyName, (char)'.', null, (int)2, null);
                if (shortNameToClassDefinition.containsKey(shortPrettyName)) {
                    ClassDefinition prevClassDefinition = (ClassDefinition)shortNameToClassDefinition.get(shortPrettyName);
                    if (prevClassDefinition != null) {
                        ((Map)shortNameToClassDefinition).put(shortPrettyName, null);
                    }
                } else {
                    ((Map)shortNameToClassDefinition).put(shortPrettyName, it);
                }
                return true;
            }
        });
        shortNameToClassDefinition.forEach((BiConsumer)new BiConsumer<String, ClassDefinition>(){

            @Override
            public final void accept(@NotNull String $noName_0, @Nullable ClassDefinition classDef) {
                Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                if (classDef == null) {
                    return;
                }
                classDefinitionToShortPrettyName.add(classDef);
            }
        });
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/diagnostic/hprof/classstore/ClassStore$Companion;", "", "()V", "create", "Lcom/intellij/diagnostic/hprof/classstore/ClassStore;", "parser", "Lcom/intellij/diagnostic/hprof/parser/HProfEventBasedParser;", "intellij.platform.ide.impl"})
    public static final class Companion {
        @NotNull
        public final ClassStore create(@NotNull HProfEventBasedParser parser) {
            Intrinsics.checkParameterIsNotNull((Object)parser, (String)"parser");
            CreateClassStoreVisitor pass1 = new CreateClassStoreVisitor();
            parser.accept(pass1, "getClassDefinitions-pass1: create class objects");
            CollectStringValuesVisitor pass2 = new CollectStringValuesVisitor(pass1.getStringIDToStringMap());
            parser.accept(pass2, "getClassDefinitions-pass2: get strings");
            pass1.updateNames();
            return pass1.getClassStore();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

