/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util;

import com.intellij.diff.tools.util.SyncScrollSupport;
import com.intellij.diff.util.Range;
import com.intellij.diff.util.Side;
import com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class BaseSyncScrollable
implements SyncScrollSupport.SyncScrollable {
    private static final Logger LOG = Logger.getInstance(BaseSyncScrollable.class);

    protected abstract void processHelper(@NotNull ScrollHelper var1);

    @Override
    public int transfer(@NotNull Side baseSide, int line2) {
        if (baseSide == null) {
            BaseSyncScrollable.$$$reportNull$$$0(0);
        }
        Range range2 = this.getRange(baseSide, line2);
        return BaseSyncScrollable.transferLine(line2, range2);
    }

    @Override
    @NotNull
    public Range getRange(@NotNull Side baseSide, int line2) {
        if (baseSide == null) {
            BaseSyncScrollable.$$$reportNull$$$0(1);
        }
        if (line2 < 0) {
            LOG.error("Invalid line number: " + line2);
            Range range2 = BaseSyncScrollable.idRange(line2);
            if (range2 == null) {
                BaseSyncScrollable.$$$reportNull$$$0(2);
            }
            return range2;
        }
        ScrollHelper helper = new ScrollHelper(baseSide, line2);
        this.processHelper(helper);
        int master1 = helper.getMaster1();
        int master2 = helper.getMaster2();
        int slave1 = helper.getSlave1();
        int slave2 = helper.getSlave2();
        Range range3 = new Range(master1, master2, slave1, slave2);
        if (range3 == null) {
            BaseSyncScrollable.$$$reportNull$$$0(3);
        }
        return range3;
    }

    public static int transferLine(int line2, @NotNull Range range2) {
        if (range2 == null) {
            BaseSyncScrollable.$$$reportNull$$$0(4);
        }
        if (range2.start1 == line2) {
            return range2.start2;
        }
        if (range2.end1 == line2) {
            return range2.end2;
        }
        if (range2.end1 < line2) {
            return line2 - range2.end1 + range2.end2;
        }
        return Math.min(range2.start2 + (line2 - range2.start1), range2.end2);
    }

    @NotNull
    public static Range idRange(int line2) {
        Range range2 = new Range(line2, line2 + 1, line2, line2 + 1);
        if (range2 == null) {
            BaseSyncScrollable.$$$reportNull$$$0(5);
        }
        return range2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseSide";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/util/BaseSyncScrollable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/util/BaseSyncScrollable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRange";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "idRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "transfer";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRange";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "transferLine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class ScrollHelper {
        @NotNull
        private final Side mySide;
        private final int myLine;
        private int myLeft1;
        private int myLeft2;
        private int myRight1;
        private int myRight2;

        public ScrollHelper(@NotNull Side side, int line2) {
            if (side == null) {
                ScrollHelper.$$$reportNull$$$0(0);
            }
            this.myLeft1 = 0;
            this.myLeft2 = 0;
            this.myRight1 = 0;
            this.myRight2 = 0;
            this.mySide = side;
            this.myLine = line2;
        }

        public boolean process(int left, int right) {
            this.myLeft1 = this.myLeft2;
            this.myRight1 = this.myRight2;
            this.myLeft2 = left;
            this.myRight2 = right;
            return this.myLine > this.mySide.select(left, right);
        }

        public int getMaster1() {
            return this.mySide.select(this.myLeft1, this.myRight1);
        }

        public int getMaster2() {
            return this.mySide.select(this.myLeft2, this.myRight2);
        }

        public int getSlave1() {
            return this.mySide.select(this.myRight1, this.myLeft1);
        }

        public int getSlave2() {
            return this.mySide.select(this.myRight2, this.myLeft2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/util/BaseSyncScrollable$ScrollHelper", "<init>"));
        }
    }
}

