/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard.actions;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunManager;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.dashboard.RunDashboardRunConfigurationNode;
import com.intellij.execution.dashboard.actions.RunDashboardActionUtils;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.content.Content;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class RemoveConfigurationAction
extends AnAction {
    public void update(@NotNull AnActionEvent e) {
        boolean enabled;
        Project project;
        if (e == null) {
            RemoveConfigurationAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null || !RunDashboardManager.getInstance((Project)project).isShowConfigurations() || Registry.is((String)"ide.service.view")) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        JBIterable<RunDashboardRunConfigurationNode> targets2 = RunDashboardActionUtils.getTargets(e);
        RunManager runManager = RunManager.getInstance((Project)project);
        boolean bl = enabled = targets2.isNotEmpty() && targets2.filter(node -> !runManager.hasSettings(node.getConfigurationSettings())).isEmpty();
        if (enabled) {
            JComponent contentComponent;
            RunDashboardRunConfigurationNode node2 = (RunDashboardRunConfigurationNode)targets2.single();
            Content content2 = node2 == null ? null : node2.getContent();
            JComponent jComponent = contentComponent = content2 == null ? null : content2.getComponent();
            if (contentComponent != null && "MainMenu".equals(e.getPlace()) && UIUtil.isAncestor((Component)content2.getComponent(), (Component)((Component)e.getData(PlatformDataKeys.CONTEXT_COMPONENT)))) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
        }
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(targets2.isNotEmpty());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            RemoveConfigurationAction.$$$reportNull$$$0(1);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        JBIterable<RunDashboardRunConfigurationNode> nodes = RunDashboardActionUtils.getTargets(e);
        if (nodes.isEmpty()) {
            return;
        }
        int size = nodes.size();
        if (Messages.showYesNoDialog((Project)project, (String)("Delete " + size + " " + StringUtil.pluralize((String)"configuration", (int)size) + "?"), (String)ExecutionBundle.message((String)"run.dashboard.remove.configuration.dialog.title", (Object[])new Object[0]), (Icon)Messages.getWarningIcon()) != 0) {
            return;
        }
        RunManager runManager = RunManager.getInstance((Project)project);
        for (RunDashboardRunConfigurationNode node : nodes) {
            runManager.removeConfiguration(node.getConfigurationSettings());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/execution/dashboard/actions/RemoveConfigurationAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

