/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.lineMarker;

import com.intellij.execution.TestStateStorage;
import com.intellij.execution.lineMarker.ExecutorAction;
import com.intellij.execution.testframework.TestIconMapper;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.TextWithMnemonic;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RunLineMarkerContributor {
    public static final java.util.function.Function<PsiElement, String> RUN_TEST_TOOLTIP_PROVIDER = it -> "Run Test";
    static final LanguageExtension<RunLineMarkerContributor> EXTENSION = new LanguageExtension("com.intellij.runLineMarkerContributor");

    @NotNull
    public static Info withExecutorActions(@NotNull Icon icon) {
        if (icon == null) {
            RunLineMarkerContributor.$$$reportNull$$$0(0);
        }
        Info info = new Info(icon, ExecutorAction.getActions(1), RUN_TEST_TOOLTIP_PROVIDER);
        if (info == null) {
            RunLineMarkerContributor.$$$reportNull$$$0(1);
        }
        return info;
    }

    @Nullable
    public abstract Info getInfo(@NotNull PsiElement var1);

    @Nullable(value="null means disabled")
    protected static String getText(@NotNull AnAction action2, @NotNull PsiElement element) {
        if (action2 == null) {
            RunLineMarkerContributor.$$$reportNull$$$0(2);
        }
        if (element == null) {
            RunLineMarkerContributor.$$$reportNull$$$0(3);
        }
        DataContext parent = DataManager.getInstance().getDataContext();
        DataContext dataContext = SimpleDataContext.getSimpleContext(CommonDataKeys.PSI_ELEMENT.getName(), element, parent);
        if (!(action2 instanceof ExecutorAction)) {
            return null;
        }
        AnActionEvent event = AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)dataContext);
        action2.update(event);
        if (!event.getPresentation().isEnabledAndVisible()) {
            return null;
        }
        String name = ((ExecutorAction)action2).getActionName(dataContext);
        return name == null ? null : TextWithMnemonic.parse((String)name).getText();
    }

    @NotNull
    protected static Icon getTestStateIcon(String url, @NotNull Project project, boolean isClass) {
        if (project == null) {
            RunLineMarkerContributor.$$$reportNull$$$0(4);
        }
        Icon icon = RunLineMarkerContributor.getTestStateIcon(TestStateStorage.getInstance(project).getState(url), isClass);
        if (icon == null) {
            RunLineMarkerContributor.$$$reportNull$$$0(5);
        }
        return icon;
    }

    @NotNull
    protected static Icon getTestStateIcon(@Nullable TestStateStorage.Record state, boolean isClass) {
        TestStateInfo.Magnitude magnitude;
        if (state != null && (magnitude = TestIconMapper.getMagnitude((int)state.magnitude)) != null) {
            switch (magnitude) {
                case ERROR_INDEX: 
                case FAILED_INDEX: {
                    Icon icon = AllIcons.RunConfigurations.TestState.Red2;
                    if (icon == null) {
                        RunLineMarkerContributor.$$$reportNull$$$0(6);
                    }
                    return icon;
                }
                case PASSED_INDEX: 
                case COMPLETE_INDEX: {
                    Icon icon = AllIcons.RunConfigurations.TestState.Green2;
                    if (icon == null) {
                        RunLineMarkerContributor.$$$reportNull$$$0(7);
                    }
                    return icon;
                }
            }
        }
        Icon icon = isClass ? AllIcons.RunConfigurations.TestState.Run_run : AllIcons.RunConfigurations.TestState.Run;
        if (icon == null) {
            RunLineMarkerContributor.$$$reportNull$$$0(8);
        }
        return icon;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/lineMarker/RunLineMarkerContributor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/lineMarker/RunLineMarkerContributor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "withExecutorActions";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestStateIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "withExecutorActions";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTestStateIcon";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Info {
        public final Icon icon;
        public final AnAction[] actions;
        public final java.util.function.Function<PsiElement, String> tooltipProvider;

        public Info(Icon icon, @NotNull AnAction[] actions, @Nullable java.util.function.Function<PsiElement, String> tooltipProvider) {
            if (actions == null) {
                Info.$$$reportNull$$$0(0);
            }
            this.icon = icon;
            this.actions = actions;
            this.tooltipProvider = tooltipProvider;
        }

        public Info(Icon icon, @Nullable Function<PsiElement, String> tooltipProvider, AnAction ... actions) {
            if (actions == null) {
                Info.$$$reportNull$$$0(1);
            }
            this.icon = icon;
            this.actions = actions;
            this.tooltipProvider = tooltipProvider == null ? null : it -> (String)tooltipProvider.fun(it);
        }

        public Info(@NotNull AnAction action2) {
            if (action2 == null) {
                Info.$$$reportNull$$$0(2);
            }
            this(action2.getTemplatePresentation().getIcon(), new AnAction[]{action2}, (PsiElement element) -> RunLineMarkerContributor.getText(action2, element));
        }

        public boolean shouldReplace(@NotNull Info other) {
            if (other == null) {
                Info.$$$reportNull$$$0(3);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actions";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/lineMarker/RunLineMarkerContributor$Info";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "shouldReplace";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

