/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.process.RunnerWinProcess;
import com.intellij.execution.process.UnixProcessManager;
import com.intellij.execution.process.WinProcessManager;
import com.intellij.execution.process.impl.ProcessListUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.pty4j.windows.WinPtyProcess;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jvnet.winp.WinProcess;

public class OSProcessUtil {
    private static final Logger LOG = Logger.getInstance(OSProcessUtil.class);
    private static String ourPid;

    @NotNull
    public static ProcessInfo[] getProcessList() {
        ProcessInfo[] processInfoArray = ProcessListUtil.getProcessList();
        if (processInfoArray == null) {
            OSProcessUtil.$$$reportNull$$$0(0);
        }
        return processInfoArray;
    }

    public static boolean killProcessTree(@NotNull Process process2) {
        if (process2 == null) {
            OSProcessUtil.$$$reportNull$$$0(1);
        }
        if (SystemInfo.isWindows) {
            try {
                if (process2 instanceof WinPtyProcess) {
                    int pid = ((WinPtyProcess)process2).getChildProcessId();
                    if (pid == -1) {
                        return true;
                    }
                    boolean res2 = WinProcessManager.kill((int)pid, (boolean)true);
                    process2.destroy();
                    return res2;
                }
                if (Registry.is((String)"disable.winp")) {
                    return WinProcessManager.kill((Process)process2, (boolean)true);
                }
                if (!process2.isAlive()) {
                    OSProcessUtil.logSkippedActionWithTerminatedProcess(process2, "killProcessTree", null);
                    return true;
                }
                OSProcessUtil.createWinProcess(process2).killRecursively();
                return true;
            }
            catch (Throwable e) {
                LOG.info("Cannot kill process tree", e);
            }
        } else if (SystemInfo.isUnix) {
            return UnixProcessManager.sendSigKillToProcessTree((Process)process2);
        }
        return false;
    }

    public static void killProcess(@NotNull Process process2) {
        if (process2 == null) {
            OSProcessUtil.$$$reportNull$$$0(2);
        }
        OSProcessUtil.killProcess(OSProcessUtil.getProcessID(process2));
    }

    public static void killProcess(int pid) {
        if (SystemInfo.isWindows) {
            try {
                if (!Registry.is((String)"disable.winp")) {
                    try {
                        OSProcessUtil.createWinProcess(pid).kill();
                        return;
                    }
                    catch (Throwable e) {
                        LOG.error("Failed to kill process with winp, fallback to default logic", e);
                    }
                }
                WinProcessManager.kill((int)pid, (boolean)false);
            }
            catch (Throwable e) {
                LOG.info("Cannot kill process", e);
            }
        } else if (SystemInfo.isUnix) {
            UnixProcessManager.sendSignal((int)pid, (int)UnixProcessManager.SIGKILL);
        }
    }

    static void logSkippedActionWithTerminatedProcess(@NotNull Process process2, @NotNull String actionName, @Nullable String commandLine) {
        if (process2 == null) {
            OSProcessUtil.$$$reportNull$$$0(3);
        }
        if (actionName == null) {
            OSProcessUtil.$$$reportNull$$$0(4);
        }
        Integer pid = null;
        try {
            pid = OSProcessUtil.getProcessID(process2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        LOG.info("Cannot " + actionName + " already terminated process (pid: " + pid + ", command: " + commandLine + ")");
    }

    public static int getProcessID(@NotNull Process process2) {
        if (process2 == null) {
            OSProcessUtil.$$$reportNull$$$0(5);
        }
        if (SystemInfo.isWindows) {
            try {
                if (process2 instanceof WinPtyProcess) {
                    return ((WinPtyProcess)process2).getChildProcessId();
                }
                if (!Registry.is((String)"disable.winp")) {
                    try {
                        return OSProcessUtil.createWinProcess(process2).getPid();
                    }
                    catch (Throwable e) {
                        LOG.error("Failed to get PID with winp, fallback to default logic", e);
                    }
                }
                return WinProcessManager.getProcessId((Process)process2);
            }
            catch (Throwable e) {
                throw new IllegalStateException("Cannot get PID from instance of " + process2.getClass() + ", OS: " + SystemInfo.OS_NAME, e);
            }
        }
        if (SystemInfo.isUnix) {
            return UnixProcessManager.getProcessId((Process)process2);
        }
        throw new IllegalStateException("Unknown OS: " + SystemInfo.OS_NAME);
    }

    @NotNull
    static WinProcess createWinProcess(@NotNull Process process2) {
        if (process2 == null) {
            OSProcessUtil.$$$reportNull$$$0(6);
        }
        if (process2 instanceof RunnerWinProcess) {
            process2 = ((RunnerWinProcess)process2).getOriginalProcess();
        }
        if (process2 instanceof WinPtyProcess) {
            WinProcess winProcess = new WinProcess(((WinPtyProcess)process2).getPid());
            if (winProcess == null) {
                OSProcessUtil.$$$reportNull$$$0(7);
            }
            return winProcess;
        }
        WinProcess winProcess = new WinProcess(process2);
        if (winProcess == null) {
            OSProcessUtil.$$$reportNull$$$0(8);
        }
        return winProcess;
    }

    @NotNull
    private static WinProcess createWinProcess(int pid) {
        WinProcess winProcess = new WinProcess(pid);
        if (winProcess == null) {
            OSProcessUtil.$$$reportNull$$$0(9);
        }
        return winProcess;
    }

    public static int getCurrentProcessId() {
        int pid = SystemInfo.isWindows ? WinProcessManager.getCurrentProcessId() : UnixProcessManager.getCurrentProcessId();
        return pid;
    }

    public static String getApplicationPid() {
        if (ourPid == null) {
            ourPid = String.valueOf(OSProcessUtil.getCurrentProcessId());
        }
        return ourPid;
    }

    @Deprecated
    public static List<String> getCommandLinesOfRunningProcesses() {
        ArrayList<String> result2 = new ArrayList<String>();
        for (ProcessInfo each : OSProcessUtil.getProcessList()) {
            result2.add(each.getCommandLine());
        }
        return Collections.unmodifiableList(result2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/process/OSProcessUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessList";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/process/OSProcessUtil";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createWinProcess";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "killProcessTree";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "killProcess";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "logSkippedActionWithTerminatedProcess";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getProcessID";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createWinProcess";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

