/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.services;

import com.intellij.execution.services.ServiceModel;
import com.intellij.execution.services.ServiceView;
import com.intellij.execution.services.ServiceViewContributor;
import com.intellij.execution.services.ServiceViewDescriptor;
import com.intellij.execution.services.ServiceViewDragHelper;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.ui.PopupHandler;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.tree.TreeModelAdapter;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ServiceViewActionProvider {
    @NonNls
    private static final String SERVICE_VIEW_ITEM_TOOLBAR = "ServiceViewItemToolbar";
    @NonNls
    static final String SERVICE_VIEW_ITEM_POPUP = "ServiceViewItemPopup";
    @NonNls
    private static final String SERVICE_VIEW_TREE_TOOLBAR = "ServiceViewTreeToolbar";
    private static final ServiceViewActionProvider ourInstance = new ServiceViewActionProvider();

    ServiceViewActionProvider() {
    }

    static ServiceViewActionProvider getInstance() {
        return ourInstance;
    }

    ActionToolbar createServiceToolbar(@NotNull JComponent component) {
        if (component == null) {
            ServiceViewActionProvider.$$$reportNull$$$0(0);
        }
        ActionGroup actions = (ActionGroup)ActionManager.getInstance().getAction(SERVICE_VIEW_ITEM_TOOLBAR);
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("ServicesToolbar", actions, false);
        toolbar.setTargetComponent(component);
        return toolbar;
    }

    void installPopupHandler(@NotNull JComponent component) {
        if (component == null) {
            ServiceViewActionProvider.$$$reportNull$$$0(1);
        }
        ActionGroup actions = (ActionGroup)ActionManager.getInstance().getAction(SERVICE_VIEW_ITEM_POPUP);
        PopupHandler.installPopupHandler((JComponent)component, (ActionGroup)actions, (String)"ServicesPopup", (ActionManager)ActionManager.getInstance());
    }

    ActionToolbar createMasterComponentToolbar(@NotNull JComponent component) {
        if (component == null) {
            ServiceViewActionProvider.$$$reportNull$$$0(2);
        }
        DefaultActionGroup group = new DefaultActionGroup();
        if (component instanceof JTree) {
            ServiceViewTreeExpander treeExpander = new ServiceViewTreeExpander((JTree)component);
            AnAction expandAllAction = CommonActionsManager.getInstance().createExpandAllAction((TreeExpander)treeExpander, component);
            group.add(expandAllAction);
            AnAction collapseAllAction = CommonActionsManager.getInstance().createCollapseAllAction((TreeExpander)treeExpander, component);
            group.add(collapseAllAction);
            group.addSeparator();
        }
        group.addSeparator();
        AnAction treeActions = ActionManager.getInstance().getAction(SERVICE_VIEW_TREE_TOOLBAR);
        treeActions.registerCustomShortcutSet(component, null);
        group.add(treeActions);
        ActionToolbar treeActionsToolBar = ActionManager.getInstance().createActionToolbar("ServicesToolbar", (ActionGroup)group, true);
        treeActionsToolBar.setTargetComponent(component);
        return treeActionsToolBar;
    }

    List<AnAction> getAdditionalGearActions() {
        AnAction showServicesActions = ActionManager.getInstance().getAction("ServiceView.ShowServices");
        return showServicesActions == null ? Collections.emptyList() : Collections.singletonList(showServicesActions);
    }

    @Nullable
    static ServiceView getSelectedView(@NotNull AnActionEvent e) {
        if (e == null) {
            ServiceViewActionProvider.$$$reportNull$$$0(3);
        }
        return ServiceViewActionProvider.getSelectedView((Component)e.getData(PlatformDataKeys.CONTEXT_COMPONENT));
    }

    @Nullable
    static ServiceView getSelectedView(@NotNull DataProvider provider) {
        if (provider == null) {
            ServiceViewActionProvider.$$$reportNull$$$0(4);
        }
        return ServiceViewActionProvider.getSelectedView((Component)ObjectUtils.tryCast((Object)provider.getData(PlatformDataKeys.CONTEXT_COMPONENT.getName()), Component.class));
    }

    @Nullable
    private static ServiceView getSelectedView(@Nullable Component contextComponent) {
        while (contextComponent != null && !(contextComponent instanceof ServiceView)) {
            contextComponent = contextComponent.getParent();
        }
        return (ServiceView)contextComponent;
    }

    @NotNull
    private static AnAction[] doGetActions(@Nullable AnActionEvent e, boolean toolbar) {
        ServiceViewDescriptor descriptor2;
        if (e == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                ServiceViewActionProvider.$$$reportNull$$$0(5);
            }
            return AnAction.EMPTY_ARRAY;
        }
        Project project = e.getProject();
        if (project == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                ServiceViewActionProvider.$$$reportNull$$$0(6);
            }
            return AnAction.EMPTY_ARRAY;
        }
        ServiceView serviceView = ServiceViewActionProvider.getSelectedView(e);
        if (serviceView == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                ServiceViewActionProvider.$$$reportNull$$$0(7);
            }
            return AnAction.EMPTY_ARRAY;
        }
        List<ServiceModel.ServiceViewItem> selectedItems = serviceView.getSelectedItems();
        if (selectedItems.isEmpty()) {
            if (AnAction.EMPTY_ARRAY == null) {
                ServiceViewActionProvider.$$$reportNull$$$0(8);
            }
            return AnAction.EMPTY_ARRAY;
        }
        if (selectedItems.size() == 1) {
            descriptor2 = selectedItems.get(0).getViewDescriptor();
        } else {
            ServiceViewContributor contributor = ServiceViewDragHelper.getTheOnlyRootContributor(selectedItems);
            ServiceViewDescriptor serviceViewDescriptor = descriptor2 = contributor == null ? null : contributor.getViewDescriptor();
        }
        if (descriptor2 == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                ServiceViewActionProvider.$$$reportNull$$$0(9);
            }
            return AnAction.EMPTY_ARRAY;
        }
        ActionGroup group = toolbar ? descriptor2.getToolbarActions() : descriptor2.getPopupActions();
        AnAction[] anActionArray = group == null ? AnAction.EMPTY_ARRAY : group.getChildren(e);
        if (anActionArray == null) {
            ServiceViewActionProvider.$$$reportNull$$$0(10);
        }
        return anActionArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/services/ServiceViewActionProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/services/ServiceViewActionProvider";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createServiceToolbar";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "installPopupHandler";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createMasterComponentToolbar";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedView";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ItemPopupActionGroup
    extends ActionGroup {
        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            AnAction[] anActionArray = ServiceViewActionProvider.doGetActions(e, false);
            if (anActionArray == null) {
                ItemPopupActionGroup.$$$reportNull$$$0(0);
            }
            return anActionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/services/ServiceViewActionProvider$ItemPopupActionGroup", "getChildren"));
        }
    }

    public static class ItemToolbarActionGroup
    extends ActionGroup {
        private static final AnAction[] FAKE_GROUP = new AnAction[]{new DumbAwareAction(null, null, EmptyIcon.ICON_16){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                e.getPresentation().setEnabled(false);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/execution/services/ServiceViewActionProvider$ItemToolbarActionGroup$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }};

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            AnAction[] actions = ServiceViewActionProvider.doGetActions(e, true);
            AnAction[] anActionArray = actions.length != 0 ? actions : FAKE_GROUP;
            if (anActionArray == null) {
                ItemToolbarActionGroup.$$$reportNull$$$0(0);
            }
            return anActionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/services/ServiceViewActionProvider$ItemToolbarActionGroup", "getChildren"));
        }
    }

    private static class ServiceViewTreeExpander
    extends DefaultTreeExpander {
        private final TreeModel myTreeModel;
        private boolean myFlat;

        ServiceViewTreeExpander(JTree tree) {
            super(tree);
            this.myTreeModel = tree.getModel();
            this.myTreeModel.addTreeModelListener((TreeModelListener)new TreeModelAdapter(){

                protected void process(@NotNull TreeModelEvent event, @NotNull TreeModelAdapter.EventType type) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (type == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    myFlat = this.isFlat();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "type";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/execution/services/ServiceViewActionProvider$ServiceViewTreeExpander$1";
                    objectArray[2] = "process";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }

        public boolean canExpand() {
            return super.canExpand() && !this.myFlat;
        }

        public boolean canCollapse() {
            return super.canCollapse() && !this.myFlat;
        }

        private boolean isFlat() {
            Object root = this.myTreeModel.getRoot();
            if (root == null) {
                return false;
            }
            int childCount = this.myTreeModel.getChildCount(root);
            for (int i = 0; i < childCount; ++i) {
                Object child2 = this.myTreeModel.getChild(root, i);
                if (this.myTreeModel.isLeaf(child2)) continue;
                return false;
            }
            return true;
        }
    }
}

