/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.wsl;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WSLUtil;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@Tag(value="descriptor")
final class WslDistributionDescriptor {
    @Tag(value="id")
    private String myId;
    @Tag(value="microsoft-id")
    private String myMsId;
    @Tag(value="executable-path")
    private String myExecutablePath;
    @Tag(value="presentable-name")
    private String myPresentableName;
    private final AtomicNotNullLazyValue<String> myMntRootProvider;

    WslDistributionDescriptor() {
        this.myMntRootProvider = AtomicNotNullLazyValue.createValue(this::computeMntRoot);
    }

    WslDistributionDescriptor(@NotNull String id, @NotNull String msId, @NotNull String executablePath, @NotNull String presentableName) {
        if (id == null) {
            WslDistributionDescriptor.$$$reportNull$$$0(0);
        }
        if (msId == null) {
            WslDistributionDescriptor.$$$reportNull$$$0(1);
        }
        if (executablePath == null) {
            WslDistributionDescriptor.$$$reportNull$$$0(2);
        }
        if (presentableName == null) {
            WslDistributionDescriptor.$$$reportNull$$$0(3);
        }
        this.myMntRootProvider = AtomicNotNullLazyValue.createValue(this::computeMntRoot);
        this.myId = id;
        this.myMsId = msId;
        this.myExecutablePath = executablePath;
        this.myPresentableName = presentableName;
    }

    @NotNull
    public String getId() {
        String string = Objects.requireNonNull(this.myId);
        if (string == null) {
            WslDistributionDescriptor.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getMsId() {
        String string = Objects.requireNonNull(this.myMsId);
        if (string == null) {
            WslDistributionDescriptor.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getExecutablePath() {
        String string = Objects.requireNonNull(this.myExecutablePath);
        if (string == null) {
            WslDistributionDescriptor.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getPresentableName() {
        String string = Objects.requireNonNull(this.myPresentableName);
        if (string == null) {
            WslDistributionDescriptor.$$$reportNull$$$0(7);
        }
        return string;
    }

    boolean isValid() {
        return StringUtil.isNotEmpty((String)this.myId) && StringUtil.isNotEmpty((String)this.myMsId) && StringUtil.isNotEmpty((String)this.myExecutablePath) && StringUtil.isNotEmpty((String)this.myPresentableName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WslDistributionDescriptor that = (WslDistributionDescriptor)o;
        return Objects.equals(this.getId(), that.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return "WslDistributionDescriptor{id='" + this.myId + '\'' + ", msId='" + this.myMsId + '\'' + '}';
    }

    @NotNull
    final String getMntRoot() {
        String string = (String)this.myMntRootProvider.getValue();
        if (string == null) {
            WslDistributionDescriptor.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    private String computeMntRoot() {
        String currentPathSuffix;
        ProcessOutput pwdOutput;
        String windowsCurrentDirectory = System.getProperty("user.dir");
        if (StringUtil.isEmpty((String)windowsCurrentDirectory) || windowsCurrentDirectory.length() < 3) {
            WSLUtil.LOG.warn("Could not obtain current directory from user.dir (or path is too short): " + windowsCurrentDirectory);
            if ("/mnt/" == null) {
                WslDistributionDescriptor.$$$reportNull$$$0(9);
            }
            return "/mnt/";
        }
        WSLDistribution distribution = WSLUtil.getDistributionById(this.getId());
        if (distribution == null) {
            if ("/mnt/" == null) {
                WslDistributionDescriptor.$$$reportNull$$$0(10);
            }
            return "/mnt/";
        }
        try {
            pwdOutput = distribution.executeOnWsl(-1, "pwd");
        }
        catch (ExecutionException e) {
            WSLUtil.LOG.warn("Error reading pwd output for " + this.getId(), (Throwable)e);
            if ("/mnt/" == null) {
                WslDistributionDescriptor.$$$reportNull$$$0(11);
            }
            return "/mnt/";
        }
        if (pwdOutput.getExitCode() != 0) {
            WSLUtil.LOG.info("Non-zero exit code while fetching pwd: [id=" + this.getId() + "; [exitCode=" + pwdOutput.getExitCode() + "; [stderr=" + pwdOutput.getStderr() + "; [stdout=" + pwdOutput.getStdout() + "]");
            if ("/mnt/" == null) {
                WslDistributionDescriptor.$$$reportNull$$$0(12);
            }
            return "/mnt/";
        }
        List pwdOutputLines = pwdOutput.getStdoutLines();
        if (pwdOutputLines.size() != 1) {
            WSLUtil.LOG.warn("One line response expected from `pwd`: [id=" + this.getId() + "; exitCode=" + pwdOutput.getExitCode() + "; stderr=" + pwdOutput.getStderr() + "; stdout=" + pwdOutput.getStdout() + "]");
            if ("/mnt/" == null) {
                WslDistributionDescriptor.$$$reportNull$$$0(13);
            }
            return "/mnt/";
        }
        String wslCurrentDirectory = ((String)pwdOutputLines.get(0)).trim();
        if (StringUtil.endsWithIgnoreCase((String)wslCurrentDirectory, (String)(currentPathSuffix = WSLDistribution.convertWindowsPath(windowsCurrentDirectory)))) {
            String string = StringUtil.trimEnd((String)wslCurrentDirectory, (String)currentPathSuffix, (boolean)true);
            if (string == null) {
                WslDistributionDescriptor.$$$reportNull$$$0(14);
            }
            return string;
        }
        WSLUtil.LOG.warn("Wsl current directory does not ends with windows converted suffix: [pwd=" + wslCurrentDirectory + "; suffix=" + currentPathSuffix + "]");
        if ("/mnt/" == null) {
            WslDistributionDescriptor.$$$reportNull$$$0(15);
        }
        return "/mnt/";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executablePath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentableName";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/wsl/WslDistributionDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/wsl/WslDistributionDescriptor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMsId";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutablePath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getMntRoot";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "computeMntRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

