/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import org.jetbrains.annotations.NotNull;

public class IndentInfo {
    private final int mySpaces;
    private final int myIndentSpaces;
    private final int myLineFeeds;
    private final boolean myForceSkipTabulationsUsage;
    private boolean myIndentEmptyLines;

    public IndentInfo(int lineFeeds, int indentSpaces, int spaces) {
        this(lineFeeds, indentSpaces, spaces, false);
    }

    public IndentInfo(int lineFeeds, int indentSpaces, int spaces, boolean forceSkipTabulationsUsage) {
        this.mySpaces = spaces;
        this.myIndentSpaces = indentSpaces;
        this.myLineFeeds = lineFeeds;
        this.myForceSkipTabulationsUsage = forceSkipTabulationsUsage;
    }

    public int getSpaces() {
        return this.mySpaces;
    }

    public int getIndentSpaces() {
        return this.myIndentSpaces;
    }

    @NotNull
    public String generateNewWhiteSpace(@NotNull CommonCodeStyleSettings.IndentOptions options) {
        if (options == null) {
            IndentInfo.$$$reportNull$$$0(0);
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.myLineFeeds; ++i) {
            if (options.KEEP_INDENTS_ON_EMPTY_LINES && i > 0) {
                int spaces = this.myIndentEmptyLines ? this.myIndentSpaces + options.INDENT_SIZE : this.myIndentSpaces;
                IndentInfo.generateLineWhitespace(buffer, options, spaces, 0, true);
            }
            buffer.append('\n');
        }
        IndentInfo.generateLineWhitespace(buffer, options, this.myIndentSpaces, this.mySpaces, !this.myForceSkipTabulationsUsage || this.myLineFeeds > 0);
        String string = buffer.toString();
        if (string == null) {
            IndentInfo.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static void generateLineWhitespace(@NotNull StringBuffer buffer, @NotNull CommonCodeStyleSettings.IndentOptions options, int indentSpaces, int alignmentSpaces, boolean tabsAllowed) {
        if (buffer == null) {
            IndentInfo.$$$reportNull$$$0(2);
        }
        if (options == null) {
            IndentInfo.$$$reportNull$$$0(3);
        }
        if (options.USE_TAB_CHARACTER && tabsAllowed) {
            if (options.SMART_TABS) {
                int tabCount = indentSpaces / options.TAB_SIZE;
                int leftSpaces = indentSpaces - tabCount * options.TAB_SIZE;
                StringUtil.repeatSymbol((Appendable)buffer, (char)'\t', (int)tabCount);
                StringUtil.repeatSymbol((Appendable)buffer, (char)' ', (int)(leftSpaces + alignmentSpaces));
            } else {
                int size = indentSpaces + alignmentSpaces;
                int tabs = size / options.TAB_SIZE;
                int spaces = size % options.TAB_SIZE;
                StringUtil.repeatSymbol((Appendable)buffer, (char)'\t', (int)tabs);
                StringUtil.repeatSymbol((Appendable)buffer, (char)' ', (int)spaces);
            }
        } else {
            int spaces = indentSpaces + alignmentSpaces;
            StringUtil.repeatSymbol((Appendable)buffer, (char)' ', (int)spaces);
        }
    }

    @NotNull
    IndentInfo setIndentEmptyLines(boolean indentEmptyLines) {
        this.myIndentEmptyLines = indentEmptyLines;
        IndentInfo indentInfo = this;
        if (indentInfo == null) {
            IndentInfo.$$$reportNull$$$0(4);
        }
        return indentInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/formatting/IndentInfo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/formatting/IndentInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "generateNewWhiteSpace";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "setIndentEmptyLines";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generateNewWhiteSpace";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "generateLineWhitespace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

