/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.newclass;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Trinity;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Consumer;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateWithTemplatesDialogPanel
extends JBPanel
implements Disposable {
    private final ExtendableTextField myNameField;
    private final JList<Trinity<String, Icon, String>> myTemplatesList;
    private JBPopup myErrorPopup;
    private RelativePoint myErrorShowPoint;
    private Consumer<? super InputEvent> myApplyAction;
    private static final ListCellRenderer<Trinity<String, Icon, String>> LIST_RENDERER = new ListCellRenderer<Trinity<String, Icon, String>>(){
        private final ListCellRenderer<Trinity<String, Icon, String>> delegateRenderer = SimpleListCellRenderer.create((label2, value, index) -> {
            if (value != null) {
                label2.setText((String)value.first);
                label2.setIcon((Icon)value.second);
            }
        });

        @Override
        public Component getListCellRendererComponent(JList<? extends Trinity<String, Icon, String>> list2, Trinity<String, Icon, String> value, int index, boolean isSelected, boolean cellHasFocus) {
            JComponent delegate = (JComponent)this.delegateRenderer.getListCellRendererComponent(list2, value, index, isSelected, cellHasFocus);
            delegate.setBorder((Border)JBUI.Borders.empty((int)JBUIScale.scale((int)3), (int)JBUIScale.scale((int)1)));
            return delegate;
        }
    };

    public CreateWithTemplatesDialogPanel(@NotNull List<Trinity<String, Icon, String>> templates, @Nullable String selectedItem) {
        if (templates == null) {
            CreateWithTemplatesDialogPanel.$$$reportNull$$$0(0);
        }
        super((LayoutManager)new BorderLayout());
        this.setBackground(JBUI.CurrentTheme.NewClassDialog.panelBackground());
        this.myNameField = this.createNameField();
        this.myTemplatesList = this.createTemplatesList(templates);
        this.myErrorShowPoint = new RelativePoint((Component)this.myNameField, new Point(0, this.myNameField.getHeight()));
        ScrollingUtil.installMoveUpAction(this.myTemplatesList, (JComponent)this.myNameField);
        ScrollingUtil.installMoveDownAction(this.myTemplatesList, (JComponent)this.myNameField);
        this.selectTemplate(selectedItem);
        this.add((Component)this.myNameField, "North");
        if (templates.size() > 1) {
            JBScrollPane scrollPane = new JBScrollPane(this.myTemplatesList);
            scrollPane.setBorder((Border)JBUI.Borders.empty());
            scrollPane.setHorizontalScrollBarPolicy(31);
            Box listHolder = new Box(1);
            listHolder.setBorder((Border)JBUI.Borders.emptyTop((int)JBUI.CurrentTheme.NewClassDialog.fieldsSeparatorWidth()));
            listHolder.add((Component)scrollPane);
            this.add(listHolder, "Center");
        }
    }

    public JTextField getNameField() {
        return this.myNameField;
    }

    @NotNull
    public String getEnteredName() {
        String string = this.myNameField.getText().trim();
        if (string == null) {
            CreateWithTemplatesDialogPanel.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getSelectedTemplate() {
        String string = (String)this.myTemplatesList.getSelectedValue().third;
        if (string == null) {
            CreateWithTemplatesDialogPanel.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void setError(String error) {
        this.myNameField.putClientProperty((Object)"JComponent.outline", (Object)(error != null ? "error" : null));
        if (this.myErrorPopup != null && !this.myErrorPopup.isDisposed()) {
            Disposer.dispose((Disposable)this.myErrorPopup);
        }
        if (error == null) {
            return;
        }
        ComponentPopupBuilder popupBuilder = ComponentValidator.createPopupBuilder((ValidationInfo)new ValidationInfo(error, (JComponent)this.myNameField), errorHint -> {
            Insets insets = this.myNameField.getInsets();
            Dimension hintSize = errorHint.getPreferredSize();
            Point point = new Point(0, insets.top - JBUIScale.scale((int)6) - hintSize.height);
            this.myErrorShowPoint = new RelativePoint((Component)this.myNameField, point);
        }).setCancelOnWindowDeactivation(false).setCancelOnClickOutside(true).addUserData((Object)"SIMPLE_WINDOW");
        this.myErrorPopup = popupBuilder.createPopup();
        this.myErrorPopup.show(this.myErrorShowPoint);
    }

    public void setApplyAction(@NotNull Consumer<? super InputEvent> applyAction) {
        if (applyAction == null) {
            CreateWithTemplatesDialogPanel.$$$reportNull$$$0(3);
        }
        this.myApplyAction = applyAction;
    }

    public void dispose() {
        if (this.myErrorPopup != null && !this.myErrorPopup.isDisposed()) {
            Disposer.dispose((Disposable)this.myErrorPopup);
        }
    }

    @NotNull
    private ExtendableTextField createNameField() {
        ExtendableTextField res2 = new ExtendableTextField();
        Dimension minSize = res2.getMinimumSize();
        Dimension prefSize = res2.getPreferredSize();
        minSize.height = JBUIScale.scale((int)28);
        prefSize.height = JBUIScale.scale((int)28);
        res2.setMinimumSize(minSize);
        res2.setPreferredSize(prefSize);
        res2.setColumns(30);
        Border border = JBUI.Borders.customLine((Color)JBUI.CurrentTheme.NewClassDialog.bordersColor(), (int)1, (int)0, (int)1, (int)0);
        ErrorBorder errorBorder = new ErrorBorder(res2.getBorder());
        res2.setBorder(JBUI.Borders.merge((Border)border, (Border)errorBorder, (boolean)false));
        res2.setBackground(JBUI.CurrentTheme.NewClassDialog.searchFieldBackground());
        res2.putClientProperty((Object)"StatusVisibleFunction", field -> field.getText().isEmpty());
        res2.getEmptyText().setText(IdeBundle.message((String)"action.create.new.class.name.field", (Object[])new Object[0]));
        res2.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && CreateWithTemplatesDialogPanel.this.myApplyAction != null) {
                    CreateWithTemplatesDialogPanel.this.myApplyAction.consume((Object)e);
                }
            }
        });
        res2.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                CreateWithTemplatesDialogPanel.this.setError(null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/newclass/CreateWithTemplatesDialogPanel$2", "textChanged"));
            }
        });
        ExtendableTextField extendableTextField = res2;
        if (extendableTextField == null) {
            CreateWithTemplatesDialogPanel.$$$reportNull$$$0(4);
        }
        return extendableTextField;
    }

    @NotNull
    private JBList<Trinity<String, Icon, String>> createTemplatesList(@NotNull List<Trinity<String, Icon, String>> templates) {
        if (templates == null) {
            CreateWithTemplatesDialogPanel.$$$reportNull$$$0(5);
        }
        JBList list2 = new JBList(templates);
        MouseAdapter mouseListener2 = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (CreateWithTemplatesDialogPanel.this.myApplyAction != null && e.getClickCount() > 1) {
                    CreateWithTemplatesDialogPanel.this.myApplyAction.consume((Object)e);
                }
            }
        };
        list2.addMouseListener((MouseListener)mouseListener2);
        list2.setCellRenderer(LIST_RENDERER);
        list2.setFocusable(false);
        list2.setSelectionMode(0);
        list2.addListSelectionListener(e -> {
            Trinity selectedValue = (Trinity)list2.getSelectedValue();
            if (selectedValue != null) {
                this.setTextFieldIcon((Icon)selectedValue.second);
            }
        });
        Border border = JBUI.Borders.merge((Border)JBUI.Borders.emptyLeft((int)JBUIScale.scale((int)5)), (Border)JBUI.Borders.customLine((Color)JBUI.CurrentTheme.NewClassDialog.bordersColor(), (int)1, (int)0, (int)0, (int)0), (boolean)true);
        list2.setBorder(border);
        JBList jBList = list2;
        if (jBList == null) {
            CreateWithTemplatesDialogPanel.$$$reportNull$$$0(6);
        }
        return jBList;
    }

    private void setTextFieldIcon(Icon icon) {
        this.myNameField.setExtensions(new ExtendableTextComponent.Extension[]{new TemplateIconExtension(icon)});
        this.myNameField.repaint();
    }

    private void selectTemplate(@Nullable String selectedItem) {
        if (selectedItem == null) {
            this.myTemplatesList.setSelectedIndex(0);
            return;
        }
        ListModel<Trinity<String, Icon, String>> model2 = this.myTemplatesList.getModel();
        for (int i = 0; i < model2.getSize(); ++i) {
            String templateID = (String)model2.getElementAt(i).getThird();
            if (!selectedItem.equals(templateID)) continue;
            this.myTemplatesList.setSelectedIndex(i);
            return;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templates";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/newclass/CreateWithTemplatesDialogPanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applyAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/newclass/CreateWithTemplatesDialogPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnteredName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedTemplate";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createNameField";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createTemplatesList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setApplyAction";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createTemplatesList";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ErrorBorder
    implements Border {
        private final Border errorDelegateBorder;

        private ErrorBorder(Border delegate) {
            this.errorDelegateBorder = delegate;
        }

        @Override
        public void paintBorder(Component c2, Graphics g, int x, int y, int width, int height) {
            if (ErrorBorder.checkError(c2)) {
                this.errorDelegateBorder.paintBorder(c2, g, x, y, width, height);
            }
        }

        @Override
        public Insets getBorderInsets(Component c2) {
            return ErrorBorder.checkError(c2) ? this.errorDelegateBorder.getBorderInsets(c2) : JBUI.emptyInsets();
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        private static boolean checkError(Component c2) {
            Object outlineObj = ((JComponent)c2).getClientProperty("JComponent.outline");
            if (outlineObj == null) {
                return false;
            }
            DarculaUIUtil.Outline outline = outlineObj instanceof DarculaUIUtil.Outline ? (DarculaUIUtil.Outline)((Object)outlineObj) : DarculaUIUtil.Outline.valueOf(outlineObj.toString());
            return outline == DarculaUIUtil.Outline.error || outline == DarculaUIUtil.Outline.warning;
        }
    }

    private static class TemplateIconExtension
    implements ExtendableTextComponent.Extension {
        private final Icon icon;

        private TemplateIconExtension(Icon icon) {
            this.icon = icon;
        }

        public Icon getIcon(boolean hovered) {
            return this.icon;
        }

        public boolean isIconBeforeText() {
            return true;
        }
    }
}

