/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.AvailablePluginColumnInfo;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.PluginTableModel;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.ColumnInfo;
import java.util.List;
import java.util.TreeSet;
import javax.swing.RowSorter;
import javax.swing.SortOrder;

public class AvailablePluginsTableModel
extends PluginTableModel {
    public static final String ALL = "All";
    public static final String JETBRAINS_REPO = "JetBrains Plugin Repository";
    public static final String BUILTIN_REPO = "Built-in Plugin Repository";
    private String myCategory = "All";
    private final TreeSet<String> myAvailableCategories = new TreeSet();
    private String myRepository = "All";
    private String myVendor = null;

    public AvailablePluginsTableModel() {
        this.columns = new ColumnInfo[]{new AvailablePluginColumnInfo(this)};
        this.setSortKey(new RowSorter.SortKey(this.getNameColumn(), SortOrder.ASCENDING));
    }

    public String getCategory() {
        return this.myCategory;
    }

    public void setCategory(String category, String filter) {
        this.myCategory = category;
        this.filter(filter);
    }

    public void setRepository(String repository, String filter) {
        this.myRepository = repository;
        this.filter(filter);
    }

    public void setVendor(String vendor) {
        this.myVendor = vendor;
        this.filter("");
    }

    @Override
    public boolean isPluginDescriptorAccepted(IdeaPluginDescriptor descriptor2) {
        String vendor;
        String category = descriptor2.getCategory();
        if (category != null && !ALL.equals(this.myCategory) && !category.equals(this.myCategory)) {
            return false;
        }
        if (!(this.myVendor == null || (vendor = descriptor2.getVendor()) != null && StringUtil.containsIgnoreCase((String)vendor, (String)this.myVendor))) {
            return false;
        }
        return this.isHostAccepted(((PluginNode)descriptor2).getRepositoryName());
    }

    public boolean isHostAccepted(String repositoryName) {
        if (repositoryName != null) {
            if (repositoryName.equals(ApplicationInfoEx.getInstanceEx().getBuiltinPluginsUrl()) && this.myRepository.equals(BUILTIN_REPO)) {
                return true;
            }
            return ALL.equals(this.myRepository) || repositoryName.equals(this.myRepository);
        }
        return ALL.equals(this.myRepository) || JETBRAINS_REPO.equals(this.myRepository);
    }

    public TreeSet<String> getAvailableCategories() {
        return this.myAvailableCategories;
    }

    public String getRepository() {
        return this.myRepository;
    }

    private static void updateStatus(IdeaPluginDescriptor descr) {
        IdeaPluginDescriptor existing;
        if (descr instanceof PluginNode && (existing = PluginManager.getPlugin(descr.getPluginId())) != null) {
            PluginNode node = (PluginNode)descr;
            node.setStatus(PluginNode.Status.INSTALLED);
            node.setInstalledVersion(existing.getVersion());
        }
    }

    @Override
    public void updatePluginsList(List<? extends IdeaPluginDescriptor> list2) {
        this.view.clear();
        this.myAvailableCategories.clear();
        this.filtered.clear();
        for (IdeaPluginDescriptor ideaPluginDescriptor : list2) {
            AvailablePluginsTableModel.updateStatus(ideaPluginDescriptor);
            this.view.add(ideaPluginDescriptor);
            String category = ideaPluginDescriptor.getCategory();
            if (category != null) {
                this.myAvailableCategories.add(category);
                continue;
            }
            this.myAvailableCategories.add("N/A");
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getNameColumn() {
        return 0;
    }
}

