/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.google.gson.stream.JsonWriter;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.ApplicationStarter;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class BundledPluginsLister
implements ApplicationStarter {
    public String getCommandName() {
        return "listBundledPlugins";
    }

    public void main(String[] args) {
        try {
            OutputStream out;
            if (args.length == 2) {
                File outFile = new File(args[1]);
                FileUtil.createParentDirs((File)outFile);
                out = new FileOutputStream(outFile);
            } else {
                out = System.out;
            }
            try (JsonWriter writer = new JsonWriter((Writer)new OutputStreamWriter(out, StandardCharsets.UTF_8));){
                IdeaPluginDescriptor[] plugins2 = PluginManagerCore.getPlugins();
                List<String> modules = Arrays.stream(plugins2).flatMap(it -> it instanceof IdeaPluginDescriptorImpl ? ((IdeaPluginDescriptorImpl)it).getModules().stream() : Stream.empty()).sorted().collect(Collectors.toList());
                List<String> pluginIds = Arrays.stream(plugins2).map(plugin -> plugin.getPluginId().getIdString()).sorted().collect(Collectors.toList());
                writer.beginObject();
                BundledPluginsLister.writeList(writer, "modules", modules);
                BundledPluginsLister.writeList(writer, "plugins", pluginIds);
                writer.endObject();
            }
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            System.exit(1);
        }
        System.exit(0);
    }

    private static void writeList(JsonWriter writer, String name, List<String> elements2) throws IOException {
        writer.name(name).beginArray();
        for (String module : elements2) {
            writer.value(module);
        }
        writer.endArray();
    }
}

