/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.newui.HiDPIPluginLogoIcon;
import com.intellij.ide.plugins.newui.PluginLogo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.ui.JBColor;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginLogoApi {
    private final int myWidth;
    private final int myHeight;
    private final Logger myLogger;

    @NotNull
    public static Icon getIcon(@NotNull IdeaPluginDescriptor descriptor2, int width, int height, @Nullable Logger logger) {
        if (descriptor2 == null) {
            PluginLogoApi.$$$reportNull$$$0(0);
        }
        Icon icon = new PluginLogoApi(width, height, logger).getIcon(descriptor2);
        if (icon == null) {
            PluginLogoApi.$$$reportNull$$$0(1);
        }
        return icon;
    }

    private PluginLogoApi(int width, int height, @Nullable Logger logger) {
        this.myWidth = width;
        this.myHeight = height;
        this.myLogger = logger;
    }

    @NotNull
    private Icon getIcon(@NotNull IdeaPluginDescriptor descriptor2) {
        File path;
        if (descriptor2 == null) {
            PluginLogoApi.$$$reportNull$$$0(2);
        }
        if ((path = descriptor2.getPath()) == null) {
            Icon icon = this.getDefaultIcon();
            if (icon == null) {
                PluginLogoApi.$$$reportNull$$$0(3);
            }
            return icon;
        }
        if (path.isDirectory()) {
            Icon icon;
            if (System.getProperty("idea.required.plugins.id") != null && (icon = this.tryLoadDirIcon(new File(path, "classes"))) != null) {
                Icon icon2 = icon;
                if (icon2 == null) {
                    PluginLogoApi.$$$reportNull$$$0(4);
                }
                return icon2;
            }
            icon = this.tryLoadDirIcon(path);
            if (icon != null) {
                Icon icon3 = icon;
                if (icon3 == null) {
                    PluginLogoApi.$$$reportNull$$$0(5);
                }
                return icon3;
            }
            File libFile = new File(path, "lib");
            if (!libFile.exists() || !libFile.isDirectory()) {
                Icon icon4 = this.getDefaultIcon();
                if (icon4 == null) {
                    PluginLogoApi.$$$reportNull$$$0(6);
                }
                return icon4;
            }
            Object[] files2 = libFile.listFiles();
            if (ArrayUtil.isEmpty((Object[])files2)) {
                Icon icon5 = this.getDefaultIcon();
                if (icon5 == null) {
                    PluginLogoApi.$$$reportNull$$$0(7);
                }
                return icon5;
            }
            for (Object file2 : files2) {
                Icon dirIcon = this.tryLoadDirIcon((File)file2);
                if (dirIcon != null) {
                    Icon icon6 = dirIcon;
                    if (icon6 == null) {
                        PluginLogoApi.$$$reportNull$$$0(8);
                    }
                    return icon6;
                }
                Icon jarIcon = this.tryLoadJarIcon((File)file2);
                if (jarIcon == null) continue;
                Icon icon7 = jarIcon;
                if (icon7 == null) {
                    PluginLogoApi.$$$reportNull$$$0(9);
                }
                return icon7;
            }
        } else {
            Icon icon = this.tryLoadJarIcon(path);
            if (icon != null) {
                Icon icon8 = icon;
                if (icon8 == null) {
                    PluginLogoApi.$$$reportNull$$$0(10);
                }
                return icon8;
            }
        }
        Icon icon = this.getDefaultIcon();
        if (icon == null) {
            PluginLogoApi.$$$reportNull$$$0(11);
        }
        return icon;
    }

    @Nullable
    private Icon tryLoadDirIcon(@NotNull File path) {
        boolean light;
        Icon icon;
        if (path == null) {
            PluginLogoApi.$$$reportNull$$$0(12);
        }
        return (icon = this.tryLoadIcon(path, light = JBColor.isBright())) == null ? this.tryLoadIcon(path, !light) : icon;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private Icon tryLoadJarIcon(@NotNull File path) {
        if (path == null) {
            PluginLogoApi.$$$reportNull$$$0(13);
        }
        if (!FileUtilRt.isJarOrZip((File)path)) return null;
        if (!path.exists()) {
            return null;
        }
        try (ZipFile zipFile = new ZipFile(path);){
            boolean light = JBColor.isBright();
            Icon icon2 = this.tryLoadIcon(zipFile, light);
            Icon icon = icon2 == null ? this.tryLoadIcon(zipFile, !light) : icon2;
            return icon;
        }
        catch (Exception e) {
            if (this.myLogger == null) return null;
            this.myLogger.error((Throwable)e);
            return null;
        }
    }

    @Nullable
    private Icon tryLoadIcon(@NotNull File dirFile, boolean light) {
        if (dirFile == null) {
            PluginLogoApi.$$$reportNull$$$0(14);
        }
        try {
            File iconFile = new File(dirFile, PluginLogo.getIconFileName(light));
            return iconFile.exists() && iconFile.length() > 0L ? this.loadFileIcon(new FileInputStream(iconFile)) : null;
        }
        catch (IOException e) {
            if (this.myLogger != null) {
                this.myLogger.error((Throwable)e);
            }
            return null;
        }
    }

    @Nullable
    private Icon tryLoadIcon(@NotNull ZipFile zipFile, boolean light) {
        if (zipFile == null) {
            PluginLogoApi.$$$reportNull$$$0(15);
        }
        try {
            ZipEntry iconEntry = zipFile.getEntry(PluginLogo.getIconFileName(light));
            return iconEntry == null ? null : this.loadFileIcon(zipFile.getInputStream(iconEntry));
        }
        catch (IOException e) {
            if (this.myLogger != null) {
                this.myLogger.error((Throwable)e);
            }
            return null;
        }
    }

    @NotNull
    private Icon loadFileIcon(@NotNull InputStream stream) throws IOException {
        if (stream == null) {
            PluginLogoApi.$$$reportNull$$$0(16);
        }
        Icon icon = HiDPIPluginLogoIcon.loadSVG(stream, this.myWidth, this.myHeight);
        if (icon == null) {
            PluginLogoApi.$$$reportNull$$$0(17);
        }
        return icon;
    }

    private Icon getDefaultIcon() {
        block3: {
            URL url;
            if (AllIcons.Plugins.PluginLogo instanceof IconLoader.CachedImageIcon && (url = ((IconLoader.CachedImageIcon)AllIcons.Plugins.PluginLogo).getURL()) != null) {
                try {
                    return HiDPIPluginLogoIcon.loadSVG(url.openStream(), this.myWidth, this.myHeight);
                }
                catch (IOException e) {
                    if (this.myLogger == null) break block3;
                    this.myLogger.error((Throwable)e);
                }
            }
        }
        return AllIcons.Plugins.PluginLogo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/newui/PluginLogoApi";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirFile";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zipFile";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/newui/PluginLogoApi";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFileIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 17: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "tryLoadDirIcon";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "tryLoadJarIcon";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "tryLoadIcon";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "loadFileIcon";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

