/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.PsiCopyPasteManager;
import com.intellij.ide.projectView.BaseProjectTreeBuilder;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.AsyncProjectViewSupport;
import com.intellij.ide.projectView.impl.ProjectAbstractTreeStructureBase;
import com.intellij.ide.projectView.impl.ProjectTreeBuilder;
import com.intellij.ide.projectView.impl.ProjectViewTree;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.ui.customization.CustomizationUtil;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeUpdater;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.ide.util.treeView.TreeBuilderUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.stripe.ErrorStripe;
import com.intellij.ui.stripe.ErrorStripePainter;
import com.intellij.ui.stripe.TreeUpdater;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractProjectViewPSIPane
extends AbstractProjectViewPane {
    private AsyncProjectViewSupport myAsyncSupport;
    private JScrollPane myComponent;

    protected AbstractProjectViewPSIPane(@NotNull Project project) {
        if (project == null) {
            AbstractProjectViewPSIPane.$$$reportNull$$$0(0);
        }
        super(project);
    }

    @Override
    @NotNull
    public JComponent createComponent() {
        if (this.myComponent != null) {
            if (this.myTree != null) {
                this.myTree.updateUI();
            }
            JScrollPane jScrollPane = this.myComponent;
            if (jScrollPane == null) {
                AbstractProjectViewPSIPane.$$$reportNull$$$0(1);
            }
            return jScrollPane;
        }
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(null);
        DefaultTreeModel treeModel = new DefaultTreeModel(rootNode);
        this.myTree = this.createTree(treeModel);
        this.enableDnD();
        this.myComponent = ScrollPaneFactory.createScrollPane((Component)((Object)this.myTree));
        if (Registry.is((String)"error.stripe.enabled")) {
            ErrorStripePainter painter = new ErrorStripePainter(true);
            Disposer.register((Disposable)this, (Disposable)new TreeUpdater<ErrorStripePainter>(painter, this.myComponent, (JTree)((Object)this.myTree)){

                @Override
                protected void update(ErrorStripePainter painter, int index, Object object) {
                    if (object instanceof DefaultMutableTreeNode) {
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)object;
                        object = node.getUserObject();
                    }
                    super.update(painter, index, AbstractProjectViewPSIPane.this.getStripe(object, AbstractProjectViewPSIPane.this.myTree.isExpanded(index)));
                }
            });
        }
        this.myTreeStructure = this.createStructure();
        BaseProjectTreeBuilder treeBuilder = this.createBuilder(treeModel);
        if (treeBuilder != null) {
            this.installComparator(treeBuilder);
            this.setTreeBuilder(treeBuilder);
        } else {
            this.myAsyncSupport = new AsyncProjectViewSupport(this, this.myProject, (JTree)((Object)this.myTree), this.myTreeStructure, this.createComparator());
        }
        this.initTree();
        Disposer.register((Disposable)this, (Disposable)new UiNotifyConnector((Component)((Object)this.myTree), new Activatable(){
            private boolean showing;

            public void showNotify() {
                if (!this.showing) {
                    this.showing = true;
                    AbstractProjectViewPSIPane.this.restoreExpandedPaths();
                }
            }

            public void hideNotify() {
                if (this.showing) {
                    this.showing = false;
                    AbstractProjectViewPSIPane.this.saveExpandedPaths();
                }
            }
        }));
        JScrollPane jScrollPane = this.myComponent;
        if (jScrollPane == null) {
            AbstractProjectViewPSIPane.$$$reportNull$$$0(2);
        }
        return jScrollPane;
    }

    @Override
    protected void installComparator(AbstractTreeBuilder builder2, @NotNull Comparator<? super NodeDescriptor> comparator2) {
        if (comparator2 == null) {
            AbstractProjectViewPSIPane.$$$reportNull$$$0(3);
        }
        if (this.myAsyncSupport != null) {
            this.myAsyncSupport.setComparator(comparator2);
        }
        super.installComparator(builder2, comparator2);
    }

    @Override
    public final void dispose() {
        this.myAsyncSupport = null;
        this.myComponent = null;
        super.dispose();
    }

    private void initTree() {
        this.myTree.getSelectionModel().setSelectionMode(4);
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        this.myTree.expandPath(new TreePath(this.myTree.getModel().getRoot()));
        EditSourceOnDoubleClickHandler.install((JTree)((Object)this.myTree));
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this.myTree));
        TreeUtil.installActions((JTree)((Object)this.myTree));
        new MySpeedSearch((JTree)((Object)this.myTree));
        this.myTree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (10 == e.getKeyCode()) {
                    TreePath path = AbstractProjectViewPSIPane.this.getSelectedPath();
                    if (path != null && !AbstractProjectViewPSIPane.this.myTree.getModel().isLeaf(path.getLastPathComponent())) {
                        return;
                    }
                    DataContext dataContext = DataManager.getInstance().getDataContext((Component)((Object)AbstractProjectViewPSIPane.this.myTree));
                    OpenSourceUtil.openSourcesFrom((DataContext)dataContext, (boolean)ScreenReader.isActive());
                } else if (27 == e.getKeyCode()) {
                    boolean[] isCopied;
                    if (e.isConsumed()) {
                        return;
                    }
                    PsiCopyPasteManager copyPasteManager = PsiCopyPasteManager.getInstance();
                    if (copyPasteManager.getElements(isCopied = new boolean[1]) != null && !isCopied[0]) {
                        copyPasteManager.clear();
                        e.consume();
                    }
                }
            }
        });
        CustomizationUtil.installPopupHandler((JComponent)((Object)this.myTree), "ProjectViewPopupMenu", "ProjectViewPopup");
    }

    @Override
    @NotNull
    public final ActionCallback updateFromRoot(boolean restoreExpandedPaths) {
        Runnable afterUpdate;
        ActionCallback cb = new ActionCallback();
        AbstractTreeBuilder builder2 = this.getTreeBuilder();
        if (restoreExpandedPaths && builder2 != null) {
            ArrayList pathsToExpand = new ArrayList();
            ArrayList selectionPaths = new ArrayList();
            TreeBuilderUtil.storePaths((AbstractTreeBuilder)builder2, (DefaultMutableTreeNode)((DefaultMutableTreeNode)this.myTree.getModel().getRoot()), pathsToExpand, selectionPaths, (boolean)true);
            afterUpdate = () -> {
                if (this.myTree != null && !builder2.isDisposed()) {
                    this.myTree.clearSelection();
                    TreeBuilderUtil.restorePaths((AbstractTreeBuilder)builder2, (List)pathsToExpand, (List)selectionPaths, (boolean)true);
                }
                cb.setDone();
            };
        } else {
            afterUpdate = cb.createSetDoneRunnable();
        }
        if (builder2 != null) {
            builder2.addSubtreeToUpdate(builder2.getRootNode(), afterUpdate);
        } else if (this.myAsyncSupport != null) {
            this.myAsyncSupport.updateAll(afterUpdate);
        }
        ActionCallback actionCallback = cb;
        if (actionCallback == null) {
            AbstractProjectViewPSIPane.$$$reportNull$$$0(4);
        }
        return actionCallback;
    }

    @Override
    public void select(Object element, VirtualFile file2, boolean requestFocus) {
        this.selectCB(element, file2, requestFocus);
    }

    @NotNull
    public ActionCallback selectCB(Object element, VirtualFile file2, boolean requestFocus) {
        if (file2 != null) {
            AbstractTreeBuilder builder2 = this.getTreeBuilder();
            if (builder2 instanceof BaseProjectTreeBuilder) {
                this.beforeSelect().doWhenDone(() -> UIUtil.invokeLaterIfNeeded(() -> {
                    if (!builder2.isDisposed()) {
                        ((BaseProjectTreeBuilder)builder2).selectAsync(element, file2, requestFocus);
                    }
                }));
            } else if (this.myAsyncSupport != null) {
                this.myAsyncSupport.select((JTree)((Object)this.myTree), element, file2);
            }
        }
        ActionCallback actionCallback = ActionCallback.DONE;
        if (actionCallback == null) {
            AbstractProjectViewPSIPane.$$$reportNull$$$0(5);
        }
        return actionCallback;
    }

    @NotNull
    public ActionCallback beforeSelect() {
        AbstractTreeBuilder builder2 = this.getTreeBuilder();
        if (builder2 == null) {
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                AbstractProjectViewPSIPane.$$$reportNull$$$0(6);
            }
            return actionCallback;
        }
        ActionCallback actionCallback = builder2.getInitialized();
        if (actionCallback == null) {
            AbstractProjectViewPSIPane.$$$reportNull$$$0(7);
        }
        return actionCallback;
    }

    protected BaseProjectTreeBuilder createBuilder(@NotNull DefaultTreeModel treeModel) {
        if (treeModel == null) {
            AbstractProjectViewPSIPane.$$$reportNull$$$0(8);
        }
        return new ProjectTreeBuilder(this.myProject, (JTree)((Object)this.myTree), treeModel, null, (ProjectAbstractTreeStructureBase)this.myTreeStructure){

            protected AbstractTreeUpdater createUpdater() {
                return AbstractProjectViewPSIPane.this.createTreeUpdater(this);
            }
        };
    }

    @NotNull
    protected abstract ProjectAbstractTreeStructureBase createStructure();

    @NotNull
    protected abstract ProjectViewTree createTree(@NotNull DefaultTreeModel var1);

    @NotNull
    protected abstract AbstractTreeUpdater createTreeUpdater(@NotNull AbstractTreeBuilder var1);

    protected ErrorStripe getStripe(Object object, boolean expanded) {
        if (expanded && object instanceof PsiDirectoryNode) {
            return null;
        }
        if (object instanceof PresentableNodeDescriptor) {
            Color color;
            PresentableNodeDescriptor node = (PresentableNodeDescriptor)object;
            TextAttributesKey key = node.getPresentation().getTextAttributesKey();
            TextAttributes attributes = key == null ? null : EditorColorsManager.getInstance().getSchemeForCurrentUITheme().getAttributes(key);
            Color color2 = color = attributes == null ? null : attributes.getErrorStripeColor();
            if (color != null) {
                return ErrorStripe.create(color, 1);
            }
        }
        return null;
    }

    @Override
    AsyncProjectViewSupport getAsyncSupport() {
        return this.myAsyncSupport;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/AbstractProjectViewPSIPane";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/AbstractProjectViewPSIPane";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "updateFromRoot";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "selectCB";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeSelect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "installComparator";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createBuilder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static final class MySpeedSearch
    extends TreeSpeedSearch {
        MySpeedSearch(JTree tree) {
            super(tree);
        }

        @Override
        protected boolean isMatchingElement(Object element, String pattern) {
            Object userObject = ((DefaultMutableTreeNode)((TreePath)element).getLastPathComponent()).getUserObject();
            if (userObject instanceof PsiDirectoryNode) {
                String str = this.getElementText(element);
                if (str == null) {
                    return false;
                }
                str = StringUtil.toLowerCase((String)str);
                if (pattern.indexOf(46) >= 0) {
                    return this.compare(str, pattern);
                }
                StringTokenizer tokenizer = new StringTokenizer(str, ".");
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    if (!this.compare(token, pattern)) continue;
                    return true;
                }
                return false;
            }
            return super.isMatchingElement(element, pattern);
        }
    }
}

