/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.VfsPresentationUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.popup.HintUpdateSupply;
import com.intellij.ui.tabs.FileColorManagerImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayDeque;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectViewTree
extends DnDAwareTree {
    private static final Logger LOG = Logger.getInstance(ProjectViewTree.class);

    protected ProjectViewTree(Project project, TreeModel model2) {
        this(model2);
    }

    public ProjectViewTree(TreeModel model2) {
        super(model2);
        NodeRenderer cellRenderer = new NodeRenderer(){

            protected void doPaint(Graphics2D g) {
                super.doPaint(g);
                this.setOpaque(false);
            }

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (tree == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.customizeCellRenderer(tree, value, selected2, expanded, leaf, row, hasFocus);
                Object object = TreeUtil.getUserObject((Object)value);
                if (object instanceof ProjectViewNode && UISettings.getInstance().getShowInplaceComments()) {
                    ProjectViewNode node = (ProjectViewNode)object;
                    AbstractTreeNode parentNode = node.getParent();
                    Object content2 = node.getValue();
                    VirtualFile file2 = content2 instanceof PsiFileSystemItem || !(content2 instanceof PsiElement) || parentNode != null && parentNode.getValue() instanceof PsiDirectory ? node.getVirtualFile() : null;
                    File ioFile = file2 == null || file2.isDirectory() || !file2.isInLocalFileSystem() ? null : VfsUtilCore.virtualToIoFile((VirtualFile)file2);
                    BasicFileAttributes attr = null;
                    try {
                        attr = ioFile == null ? null : Files.readAttributes(Paths.get(ioFile.toURI()), BasicFileAttributes.class, new LinkOption[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (attr != null) {
                        this.append("  ");
                        SimpleTextAttributes attributes = SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES;
                        this.append(DateFormatUtil.formatDateTime((long)attr.lastModifiedTime().toMillis()), attributes);
                        this.append(", " + StringUtil.formatFileSize((long)attr.size()), attributes);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/ide/projectView/impl/ProjectViewTree$1", "customizeCellRenderer"));
            }
        };
        cellRenderer.setOpaque(false);
        cellRenderer.setIconOpaque(false);
        this.setCellRenderer((TreeCellRenderer)cellRenderer);
        cellRenderer.setTransparentIconBackground(true);
        HintUpdateSupply.installDataContextHintUpdateSupply((JComponent)((Object)this));
    }

    @Deprecated
    public DefaultMutableTreeNode getSelectedNode() {
        TreePath path = TreeUtil.getSelectedPathIfOne((JTree)((Object)this));
        return path == null ? null : (DefaultMutableTreeNode)ObjectUtils.tryCast((Object)path.getLastPathComponent(), DefaultMutableTreeNode.class);
    }

    public final int getToggleClickCount() {
        NodeDescriptor descriptor2;
        int count = super.getToggleClickCount();
        TreePath path = this.getSelectionPath();
        if (path != null && (descriptor2 = (NodeDescriptor)TreeUtil.getLastUserObject(NodeDescriptor.class, (TreePath)path)) != null && !descriptor2.expandOnDoubleClick()) {
            LOG.debug("getToggleClickCount: -1 for ", new Object[]{descriptor2.getClass().getName()});
            return -1;
        }
        return count;
    }

    public void setToggleClickCount(int count) {
        if (count != 2) {
            LOG.info((Throwable)new IllegalStateException("setToggleClickCount: unexpected count = " + count));
        }
        super.setToggleClickCount(count);
    }

    public boolean isFileColorsEnabled() {
        return ProjectViewTree.isFileColorsEnabledFor((JTree)((Object)this));
    }

    public static boolean isFileColorsEnabledFor(JTree tree) {
        boolean enabled = FileColorManagerImpl._isEnabled() && FileColorManagerImpl._isEnabledForProjectView();
        boolean opaque = tree.isOpaque();
        if (enabled && opaque) {
            tree.setOpaque(false);
        } else if (!enabled && !opaque) {
            tree.setOpaque(true);
        }
        return enabled;
    }

    @Nullable
    public Color getFileColorFor(Object object) {
        Color color;
        Project project;
        VirtualFile file2;
        Object value;
        DefaultMutableTreeNode node;
        if (object instanceof DefaultMutableTreeNode) {
            node = (DefaultMutableTreeNode)object;
            object = node.getUserObject();
        }
        if (object instanceof AbstractTreeNode && (value = (node = (AbstractTreeNode)object).getValue()) instanceof PsiElement) {
            return ProjectViewTree.getColorForElement((PsiElement)value);
        }
        if (object instanceof ProjectViewNode && (file2 = (node = (ProjectViewNode)object).getVirtualFile()) != null && (project = node.getProject()) != null && !project.isDisposed() && (color = VfsPresentationUtil.getFileBackgroundColor(project, file2)) != null) {
            return color;
        }
        return null;
    }

    @Nullable
    public static Color getColorForElement(@Nullable PsiElement psi) {
        Color color = null;
        if (psi != null) {
            if (!psi.isValid()) {
                return null;
            }
            Project project = psi.getProject();
            VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)psi);
            if (file2 != null) {
                color = VfsPresentationUtil.getFileBackgroundColor(project, file2);
            } else if (psi instanceof PsiDirectory) {
                color = VfsPresentationUtil.getFileBackgroundColor(project, ((PsiDirectory)psi).getVirtualFile());
            } else if (psi instanceof PsiDirectoryContainer) {
                PsiDirectory[] dirs;
                for (PsiDirectory dir : dirs = ((PsiDirectoryContainer)psi).getDirectories()) {
                    Color c2 = VfsPresentationUtil.getFileBackgroundColor(project, dir.getVirtualFile());
                    if (c2 != null && color == null) {
                        color = c2;
                        continue;
                    }
                    if (c2 == null) continue;
                    color = null;
                    break;
                }
            }
        }
        return color;
    }

    public void collapsePath(TreePath path) {
        int row;
        int n = row = Registry.is((String)"async.project.view.collapse.tree.path.recursively") ? this.getRowForPath(path) : -1;
        if (row < 0) {
            super.collapsePath(path);
        } else {
            TreePath next;
            ArrayDeque<TreePath> deque = new ArrayDeque<TreePath>();
            deque.addFirst(path);
            while (++row < this.getRowCount() && path.isDescendant(next = this.getPathForRow(row))) {
                if (!this.isExpanded(next)) continue;
                deque.addFirst(next);
            }
            deque.forEach(x$0 -> super.collapsePath(x$0));
        }
    }
}

