/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.PerFileMappings;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Dimension;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LRUPopupBuilder<T> {
    private static final Logger LOG = Logger.getInstance(LRUPopupBuilder.class);
    private static final int MAX_VISIBLE_SIZE = 20;
    private static final int LRU_ITEMS = 4;
    private final String myTitle;
    private final PropertiesComponent myPropertiesComponent;
    private final Map<T, Pair<String, Icon>> myPresentations;
    private T mySelection;
    private Consumer<? super T> myOnChosen;
    private Comparator<? super T> myComparator;
    private Iterable<? extends T> myItemsIterable;
    private JBIterable<T> myExtraItems;

    @NotNull
    public static ListPopup forFileLanguages(@NotNull Project project, @NotNull String title, @NotNull Iterable<? extends VirtualFile> files2, @NotNull PerFileMappings<Language> mappings) {
        if (project == null) {
            LRUPopupBuilder.$$$reportNull$$$0(0);
        }
        if (title == null) {
            LRUPopupBuilder.$$$reportNull$$$0(1);
        }
        if (files2 == null) {
            LRUPopupBuilder.$$$reportNull$$$0(2);
        }
        if (mappings == null) {
            LRUPopupBuilder.$$$reportNull$$$0(3);
        }
        VirtualFile[] filesCopy = VfsUtilCore.toVirtualFileArray((Collection)JBIterable.from(files2).toList());
        Arrays.sort(filesCopy, (o1, o2) -> StringUtil.compare((String)o1.getName(), (String)o2.getName(), (!o1.getFileSystem().isCaseSensitive() ? 1 : 0) != 0));
        ListPopup listPopup = LRUPopupBuilder.forFileLanguages(project, title, null, (Consumer<? super Language>)((Consumer)t -> {
            try {
                WriteCommandAction.writeCommandAction((Project)project).withName("Change Language").run(() -> LRUPopupBuilder.changeLanguageWithUndo(project, t, filesCopy, mappings));
            }
            catch (UnexpectedUndoException e) {
                LOG.error((Throwable)e);
            }
        }));
        if (listPopup == null) {
            LRUPopupBuilder.$$$reportNull$$$0(4);
        }
        return listPopup;
    }

    @Deprecated
    @NotNull
    public static ListPopup forFileLanguages(@NotNull Project project, @Nullable Language selection, @NotNull Consumer<? super Language> onChosen) {
        if (project == null) {
            LRUPopupBuilder.$$$reportNull$$$0(5);
        }
        if (onChosen == null) {
            LRUPopupBuilder.$$$reportNull$$$0(6);
        }
        ListPopup listPopup = LRUPopupBuilder.forFileLanguages(project, "Languages", selection, onChosen);
        if (listPopup == null) {
            LRUPopupBuilder.$$$reportNull$$$0(7);
        }
        return listPopup;
    }

    @NotNull
    public static ListPopup forFileLanguages(@NotNull Project project, @NotNull String title, @Nullable Language selection, @NotNull Consumer<? super Language> onChosen) {
        if (project == null) {
            LRUPopupBuilder.$$$reportNull$$$0(8);
        }
        if (title == null) {
            LRUPopupBuilder.$$$reportNull$$$0(9);
        }
        if (onChosen == null) {
            LRUPopupBuilder.$$$reportNull$$$0(10);
        }
        ListPopup listPopup = LRUPopupBuilder.languagePopupBuilder(project, title).forValues(LanguageUtil.getFileLanguages()).withSelection(selection).onChosen(onChosen).buildPopup();
        if (listPopup == null) {
            LRUPopupBuilder.$$$reportNull$$$0(11);
        }
        return listPopup;
    }

    @NotNull
    public static LRUPopupBuilder<Language> languagePopupBuilder(@NotNull Project project, @NotNull String title) {
        if (project == null) {
            LRUPopupBuilder.$$$reportNull$$$0(12);
        }
        if (title == null) {
            LRUPopupBuilder.$$$reportNull$$$0(13);
        }
        LRUPopupBuilder<Language> lRUPopupBuilder = new LRUPopupBuilder<Language>(project, title){

            @Override
            public String getDisplayName(Language language) {
                return language.getDisplayName();
            }

            @Override
            public Icon getIcon(Language language) {
                LanguageFileType associatedLanguage = language.getAssociatedFileType();
                return associatedLanguage != null ? associatedLanguage.getIcon() : null;
            }

            @Override
            public String getStorageId(Language language) {
                return language.getID();
            }
        }.withComparator(LanguageUtil.LANGUAGE_COMPARATOR);
        if (lRUPopupBuilder == null) {
            LRUPopupBuilder.$$$reportNull$$$0(14);
        }
        return lRUPopupBuilder;
    }

    protected LRUPopupBuilder(@NotNull Project project, @NotNull String title) {
        if (project == null) {
            LRUPopupBuilder.$$$reportNull$$$0(15);
        }
        if (title == null) {
            LRUPopupBuilder.$$$reportNull$$$0(16);
        }
        this.myPresentations = ContainerUtil.newIdentityHashMap();
        this.myExtraItems = JBIterable.empty();
        this.myTitle = title;
        this.myPropertiesComponent = PropertiesComponent.getInstance((Project)project);
    }

    public abstract String getDisplayName(T var1);

    public abstract String getStorageId(T var1);

    public abstract Icon getIcon(T var1);

    @NotNull
    public LRUPopupBuilder<T> forValues(@Nullable Iterable<? extends T> items) {
        this.myItemsIterable = items;
        LRUPopupBuilder lRUPopupBuilder = this;
        if (lRUPopupBuilder == null) {
            LRUPopupBuilder.$$$reportNull$$$0(17);
        }
        return lRUPopupBuilder;
    }

    @NotNull
    public LRUPopupBuilder<T> withSelection(@Nullable T t) {
        this.mySelection = t;
        LRUPopupBuilder lRUPopupBuilder = this;
        if (lRUPopupBuilder == null) {
            LRUPopupBuilder.$$$reportNull$$$0(18);
        }
        return lRUPopupBuilder;
    }

    @NotNull
    public LRUPopupBuilder<T> withExtra(@NotNull T extra, @NotNull String displayName, @Nullable Icon icon) {
        if (extra == null) {
            LRUPopupBuilder.$$$reportNull$$$0(19);
        }
        if (displayName == null) {
            LRUPopupBuilder.$$$reportNull$$$0(20);
        }
        this.myExtraItems = this.myExtraItems.append(extra);
        this.myPresentations.put(extra, (Pair<String, Icon>)Pair.create((Object)displayName, (Object)icon));
        LRUPopupBuilder lRUPopupBuilder = this;
        if (lRUPopupBuilder == null) {
            LRUPopupBuilder.$$$reportNull$$$0(21);
        }
        return lRUPopupBuilder;
    }

    @NotNull
    public LRUPopupBuilder<T> onChosen(@Nullable Consumer<? super T> consumer) {
        this.myOnChosen = consumer;
        LRUPopupBuilder lRUPopupBuilder = this;
        if (lRUPopupBuilder == null) {
            LRUPopupBuilder.$$$reportNull$$$0(22);
        }
        return lRUPopupBuilder;
    }

    public LRUPopupBuilder<T> withComparator(@Nullable Comparator<? super T> comparator2) {
        this.myComparator = comparator2;
        return this;
    }

    @NotNull
    public ListPopup buildPopup() {
        ArrayList ids = ContainerUtil.newArrayList((Object[])this.restoreLRUItems());
        if (this.mySelection != null) {
            ids.add(this.getStorageId(this.mySelection));
        }
        ArrayList<T> lru = new ArrayList<T>(4);
        ArrayList items = new ArrayList(20);
        final List extra = this.myExtraItems.toList();
        if (this.myItemsIterable != null) {
            for (T t : this.myItemsIterable) {
                (ids.indexOf(this.getStorageId(t)) != -1 ? lru : items).add(t);
            }
        }
        if (this.myComparator != null) {
            Collections.sort(items, this.myComparator);
        }
        if (!lru.isEmpty()) {
            Collections.sort(lru, Comparator.comparingInt(o -> ids.indexOf(this.getStorageId(o))));
        }
        final Object separator1 = !lru.isEmpty() && !items.isEmpty() ? items.get(0) : null;
        final Object separator2 = !lru.isEmpty() || !items.isEmpty() ? ContainerUtil.getFirstItem((List)extra) : null;
        List combinedItems = ContainerUtil.concat((List[])new List[]{lru, items, extra});
        BaseListPopupStep step = new BaseListPopupStep<T>(this.myTitle, combinedItems){

            @NotNull
            public String getTextFor(T t) {
                String string = t == null ? "" : (String)((LRUPopupBuilder)LRUPopupBuilder.this).getPresentation(t).first;
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            public Icon getIconFor(T t) {
                return t == null ? null : (Icon)((LRUPopupBuilder)LRUPopupBuilder.this).getPresentation(t).second;
            }

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            public PopupStep onChosen(T t, boolean finalChoice) {
                if (!extra.contains(t)) {
                    LRUPopupBuilder.this.storeLRUItems(t);
                }
                if (LRUPopupBuilder.this.myOnChosen != null) {
                    this.doFinalStep(() -> LRUPopupBuilder.this.myOnChosen.consume(t));
                }
                return null;
            }

            @Nullable
            public ListSeparator getSeparatorAbove(T value) {
                return value == separator1 || value == separator2 ? new ListSeparator() : null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/LRUPopupBuilder$2", "getTextFor"));
            }
        };
        int selection = Math.max(0, this.mySelection != null ? combinedItems.indexOf(this.mySelection) : 0);
        step.setDefaultOptionIndex(selection);
        ListPopup listPopup = LRUPopupBuilder.tweakSizeToPreferred(JBPopupFactory.getInstance().createListPopup((ListPopupStep)step));
        if (listPopup == null) {
            LRUPopupBuilder.$$$reportNull$$$0(23);
        }
        return listPopup;
    }

    @NotNull
    private Pair<String, Icon> getPresentation(T t) {
        Pair p = this.myPresentations.get(t);
        if (p == null) {
            p = Pair.create((Object)this.getDisplayName(t), (Object)this.getIcon(t));
            this.myPresentations.put(t, (Pair<String, Icon>)p);
        }
        Pair pair = p;
        if (pair == null) {
            LRUPopupBuilder.$$$reportNull$$$0(24);
        }
        return pair;
    }

    @NotNull
    private static ListPopup tweakSizeToPreferred(@NotNull ListPopup popup2) {
        if (popup2 == null) {
            LRUPopupBuilder.$$$reportNull$$$0(25);
        }
        int nameLen = 0;
        ListPopupStep step = popup2.getListStep();
        List values = step.getValues();
        for (Object v : values) {
            nameLen = Math.max(nameLen, step.getTextFor(v).length());
        }
        if (values.size() > 20) {
            Dimension size = new JLabel(StringUtil.repeatSymbol((char)'a', (int)nameLen), EmptyIcon.ICON_16, 2).getPreferredSize();
            size.width += 20;
            size.height *= 20;
            popup2.setSize(size);
        }
        ListPopup listPopup = popup2;
        if (listPopup == null) {
            LRUPopupBuilder.$$$reportNull$$$0(26);
        }
        return listPopup;
    }

    @NotNull
    private String[] restoreLRUItems() {
        String[] stringArray = (String[])ObjectUtils.notNull((Object)this.myPropertiesComponent.getValues(this.getLRUKey()), (Object)ArrayUtilRt.EMPTY_STRING_ARRAY);
        if (stringArray == null) {
            LRUPopupBuilder.$$$reportNull$$$0(27);
        }
        return stringArray;
    }

    private void storeLRUItems(@NotNull T t) {
        if (t == null) {
            LRUPopupBuilder.$$$reportNull$$$0(28);
        }
        String[] values = this.myPropertiesComponent.getValues(this.getLRUKey());
        ArrayList<String> lastUsed = new ArrayList<String>(4);
        lastUsed.add(this.getStorageId(t));
        if (values != null) {
            for (String value : values) {
                if (!lastUsed.contains(value)) {
                    lastUsed.add(value);
                }
                if (lastUsed.size() == 4) break;
            }
        }
        this.myPropertiesComponent.setValues(this.getLRUKey(), ArrayUtilRt.toStringArray(lastUsed));
    }

    @NotNull
    private String getLRUKey() {
        String string = this.getClass().getName() + "/" + this.myTitle;
        if (string == null) {
            LRUPopupBuilder.$$$reportNull$$$0(29);
        }
        return string;
    }

    private static void changeLanguageWithUndo(@NotNull Project project, final @NotNull Language t, final @NotNull VirtualFile[] sortedFiles, final @NotNull PerFileMappings<Language> mappings) throws UnexpectedUndoException {
        ReadonlyStatusHandler.OperationStatus status;
        if (project == null) {
            LRUPopupBuilder.$$$reportNull$$$0(30);
        }
        if (t == null) {
            LRUPopupBuilder.$$$reportNull$$$0(31);
        }
        if (sortedFiles == null) {
            LRUPopupBuilder.$$$reportNull$$$0(32);
        }
        if (mappings == null) {
            LRUPopupBuilder.$$$reportNull$$$0(33);
        }
        if ((status = ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(Arrays.asList(sortedFiles))).hasReadonlyFiles()) {
            return;
        }
        LinkedHashSet<VirtualFile> matchedExtensions = new LinkedHashSet<VirtualFile>();
        final HashMap<VirtualFile, Object> oldMapping = new HashMap<VirtualFile, Object>();
        for (VirtualFile file2 : sortedFiles) {
            oldMapping.put(file2, mappings.getMapping(file2));
            if (!ScratchUtil.hasMatchingExtension(project, file2)) continue;
            matchedExtensions.add(file2);
        }
        BasicUndoableAction action2 = new BasicUndoableAction(sortedFiles){

            public void undo() {
                for (VirtualFile file2 : sortedFiles) {
                    mappings.setMapping(file2, oldMapping.get(file2));
                }
            }

            public void redo() {
                for (VirtualFile file2 : sortedFiles) {
                    mappings.setMapping(file2, (Object)t);
                }
            }
        };
        action2.redo();
        UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)action2);
        for (VirtualFile file3 : matchedExtensions) {
            try {
                ScratchUtil.updateFileExtension(project, file3);
            }
            catch (IOException iOException) {}
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 14: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 14: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 9: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 3: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 14: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/scratch/LRUPopupBuilder";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onChosen";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extra";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sortedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/scratch/LRUPopupBuilder";
                break;
            }
            case 4: 
            case 7: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "forFileLanguages";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "languagePopupBuilder";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "forValues";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "withSelection";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "withExtra";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "onChosen";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPopup";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "tweakSizeToPreferred";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "restoreLRUItems";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getLRUKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "forFileLanguages";
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 14: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 29: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "languagePopupBuilder";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "withExtra";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "tweakSizeToPreferred";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "storeLRUItems";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "changeLanguageWithUndo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 14: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

