/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.todo.HighlightedRegionProvider;
import com.intellij.ide.todo.nodes.TodoItemNode;
import com.intellij.ui.HighlightableCellRenderer;
import com.intellij.ui.HighlightedRegion;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;

public class MultiLineTodoRenderer
extends JPanel
implements TreeCellRenderer {
    private static final int MAX_DISPLAYED_LINES = 10;
    private final HighlightableCellRenderer myPrefixRenderer;
    private final HighlightableCellRenderer[] myLineRenderers = new HighlightableCellRenderer[10];
    private final JLabel myMoreLabel;

    public MultiLineTodoRenderer() {
        super(new GridBagLayout());
        GridBagConstraints c2 = new GridBagConstraints();
        this.myPrefixRenderer = new HighlightableCellRenderer();
        this.add((Component)this.myPrefixRenderer, c2);
        c2.gridx = 1;
        c2.weightx = 1.0;
        c2.fill = 2;
        c2.anchor = 17;
        for (int i = 0; i < 10; ++i) {
            c2.gridy = i;
            this.myLineRenderers[i] = new HighlightableCellRenderer();
            this.add((Component)this.myLineRenderers[i], c2);
        }
        ++c2.gridy;
        this.myMoreLabel = new JLabel(IdeBundle.message((String)"node.todo.more.items", (Object[])new Object[0]));
        this.add((Component)this.myMoreLabel, c2);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        TodoItemNode node = (TodoItemNode)((DefaultMutableTreeNode)value).getUserObject();
        String text2 = value.toString();
        int parenPos = text2.indexOf(41);
        int contentStartPos = parenPos >= 0 && parenPos < text2.length() - 1 ? parenPos + 2 : 0;
        this.myPrefixRenderer.getTreeCellRendererComponent(tree, (Object)text2.substring(0, contentStartPos), selected2, expanded, leaf, row, hasFocus);
        this.myPrefixRenderer.setIcon(node.getIcon());
        List<HighlightedRegionProvider> additionalLines = node.getAdditionalLines();
        for (int i = 0; i < 10; ++i) {
            if (i > additionalLines.size()) {
                this.myLineRenderers[i].setVisible(false);
                continue;
            }
            this.myLineRenderers[i].setVisible(true);
            this.myLineRenderers[i].getTreeCellRendererComponent(tree, i == 0 ? text2.substring(contentStartPos) : additionalLines.get(i - 1), selected2, expanded, leaf, row, hasFocus);
            TodoItemNode provider = i == 0 ? node : additionalLines.get(i - 1);
            for (HighlightedRegion region : provider.getHighlightedRegions()) {
                this.myLineRenderers[i].addHighlighter(region.startOffset - (i == 0 ? contentStartPos : 0), region.endOffset - (i == 0 ? contentStartPos : 0), region.textAttributes);
            }
        }
        this.myMoreLabel.setVisible(additionalLines.size() >= 10);
        return this;
    }
}

