/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.ui.OptionsTopHitProvider;
import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ex.ConfigurableVisitor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigurableOptionsTopHitProvider
extends OptionsTopHitProvider {
    private static final Logger LOG = Logger.getInstance(ConfigurableOptionsTopHitProvider.class);
    private final Deque<String> myPrefix = new ArrayDeque<String>();

    protected abstract Configurable getConfigurable(@Nullable Project var1);

    protected String getName(Configurable configurable2) {
        return configurable2.getDisplayName();
    }

    protected String getSection(Component component) {
        Border border;
        if (component instanceof JComponent && (border = ((JComponent)component).getBorder()) instanceof TitledBorder) {
            return ((TitledBorder)border).getTitle();
        }
        return null;
    }

    protected String getOptionName(JCheckBox checkbox) {
        return this.getOptionName(checkbox.getText());
    }

    @Nullable
    protected String getOptionName(@NotNull String text2) {
        String name;
        if (text2 == null) {
            ConfigurableOptionsTopHitProvider.$$$reportNull$$$0(0);
        }
        if (StringUtil.isEmpty((String)(name = StringUtil.stripHtml((String)text2, (boolean)false)))) {
            return null;
        }
        if (this.myPrefix.isEmpty()) {
            return name;
        }
        StringBuilder sb = new StringBuilder();
        Iterator<String> iterator = this.myPrefix.descendingIterator();
        while (iterator.hasNext()) {
            sb.append(iterator.next()).append(": ");
        }
        return sb.append(name).toString();
    }

    protected void init(Collection<? super BooleanOptionDescription> options, Configurable configurable2, Component component) {
        this.initRecursively(options, configurable2, component);
    }

    private void initRecursively(Collection<? super BooleanOptionDescription> options, Configurable configurable2, Component component) {
        String section = this.getSection(component);
        if (section != null) {
            this.myPrefix.push(section);
        }
        if (component instanceof JCheckBox) {
            JCheckBox checkbox = (JCheckBox)component;
            String option = this.getOptionName(checkbox);
            if (option != null) {
                options.add(new Option(configurable2, checkbox, option));
            }
        } else if (component instanceof JComboBox) {
            JComboBox combo = (JComboBox)component;
            if (!combo.isEditable()) {
                String baseName;
                JLabel label2 = (JLabel)UIUtil.uiChildren((Component)combo.getParent()).takeWhile(o -> o != combo).filter(JLabel.class).last();
                String string = baseName = label2 == null ? null : this.getOptionName(label2.getText());
                if (baseName != null) {
                    String optionName = (baseName + " ").replace(": ", " | ");
                    List<String> list2 = SearchUtil.getItemsFromComboBox(combo);
                    int len = list2.size();
                    for (int i = 0; i < len; ++i) {
                        String s = optionName + list2.get(i);
                        options.add(new Option2(configurable2, combo, s, i));
                    }
                }
            }
        } else if (component instanceof Container) {
            Container container = (Container)component;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                this.initRecursively(options, configurable2, container.getComponent(i));
            }
        }
        if (section != null) {
            this.myPrefix.pop();
        }
    }

    @Override
    @NotNull
    public Collection<OptionDescription> getOptions(@Nullable Project project) {
        Collection<OptionDescription> collection;
        try {
            Configurable configurable2 = this.getConfigurable(project);
            JComponent component = configurable2.createComponent();
            configurable2.reset();
            this.myPrefix.clear();
            String name = this.getName(configurable2);
            if (name != null) {
                this.myPrefix.push(name);
            }
            ArrayList options = new ArrayList();
            this.init(options, configurable2, component);
            collection = Collections.unmodifiableCollection(options);
        }
        catch (Exception exception) {
            LOG.debug((Throwable)exception);
            List<OptionDescription> list2 = Collections.emptyList();
            if (list2 == null) {
                ConfigurableOptionsTopHitProvider.$$$reportNull$$$0(2);
            }
            return list2;
        }
        if (collection == null) {
            ConfigurableOptionsTopHitProvider.$$$reportNull$$$0(1);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/ui/ConfigurableOptionsTopHitProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/ui/ConfigurableOptionsTopHitProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOptionName";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class Option2
    extends BooleanOptionDescription
    implements Disposable {
        final Configurable myConfigurable;
        final JComboBox<?> myComboBox;
        final int myIndex;
        final int myPrevIndex;

        Option2(Configurable configurable2, JComboBox<?> comboBox2, String option, int index) {
            super(option, ConfigurableVisitor.ByID.getID(configurable2));
            this.myConfigurable = configurable2;
            this.myComboBox = comboBox2;
            this.myIndex = index;
            this.myPrevIndex = this.myComboBox.getSelectedIndex();
        }

        public void dispose() {
            this.myConfigurable.disposeUIResources();
        }

        public boolean isOptionEnabled() {
            return this.myComboBox.getSelectedIndex() == this.myIndex;
        }

        public void setOptionState(boolean selected2) {
            if (selected2 != (this.myComboBox.getSelectedIndex() == this.myIndex)) {
                this.myComboBox.setSelectedIndex(selected2 ? this.myIndex : this.myPrevIndex);
                try {
                    this.myConfigurable.apply();
                }
                catch (ConfigurationException exception) {
                    LOG.debug((Throwable)exception);
                }
            }
        }
    }

    private static final class Option
    extends BooleanOptionDescription
    implements Disposable {
        final Configurable myConfigurable;
        final JCheckBox myCheckBox;

        Option(Configurable configurable2, JCheckBox checkbox, String option) {
            super(option, ConfigurableVisitor.ByID.getID(configurable2));
            this.myConfigurable = configurable2;
            this.myCheckBox = checkbox;
        }

        public void dispose() {
            this.myConfigurable.disposeUIResources();
        }

        public boolean isOptionEnabled() {
            return this.myCheckBox.isSelected();
        }

        public void setOptionState(boolean selected2) {
            if (selected2 != this.myCheckBox.isSelected()) {
                this.myCheckBox.setSelected(selected2);
                try {
                    this.myConfigurable.apply();
                }
                catch (ConfigurationException exception) {
                    LOG.debug((Throwable)exception);
                }
            }
        }
    }
}

