/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.concurrency.JobLauncher;
import com.intellij.diagnostic.PluginException;
import com.intellij.ide.util.NavigationItemListCellRenderer;
import com.intellij.ide.util.gotoByName.ChooseByNameModelEx;
import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.navigation.ChooseByNameContributorEx;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FindSymbolParameters;
import com.intellij.util.indexing.IdFilter;
import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public abstract class ContributorsBasedGotoByModel
implements ChooseByNameModelEx,
PossiblyDumbAware {
    public static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.gotoByName.ContributorsBasedGotoByModel");
    protected final Project myProject;
    private final List<ChooseByNameContributor> myContributors;
    private final ConcurrentMap<ChooseByNameContributor, TIntHashSet> myContributorToItsSymbolsMap;

    protected ContributorsBasedGotoByModel(@NotNull Project project, @NotNull ChooseByNameContributor[] contributors) {
        if (project == null) {
            ContributorsBasedGotoByModel.$$$reportNull$$$0(0);
        }
        if (contributors == null) {
            ContributorsBasedGotoByModel.$$$reportNull$$$0(1);
        }
        this(project, Arrays.asList(contributors));
    }

    protected ContributorsBasedGotoByModel(@NotNull Project project, @NotNull List<ChooseByNameContributor> contributors) {
        if (project == null) {
            ContributorsBasedGotoByModel.$$$reportNull$$$0(2);
        }
        if (contributors == null) {
            ContributorsBasedGotoByModel.$$$reportNull$$$0(3);
        }
        this.myContributorToItsSymbolsMap = ContainerUtil.newConcurrentMap();
        this.myProject = project;
        this.myContributors = contributors;
        assert (!contributors.contains(null));
    }

    public boolean isDumbAware() {
        return ContainerUtil.find(this.myContributors, o -> DumbService.isDumbAware((Object)o)) != null;
    }

    @NotNull
    public ListCellRenderer getListCellRenderer() {
        NavigationItemListCellRenderer navigationItemListCellRenderer = new NavigationItemListCellRenderer();
        if (navigationItemListCellRenderer == null) {
            ContributorsBasedGotoByModel.$$$reportNull$$$0(4);
        }
        return navigationItemListCellRenderer;
    }

    public boolean sameNamesForProjectAndLibraries() {
        return false;
    }

    @Override
    public void processNames(final @NotNull Processor<? super String> nameProcessor, final @NotNull FindSymbolParameters parameters) {
        if (nameProcessor == null) {
            ContributorsBasedGotoByModel.$$$reportNull$$$0(5);
        }
        if (parameters == null) {
            ContributorsBasedGotoByModel.$$$reportNull$$$0(6);
        }
        long start2 = System.currentTimeMillis();
        List<ChooseByNameContributor> contributors = this.filterDumb(this.myContributors);
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        ReadActionProcessor<ChooseByNameContributor> processor2 = new ReadActionProcessor<ChooseByNameContributor>(){

            public boolean processInReadAction(@NotNull ChooseByNameContributor contributor) {
                if (contributor == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    if (!ContributorsBasedGotoByModel.this.myProject.isDisposed()) {
                        long contributorStarted = System.currentTimeMillis();
                        ContributorsBasedGotoByModel.this.processContributorNames(contributor, parameters, (Processor<? super String>)nameProcessor);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug(contributor + " for " + (System.currentTimeMillis() - contributorStarted));
                        }
                    }
                }
                catch (ProcessCanceledException | IndexNotReadyException contributorStarted) {
                }
                catch (Exception ex) {
                    LOG.error((Throwable)ex);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contributor", "com/intellij/ide/util/gotoByName/ContributorsBasedGotoByModel$1", "processInReadAction"));
            }
        };
        if (!JobLauncher.getInstance().invokeConcurrentlyUnderProgress(contributors, indicator, processor2)) {
            throw new ProcessCanceledException();
        }
        if (indicator != null) {
            indicator.checkCanceled();
        }
        long finish = System.currentTimeMillis();
        if (LOG.isDebugEnabled()) {
            LOG.debug("processNames(): " + (finish - start2) + "ms;");
        }
    }

    public void processContributorNames(@NotNull ChooseByNameContributor contributor, @NotNull FindSymbolParameters parameters, @NotNull Processor<? super String> nameProcessor) {
        if (contributor == null) {
            ContributorsBasedGotoByModel.$$$reportNull$$$0(7);
        }
        if (parameters == null) {
            ContributorsBasedGotoByModel.$$$reportNull$$$0(8);
        }
        if (nameProcessor == null) {
            ContributorsBasedGotoByModel.$$$reportNull$$$0(9);
        }
        TIntHashSet filter = new TIntHashSet(1000);
        if (contributor instanceof ChooseByNameContributorEx) {
            ((ChooseByNameContributorEx)contributor).processNames((Processor<String>)((Processor)s -> {
                if (nameProcessor.process(s)) {
                    filter.add(s.hashCode());
                }
                return true;
            }), parameters.getSearchScope(), parameters.getIdFilter());
        } else {
            String[] names2;
            for (String element : names2 = contributor.getNames(this.myProject, parameters.isSearchInLibraries())) {
                if (!nameProcessor.process((Object)element)) continue;
                filter.add(element.hashCode());
            }
        }
        this.myContributorToItsSymbolsMap.put(contributor, filter);
    }

    IdFilter getIdFilter(boolean withLibraries) {
        return IdFilter.getProjectIdFilter((Project)this.myProject, (boolean)withLibraries);
    }

    @NotNull
    public String[] getNames(boolean checkBoxState) {
        THashSet allNames = new THashSet();
        Collection result2 = Collections.synchronizedCollection(allNames);
        this.processNames((Processor<? super String>)Processors.cancelableCollectProcessor(result2), FindSymbolParameters.simple(this.myProject, checkBoxState));
        if (LOG.isDebugEnabled()) {
            LOG.debug("getNames(): (got " + allNames.size() + " elements)");
        }
        String[] stringArray = ArrayUtilRt.toStringArray((Collection)allNames);
        if (stringArray == null) {
            ContributorsBasedGotoByModel.$$$reportNull$$$0(10);
        }
        return stringArray;
    }

    private List<ChooseByNameContributor> filterDumb(List<ChooseByNameContributor> contributors) {
        if (!DumbService.getInstance((Project)this.myProject).isDumb()) {
            return contributors;
        }
        ArrayList<ChooseByNameContributor> answer = new ArrayList<ChooseByNameContributor>(contributors.size());
        for (ChooseByNameContributor contributor : contributors) {
            if (!DumbService.isDumbAware((Object)contributor)) continue;
            answer.add(contributor);
        }
        return answer;
    }

    @NotNull
    public Object[] getElementsByName(@NotNull String name, @NotNull FindSymbolParameters parameters, @NotNull ProgressIndicator canceled) {
        if (name == null) {
            ContributorsBasedGotoByModel.$$$reportNull$$$0(11);
        }
        if (parameters == null) {
            ContributorsBasedGotoByModel.$$$reportNull$$$0(12);
        }
        if (canceled == null) {
            ContributorsBasedGotoByModel.$$$reportNull$$$0(13);
        }
        long elementByNameStarted = System.currentTimeMillis();
        List items = Collections.synchronizedList(new ArrayList());
        Processor processor2 = contributor -> {
            if (this.myProject.isDisposed()) {
                return true;
            }
            TIntHashSet filter = (TIntHashSet)this.myContributorToItsSymbolsMap.get(contributor);
            if (filter != null && !filter.contains(name.hashCode())) {
                return true;
            }
            try {
                boolean searchInLibraries = parameters.isSearchInLibraries();
                long contributorStarted = System.currentTimeMillis();
                if (contributor instanceof ChooseByNameContributorEx) {
                    ((ChooseByNameContributorEx)contributor).processElementsWithName(name, (Processor<NavigationItem>)((Processor)item -> {
                        canceled.checkCanceled();
                        if (this.acceptItem((NavigationItem)item)) {
                            items.add(item);
                        }
                        return true;
                    }), parameters);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(System.currentTimeMillis() - contributorStarted + "," + contributor + ",");
                    }
                } else {
                    NavigationItem[] itemsByName;
                    for (NavigationItem item2 : itemsByName = contributor.getItemsByName(name, parameters.getLocalPatternName(), this.myProject, searchInLibraries)) {
                        VirtualFile file2;
                        canceled.checkCanceled();
                        if (item2 == null) {
                            PluginException.logPluginError((Logger)LOG, (String)("null item from contributor " + contributor + " for name " + name), null, contributor.getClass());
                            continue;
                        }
                        VirtualFile virtualFile = file2 = item2 instanceof PsiElement && !(item2 instanceof PomTargetPsiElement) ? PsiUtilCore.getVirtualFile((PsiElement)((PsiElement)item2)) : null;
                        if (file2 != null && !parameters.getSearchScope().contains(file2) || !this.acceptItem(item2)) continue;
                        items.add(item2);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(System.currentTimeMillis() - contributorStarted + "," + contributor + "," + itemsByName.length);
                    }
                }
            }
            catch (ProcessCanceledException searchInLibraries) {
            }
            catch (Exception ex) {
                LOG.error((Throwable)ex);
            }
            return true;
        };
        if (!JobLauncher.getInstance().invokeConcurrentlyUnderProgress(this.filterDumb(this.myContributors), canceled, processor2)) {
            canceled.cancel();
        }
        canceled.checkCanceled();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Retrieving " + name + ":" + items.size() + " for " + (System.currentTimeMillis() - elementByNameStarted));
        }
        Object[] objectArray = ArrayUtil.toObjectArray(items);
        if (objectArray == null) {
            ContributorsBasedGotoByModel.$$$reportNull$$$0(14);
        }
        return objectArray;
    }

    @NotNull
    public Object[] getElementsByName(@NotNull String name, boolean checkBoxState, @NotNull String pattern) {
        if (name == null) {
            ContributorsBasedGotoByModel.$$$reportNull$$$0(15);
        }
        if (pattern == null) {
            ContributorsBasedGotoByModel.$$$reportNull$$$0(16);
        }
        Object[] objectArray = this.getElementsByName(name, FindSymbolParameters.wrap(pattern, this.myProject, checkBoxState), new ProgressIndicatorBase());
        if (objectArray == null) {
            ContributorsBasedGotoByModel.$$$reportNull$$$0(17);
        }
        return objectArray;
    }

    public String getElementName(@NotNull Object element) {
        if (element == null) {
            ContributorsBasedGotoByModel.$$$reportNull$$$0(18);
        }
        if (!(element instanceof NavigationItem)) {
            throw new AssertionError((Object)(element + " of " + element.getClass() + " in " + this + " of " + this.getClass()));
        }
        return ((NavigationItem)element).getName();
    }

    public String getHelpId() {
        return null;
    }

    protected ChooseByNameContributor[] getContributors() {
        return this.myContributors.toArray(new ChooseByNameContributor[0]);
    }

    protected boolean acceptItem(NavigationItem item) {
        return true;
    }

    public boolean useMiddleMatching() {
        return true;
    }

    @NotNull
    public String removeModelSpecificMarkup(@NotNull String pattern) {
        if (pattern == null) {
            ContributorsBasedGotoByModel.$$$reportNull$$$0(19);
        }
        String string = pattern;
        if (string == null) {
            ContributorsBasedGotoByModel.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            ContributorsBasedGotoByModel.$$$reportNull$$$0(21);
        }
        return project;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 10: 
            case 14: 
            case 17: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 10: 
            case 14: 
            case 17: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributors";
                break;
            }
            case 4: 
            case 10: 
            case 14: 
            case 17: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/gotoByName/ContributorsBasedGotoByModel";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameProcessor";
                break;
            }
            case 6: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributor";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "canceled";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/gotoByName/ContributorsBasedGotoByModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getListCellRenderer";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNames";
                break;
            }
            case 14: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsByName";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "removeModelSpecificMarkup";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 10: 
            case 14: 
            case 17: 
            case 20: 
            case 21: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processNames";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processContributorNames";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getElementsByName";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getElementName";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "removeModelSpecificMarkup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 10: 
            case 14: 
            case 17: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

