/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus;

import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomWhiteListRule;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.application.ExperimentalFeature;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegistryApplicationUsagesCollector
extends ApplicationUsagesCollector {
    @Override
    @NotNull
    public Set<UsageDescriptor> getUsages() {
        Set<UsageDescriptor> set = RegistryApplicationUsagesCollector.getChangedValuesUsages();
        if (set == null) {
            RegistryApplicationUsagesCollector.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    static Set<UsageDescriptor> getChangedValuesUsages() {
        Set registry = Registry.getAll().stream().filter(key -> key.isChangedFromDefault()).map(key -> new UsageDescriptor(key.getKey())).collect(Collectors.toSet());
        Set experiments = Arrays.stream(Experiments.EP_NAME.getExtensions()).filter(f -> Experiments.isFeatureEnabled((String)f.id)).map(f -> new UsageDescriptor(f.id)).collect(Collectors.toSet());
        HashSet<UsageDescriptor> result2 = new HashSet<UsageDescriptor>(registry);
        result2.addAll(experiments);
        HashSet<UsageDescriptor> hashSet = result2;
        if (hashSet == null) {
            RegistryApplicationUsagesCollector.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    @Override
    @NotNull
    public String getGroupId() {
        if ("platform.registry.application" == null) {
            RegistryApplicationUsagesCollector.$$$reportNull$$$0(2);
        }
        return "platform.registry.application";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/internal/statistic/collectors/fus/RegistryApplicationUsagesCollector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsages";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangedValuesUsages";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupId";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static class RegistryUtilValidator
    extends CustomWhiteListRule {
        @Override
        public boolean acceptRuleId(@Nullable String ruleId) {
            return "registry_key".equals(ruleId);
        }

        @Override
        @NotNull
        protected ValidationResultType doValidate(@NotNull String data, @NotNull EventContext context) {
            ExperimentalFeature feature;
            if (data == null) {
                RegistryUtilValidator.$$$reportNull$$$0(0);
            }
            if (context == null) {
                RegistryUtilValidator.$$$reportNull$$$0(1);
            }
            if ((feature = RegistryUtilValidator.findFeatureById(data)) != null) {
                PluginInfo info = PluginInfoDetectorKt.getPluginInfo(feature.getClass());
                if (StringUtil.equals((CharSequence)data, (CharSequence)context.eventId)) {
                    context.setPluginInfo(info);
                }
                ValidationResultType validationResultType = info.isDevelopedByJetBrains() ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
                if (validationResultType == null) {
                    RegistryUtilValidator.$$$reportNull$$$0(2);
                }
                return validationResultType;
            }
            RegistryValue value = Registry.get((String)data);
            ValidationResultType validationResultType = !value.isContributedByThirdPartyPlugin() ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
            if (validationResultType == null) {
                RegistryUtilValidator.$$$reportNull$$$0(3);
            }
            return validationResultType;
        }

        @Nullable
        private static ExperimentalFeature findFeatureById(@NotNull String featureId) {
            if (featureId == null) {
                RegistryUtilValidator.$$$reportNull$$$0(4);
            }
            for (ExperimentalFeature feature : (ExperimentalFeature[])Experiments.EP_NAME.getExtensions()) {
                if (!StringUtil.equals((CharSequence)feature.id, (CharSequence)featureId)) continue;
                return feature;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/statistic/collectors/fus/RegistryApplicationUsagesCollector$RegistryUtilValidator";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "featureId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/RegistryApplicationUsagesCollector$RegistryUtilValidator";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doValidate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doValidate";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "findFeatureById";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

