/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.fileTypes;

import com.intellij.internal.statistic.collectors.fus.fileTypes.FileTypeUsageCounterCollector;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.MessageBusConnection;
import org.jetbrains.annotations.NotNull;

public class FileTypeExtensionUsagesCollectorStartupActivity
implements StartupActivity,
DumbAware {
    private static final Key<Long> LAST_EDIT_USAGE = Key.create((String)"LAST_EDIT_USAGE");

    public void runActivity(final @NotNull Project project) {
        if (project == null) {
            FileTypeExtensionUsagesCollectorStartupActivity.$$$reportNull$$$0(0);
        }
        MessageBusConnection myConnection = project.getMessageBus().connect();
        myConnection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                if (source == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                FileTypeUsageCounterCollector.triggerOpen(project, file2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "source";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/internal/statistic/collectors/fus/fileTypes/FileTypeExtensionUsagesCollectorStartupActivity$1";
                objectArray[2] = "fileOpened";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)project).subscribe(AnActionListener.TOPIC, (Object)new AnActionListener(){

            public void beforeActionPerformed(@NotNull AnAction action2, @NotNull DataContext dataContext, @NotNull AnActionEvent event) {
                if (action2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (dataContext == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (event == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (action2 instanceof EditorAction && ((EditorAction)action2).getHandler() instanceof EditorWriteActionHandler) {
                    this.onChange(dataContext);
                }
            }

            private void onChange(DataContext dataContext) {
                Long lastEdit;
                Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
                if (editor == null || editor.getProject() != project) {
                    return;
                }
                VirtualFile file2 = FileDocumentManager.getInstance().getFile(editor.getDocument());
                if (file2 != null && ((lastEdit = (Long)editor.getUserData(LAST_EDIT_USAGE)) == null || System.currentTimeMillis() - lastEdit > 60000L)) {
                    editor.putUserData(LAST_EDIT_USAGE, (Object)System.currentTimeMillis());
                    FileTypeUsageCounterCollector.triggerEdit(project, file2);
                }
            }

            public void beforeEditorTyping(char c2, @NotNull DataContext dataContext) {
                if (dataContext == null) {
                    2.$$$reportNull$$$0(3);
                }
                this.onChange(dataContext);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "action";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataContext";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/fileTypes/FileTypeExtensionUsagesCollectorStartupActivity$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeActionPerformed";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeEditorTyping";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/internal/statistic/collectors/fus/fileTypes/FileTypeExtensionUsagesCollectorStartupActivity", "runActivity"));
    }
}

