/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.rules.beans;

import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.FUSRule;
import com.intellij.internal.statistic.eventLog.validator.rules.beans.WhiteListGroupContextData;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.EnumWhiteListRule;
import com.intellij.internal.statistic.eventLog.validator.rules.utils.WhiteListSimpleRuleFactory;
import com.intellij.internal.statistic.service.fus.FUStatisticsWhiteListGroupsService;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SortedList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WhiteListGroupRules {
    public static final WhiteListGroupRules EMPTY = new WhiteListGroupRules(Collections.emptySet(), Collections.emptyMap(), WhiteListGroupContextData.EMPTY);
    private final FUSRule[] eventIdRules;
    private final Map<String, FUSRule[]> eventDataRules;

    private WhiteListGroupRules(@Nullable Set<String> eventIdRules, @Nullable Map<String, Set<String>> eventDataRules, @NotNull WhiteListGroupContextData contextData) {
        if (contextData == null) {
            WhiteListGroupRules.$$$reportNull$$$0(0);
        }
        this.eventDataRules = ContainerUtil.newConcurrentMap();
        this.eventIdRules = WhiteListGroupRules.getRules(eventIdRules, contextData);
        if (eventDataRules != null) {
            for (Map.Entry<String, Set<String>> entry : eventDataRules.entrySet()) {
                if (FeatureUsageData.Companion.getPlatformDataKeys().contains(entry.getKey())) {
                    this.eventDataRules.put(entry.getKey(), new FUSRule[]{FUSRule.TRUE});
                    continue;
                }
                this.eventDataRules.put(entry.getKey(), WhiteListGroupRules.getRules(entry.getValue(), contextData));
            }
        }
    }

    public FUSRule[] getEventIdRules() {
        return this.eventIdRules;
    }

    public Map<String, FUSRule[]> getEventDataRules() {
        return this.eventDataRules;
    }

    @NotNull
    private static FUSRule[] getRules(@Nullable Set<String> rules, @NotNull WhiteListGroupContextData contextData) {
        if (contextData == null) {
            WhiteListGroupRules.$$$reportNull$$$0(1);
        }
        if (rules == null) {
            if (FUSRule.EMPTY_ARRAY == null) {
                WhiteListGroupRules.$$$reportNull$$$0(2);
            }
            return FUSRule.EMPTY_ARRAY;
        }
        SortedList fusRules = new SortedList(WhiteListGroupRules.getRulesComparator());
        for (String rule : rules) {
            ContainerUtil.addIfNotNull((Collection)fusRules, (Object)WhiteListSimpleRuleFactory.createRule(rule, contextData));
        }
        FUSRule[] fUSRuleArray = fusRules.toArray(FUSRule.EMPTY_ARRAY);
        if (fUSRuleArray == null) {
            WhiteListGroupRules.$$$reportNull$$$0(3);
        }
        return fUSRuleArray;
    }

    @NotNull
    private static Comparator<FUSRule> getRulesComparator() {
        Comparator comparator2 = (o1, o2) -> {
            if (o1 instanceof EnumWhiteListRule) {
                return o2 instanceof EnumWhiteListRule ? -1 : 0;
            }
            return o2 instanceof EnumWhiteListRule ? 0 : 1;
        };
        if (comparator2 == null) {
            WhiteListGroupRules.$$$reportNull$$$0(4);
        }
        return comparator2;
    }

    public boolean areEventIdRulesDefined() {
        return this.eventIdRules.length > 0;
    }

    public boolean areEventDataRulesDefined() {
        return this.eventDataRules.size() > 0;
    }

    public ValidationResultType validateEventId(@NotNull EventContext context) {
        if (context == null) {
            WhiteListGroupRules.$$$reportNull$$$0(5);
        }
        for (FUSRule rule : this.eventIdRules) {
            ValidationResultType resultType = rule.validate(context.eventId, context);
            if (resultType == ValidationResultType.REJECTED) continue;
            return resultType;
        }
        return ValidationResultType.REJECTED;
    }

    public ValidationResultType validateEventData(@NotNull String key, @Nullable Object data, @NotNull EventContext context) {
        if (key == null) {
            WhiteListGroupRules.$$$reportNull$$$0(6);
        }
        if (context == null) {
            WhiteListGroupRules.$$$reportNull$$$0(7);
        }
        if (FeatureUsageData.Companion.getPlatformDataKeys().contains(key)) {
            return ValidationResultType.ACCEPTED;
        }
        FUSRule[] rules = this.eventDataRules.get(key);
        if (rules == null || rules.length == 0) {
            return ValidationResultType.UNDEFINED_RULE;
        }
        return data == null ? ValidationResultType.REJECTED : WhiteListGroupRules.acceptRule(data.toString(), context, rules);
    }

    private static ValidationResultType acceptRule(@NotNull String ruleData, @NotNull EventContext context, FUSRule ... rules) {
        if (ruleData == null) {
            WhiteListGroupRules.$$$reportNull$$$0(8);
        }
        if (context == null) {
            WhiteListGroupRules.$$$reportNull$$$0(9);
        }
        if (rules == null) {
            return ValidationResultType.UNDEFINED_RULE;
        }
        for (FUSRule rule : rules) {
            ValidationResultType resultType = rule.validate(ruleData, context);
            if (resultType == ValidationResultType.REJECTED) continue;
            return resultType;
        }
        return ValidationResultType.REJECTED;
    }

    @NotNull
    public static WhiteListGroupRules create(@NotNull FUStatisticsWhiteListGroupsService.WLGroup group, @Nullable Map<String, Set<String>> globalEnums, @Nullable Map<String, String> globalRegexps) {
        FUStatisticsWhiteListGroupsService.WLRule rules;
        if (group == null) {
            WhiteListGroupRules.$$$reportNull$$$0(10);
        }
        WhiteListGroupRules whiteListGroupRules = (rules = group.rules) == null ? EMPTY : new WhiteListGroupRules(rules.event_id, rules.event_data, WhiteListGroupContextData.create(rules.enums, globalEnums, rules.regexps, globalRegexps));
        if (whiteListGroupRules == null) {
            WhiteListGroupRules.$$$reportNull$$$0(11);
        }
        return whiteListGroupRules;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextData";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/eventLog/validator/rules/beans/WhiteListGroupRules";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ruleData";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/eventLog/validator/rules/beans/WhiteListGroupRules";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRules";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRulesComparator";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRules";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 11: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "validateEventId";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "validateEventData";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "acceptRule";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

