/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.service.fus;

import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FUSWhitelist {
    private Map<String, GroupFilterCondition> myGroups;

    public FUSWhitelist() {
    }

    private FUSWhitelist(@NotNull Map<String, GroupFilterCondition> groups) {
        if (groups == null) {
            FUSWhitelist.$$$reportNull$$$0(0);
        }
        this.myGroups = groups;
    }

    @NotNull
    public static FUSWhitelist create(@NotNull Map<String, GroupFilterCondition> groups) {
        if (groups == null) {
            FUSWhitelist.$$$reportNull$$$0(1);
        }
        FUSWhitelist fUSWhitelist = new FUSWhitelist(groups);
        if (fUSWhitelist == null) {
            FUSWhitelist.$$$reportNull$$$0(2);
        }
        return fUSWhitelist;
    }

    @NotNull
    public static FUSWhitelist empty() {
        FUSWhitelist fUSWhitelist = new FUSWhitelist(Collections.emptyMap());
        if (fUSWhitelist == null) {
            FUSWhitelist.$$$reportNull$$$0(3);
        }
        return fUSWhitelist;
    }

    public boolean accepts(@NotNull String groupId, @Nullable String version2, @NotNull String build2) {
        if (groupId == null) {
            FUSWhitelist.$$$reportNull$$$0(4);
        }
        if (build2 == null) {
            FUSWhitelist.$$$reportNull$$$0(5);
        }
        if (!this.myGroups.containsKey(groupId)) {
            return false;
        }
        int parsedVersion = FUSWhitelist.tryToParse(version2, -1);
        if (parsedVersion < 0) {
            return false;
        }
        GroupFilterCondition condition = this.myGroups.get(groupId);
        return condition.accepts(build2, parsedVersion);
    }

    public int getSize() {
        return this.myGroups.size();
    }

    public boolean isEmpty() {
        return this.myGroups.isEmpty();
    }

    private static int tryToParse(@Nullable String value, int defaultValue) {
        try {
            if (value != null) {
                return Integer.parseInt(value.trim());
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return defaultValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FUSWhitelist whitelist = (FUSWhitelist)o;
        return Objects.equals(this.myGroups, whitelist.myGroups);
    }

    public int hashCode() {
        return Objects.hash(this.myGroups);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/service/fus/FUSWhitelist";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "build";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/service/fus/FUSWhitelist";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "empty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "accepts";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class VersionRange {
        private final int myFrom;
        private final int myTo;

        public VersionRange(int from, int to) {
            this.myFrom = from;
            this.myTo = to;
        }

        @NotNull
        public static VersionRange create(@Nullable String from, @Nullable String to) {
            VersionRange versionRange = new VersionRange(from == null ? 0 : FUSWhitelist.tryToParse(from, Integer.MAX_VALUE), to == null ? Integer.MAX_VALUE : FUSWhitelist.tryToParse(to, 0));
            if (versionRange == null) {
                VersionRange.$$$reportNull$$$0(0);
            }
            return versionRange;
        }

        public boolean contains(int current) {
            return current >= this.myFrom && current < this.myTo;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VersionRange range2 = (VersionRange)o;
            return this.myFrom == range2.myFrom && this.myTo == range2.myTo;
        }

        public int hashCode() {
            return Objects.hash(this.myFrom, this.myTo);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/service/fus/FUSWhitelist$VersionRange", "create"));
        }
    }

    public static class BuildRange {
        private final BuildNumber myFrom;
        private final BuildNumber myTo;

        public BuildRange(@Nullable BuildNumber from, @Nullable BuildNumber to) {
            this.myFrom = from;
            this.myTo = to;
        }

        @NotNull
        public static BuildRange create(@Nullable String from, @Nullable String to) {
            BuildRange buildRange = new BuildRange(StringUtil.isNotEmpty((String)from) ? BuildNumber.fromString((String)from) : null, StringUtil.isNotEmpty((String)to) ? BuildNumber.fromString((String)to) : null);
            if (buildRange == null) {
                BuildRange.$$$reportNull$$$0(0);
            }
            return buildRange;
        }

        public boolean contains(@NotNull BuildNumber build2) {
            if (build2 == null) {
                BuildRange.$$$reportNull$$$0(1);
            }
            return !(this.myTo != null && this.myTo.compareTo(build2) <= 0 || this.myFrom != null && this.myFrom.compareTo(build2) > 0);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BuildRange range2 = (BuildRange)o;
            return Objects.equals(this.myFrom, range2.myFrom) && Objects.equals(this.myTo, range2.myTo);
        }

        public int hashCode() {
            return Objects.hash(this.myFrom, this.myTo);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/statistic/service/fus/FUSWhitelist$BuildRange";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/statistic/service/fus/FUSWhitelist$BuildRange";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class GroupFilterCondition {
        private final List<BuildRange> builds;
        private final List<VersionRange> versions;

        public GroupFilterCondition(@NotNull List<BuildRange> builds, @NotNull List<VersionRange> versions) {
            if (builds == null) {
                GroupFilterCondition.$$$reportNull$$$0(0);
            }
            if (versions == null) {
                GroupFilterCondition.$$$reportNull$$$0(1);
            }
            this.builds = builds;
            this.versions = versions;
        }

        public boolean accepts(@NotNull String build2, int version2) {
            if (build2 == null) {
                GroupFilterCondition.$$$reportNull$$$0(2);
            }
            if (!this.isValid()) {
                return false;
            }
            return this.acceptsBuild(build2) && this.acceptsVersion(version2);
        }

        private boolean acceptsBuild(@NotNull String build2) {
            if (build2 == null) {
                GroupFilterCondition.$$$reportNull$$$0(3);
            }
            if (this.builds.isEmpty()) {
                return true;
            }
            BuildNumber number = BuildNumber.fromString((String)build2);
            return number != null && this.builds.stream().anyMatch(b -> b.contains(number));
        }

        private boolean acceptsVersion(int version2) {
            if (this.versions.isEmpty()) {
                return true;
            }
            return version2 > 0 && this.versions.stream().anyMatch(v -> v.contains(version2));
        }

        private boolean isValid() {
            return !this.builds.isEmpty() || !this.versions.isEmpty();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GroupFilterCondition condition = (GroupFilterCondition)o;
            return Objects.equals(this.builds, condition.builds) && Objects.equals(this.versions, condition.versions);
        }

        public int hashCode() {
            return Objects.hash(this.builds, this.versions);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builds";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "versions";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "build";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/internal/statistic/service/fus/FUSWhitelist$GroupFilterCondition";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "accepts";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "acceptsBuild";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

