/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.largeFilesEditor.search.actions;

import com.intellij.find.editorHeaderActions.ContextAwareShortcutProvider;
import com.intellij.find.editorHeaderActions.Utils;
import com.intellij.largeFilesEditor.search.SearchManager;
import com.intellij.largeFilesEditor.search.searchTask.CloseSearchTask;
import com.intellij.largeFilesEditor.search.searchTask.SearchTaskBase;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.project.DumbAwareAction;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrevNextOccurrenceAction
extends DumbAwareAction
implements ContextAwareShortcutProvider {
    private final SearchManager mySearchManager;
    private final boolean myDirectionForward;

    public PrevNextOccurrenceAction(SearchManager searchManager, boolean directionForward) {
        this.mySearchManager = searchManager;
        this.myDirectionForward = directionForward;
        this.copyFrom(ActionManager.getInstance().getAction(directionForward ? "NextOccurence" : "PreviousOccurence"));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            PrevNextOccurrenceAction.$$$reportNull$$$0(0);
        }
        if (this.isEnabled()) {
            this.mySearchManager.gotoNextOccurrence(this.myDirectionForward);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            PrevNextOccurrenceAction.$$$reportNull$$$0(1);
        }
        e.getPresentation().setEnabled(this.isEnabled());
    }

    private boolean isEnabled() {
        SearchTaskBase task2 = this.mySearchManager.getLastExecutedSearchTask();
        return !(task2 instanceof CloseSearchTask) || task2.isFinished();
    }

    @Override
    @Nullable
    public ShortcutSet getShortcut(@NotNull DataContext context) {
        if (context == null) {
            PrevNextOccurrenceAction.$$$reportNull$$$0(2);
        }
        ArrayList<Shortcut> list2 = new ArrayList<Shortcut>();
        if (this.myDirectionForward) {
            list2.addAll(Utils.shortcutsOf("FindNext"));
            list2.addAll(Utils.shortcutsOf("EditorDown"));
            list2.addAll(Arrays.asList(CommonShortcuts.ENTER.getShortcuts()));
        } else {
            list2.addAll(Utils.shortcutsOf("FindPrevious"));
            list2.addAll(Utils.shortcutsOf("EditorUp"));
            list2.add((Shortcut)new KeyboardShortcut(KeyStroke.getKeyStroke(10, 64), null));
        }
        return Utils.shortcutSetOf(list2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/intellij/largeFilesEditor/search/actions/PrevNextOccurrenceAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getShortcut";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

