/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.ex;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.SystemInfo;
import java.awt.datatransfer.DataFlavor;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClipboardUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.Clipboard");

    public static <E> E handleClipboardSafely(@NotNull Supplier<? extends E> supplier, E defaultValue) {
        if (supplier == null) {
            ClipboardUtil.$$$reportNull$$$0(0);
        }
        try {
            return supplier.get();
        }
        catch (IllegalStateException e) {
            if (SystemInfo.isWindows) {
                LOG.debug("Clipboard is busy");
            } else {
                LOG.warn((Throwable)e);
            }
        }
        catch (NullPointerException e) {
            LOG.warn("Java bug #6322854", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Java bug #7173464", (Throwable)e);
        }
        return defaultValue;
    }

    @Nullable
    public static String getTextInClipboard() {
        return (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supplier", "com/intellij/openapi/application/ex/ClipboardUtil", "handleClipboardSafely"));
    }
}

