/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl;

import com.intellij.diagnostic.ParallelActivity;
import com.intellij.diagnostic.PluginException;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceDescriptor;
import com.intellij.openapi.components.impl.ComponentManagerImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.extensions.impl.ExtensionComponentAdapter;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.pico.AssignableToComponentAdapter;
import com.intellij.util.pico.CachingConstructorInjectionComponentAdapter;
import com.intellij.util.pico.DefaultPicoContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.PicoVisitor;
import org.picocontainer.defaults.InstanceComponentAdapter;

public final class ServiceManagerImpl
implements Disposable {
    private static final Logger LOG = Logger.getInstance(ServiceManagerImpl.class);

    static void registerServices(@NotNull List<ServiceDescriptor> services, @NotNull IdeaPluginDescriptor pluginDescriptor, @NotNull ComponentManager componentManager) {
        if (services == null) {
            ServiceManagerImpl.$$$reportNull$$$0(0);
        }
        if (pluginDescriptor == null) {
            ServiceManagerImpl.$$$reportNull$$$0(1);
        }
        if (componentManager == null) {
            ServiceManagerImpl.$$$reportNull$$$0(2);
        }
        MutablePicoContainer picoContainer = (MutablePicoContainer)componentManager.getPicoContainer();
        for (ServiceDescriptor descriptor2 : services) {
            ComponentAdapter oldAdapter;
            if (descriptor2.overrides && (oldAdapter = picoContainer.unregisterComponent((Object)descriptor2.getInterface())) == null) {
                throw new PluginException("Service: " + descriptor2.getInterface() + " doesn't override anything", pluginDescriptor.getPluginId());
            }
            if (StringUtil.isEmpty((String)descriptor2.getImplementation())) continue;
            picoContainer.registerComponent((ComponentAdapter)new MyComponentAdapter(descriptor2, (PluginDescriptor)pluginDescriptor, componentManager));
        }
    }

    @ApiStatus.Internal
    public static void processAllDescriptors(@NotNull Consumer<? super ServiceDescriptor> consumer, @NotNull ComponentManager componentManager) {
        if (consumer == null) {
            ServiceManagerImpl.$$$reportNull$$$0(3);
        }
        if (componentManager == null) {
            ServiceManagerImpl.$$$reportNull$$$0(4);
        }
        for (IdeaPluginDescriptor plugin : PluginManagerCore.getLoadedPlugins()) {
            IdeaPluginDescriptorImpl pluginDescriptor = (IdeaPluginDescriptorImpl)plugin;
            List<ServiceDescriptor> serviceDescriptors = componentManager instanceof Application ? pluginDescriptor.getAppServices() : (componentManager instanceof Project ? pluginDescriptor.getProjectServices() : pluginDescriptor.getModuleServices());
            serviceDescriptors.forEach(consumer);
        }
    }

    @ApiStatus.Internal
    public static void processProjectDescriptors(@NotNull BiConsumer<? super ServiceDescriptor, ? super PluginDescriptor> consumer) {
        if (consumer == null) {
            ServiceManagerImpl.$$$reportNull$$$0(5);
        }
        for (IdeaPluginDescriptor plugin : PluginManagerCore.getLoadedPlugins()) {
            for (ServiceDescriptor serviceDescriptor : ((IdeaPluginDescriptorImpl)plugin).getProjectServices()) {
                consumer.accept((ServiceDescriptor)serviceDescriptor, (PluginDescriptor)plugin);
            }
        }
    }

    @NotNull
    public static List<String> getImplementationClassNames(@NotNull ComponentManager componentManager, @NotNull String prefix) {
        if (componentManager == null) {
            ServiceManagerImpl.$$$reportNull$$$0(6);
        }
        if (prefix == null) {
            ServiceManagerImpl.$$$reportNull$$$0(7);
        }
        ArrayList<String> result2 = new ArrayList<String>();
        ServiceManagerImpl.processAllDescriptors(serviceDescriptor -> {
            String implementation = serviceDescriptor.getImplementation();
            if (!StringUtil.isEmpty((String)implementation) && implementation.startsWith(prefix)) {
                result2.add(implementation);
            }
        }, componentManager);
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            ServiceManagerImpl.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    public static void processAllImplementationClasses(@NotNull ComponentManager componentManager, @NotNull BiPredicate<? super Class<?>, ? super PluginDescriptor> processor2) {
        Collection adapters;
        if (componentManager == null) {
            ServiceManagerImpl.$$$reportNull$$$0(9);
        }
        if (processor2 == null) {
            ServiceManagerImpl.$$$reportNull$$$0(10);
        }
        if ((adapters = componentManager.getPicoContainer().getComponentAdapters()).isEmpty()) {
            return;
        }
        for (ComponentAdapter o : adapters) {
            PluginId pluginId;
            Class<?> aClass;
            if (o instanceof MyComponentAdapter) {
                MyComponentAdapter adapter = (MyComponentAdapter)o;
                PluginDescriptor pluginDescriptor = adapter.myPluginDescriptor;
                try {
                    ComponentAdapter delegate = adapter.myDelegate;
                    if (delegate == null) {
                        ClassLoader classLoader = pluginDescriptor.getPluginClassLoader();
                        aClass = Class.forName(adapter.myDescriptor.getImplementation(), false, classLoader);
                    } else {
                        aClass = delegate.getComponentImplementation();
                    }
                }
                catch (Throwable e) {
                    if (PlatformUtils.isIdeaUltimate()) {
                        LOG.error(e);
                        continue;
                    }
                    LOG.warn(e);
                    continue;
                }
                if (processor2.test(aClass, (PluginDescriptor)pluginDescriptor)) continue;
                break;
            }
            if (o instanceof ExtensionComponentAdapter || (pluginId = ComponentManagerImpl.getConfig(o)) == null && !(o instanceof InstanceComponentAdapter)) continue;
            try {
                aClass = o.getComponentImplementation();
            }
            catch (Throwable e) {
                LOG.error(e);
                continue;
            }
            if (processor2.test(aClass, (PluginDescriptor)(pluginId == null ? null : PluginManager.getPlugin(pluginId)))) continue;
            break;
        }
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "services";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentManager";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/components/impl/ServiceManagerImpl";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/components/impl/ServiceManagerImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplementationClassNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerServices";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processAllDescriptors";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processProjectDescriptors";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getImplementationClassNames";
                break;
            }
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processAllImplementationClasses";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyComponentAdapter
    implements AssignableToComponentAdapter,
    DefaultPicoContainer.LazyComponentAdapter {
        private ComponentAdapter myDelegate;
        private final PluginDescriptor myPluginDescriptor;
        private final ServiceDescriptor myDescriptor;
        private final ComponentManager myComponentManager;
        private volatile Object myInitializedComponentInstance;

        MyComponentAdapter(@NotNull ServiceDescriptor descriptor2, @NotNull PluginDescriptor pluginDescriptor, @NotNull ComponentManager componentManager) {
            if (descriptor2 == null) {
                MyComponentAdapter.$$$reportNull$$$0(0);
            }
            if (pluginDescriptor == null) {
                MyComponentAdapter.$$$reportNull$$$0(1);
            }
            if (componentManager == null) {
                MyComponentAdapter.$$$reportNull$$$0(2);
            }
            this.myDescriptor = descriptor2;
            this.myPluginDescriptor = pluginDescriptor;
            this.myComponentManager = componentManager;
        }

        public String getComponentKey() {
            return this.myDescriptor.getInterface();
        }

        public Class getComponentImplementation() {
            return this.getDelegate().getComponentImplementation();
        }

        public boolean isComponentInstantiated() {
            return this.myInitializedComponentInstance != null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object getComponentInstance(@NotNull PicoContainer container) throws PicoInitializationException, PicoIntrospectionException {
            Object instance;
            if (container == null) {
                MyComponentAdapter.$$$reportNull$$$0(3);
            }
            if ((instance = this.myInitializedComponentInstance) != null) {
                return instance;
            }
            MyComponentAdapter myComponentAdapter = this;
            synchronized (myComponentAdapter) {
                instance = this.myInitializedComponentInstance;
                if (instance != null) {
                    return instance;
                }
                String implementation = this.myDescriptor.getImplementation();
                if (LOG.isDebugEnabled() && ApplicationManager.getApplication().isWriteAccessAllowed() && !ApplicationManager.getApplication().isUnitTestMode() && PersistentStateComponent.class.isAssignableFrom(this.getDelegate().getComponentImplementation())) {
                    LOG.warn(new Throwable("Getting service from write-action leads to possible deadlock. Service implementation " + implementation));
                }
                try (AccessToken ignore = HeavyProcessLatch.INSTANCE.processStarted("Creating service '" + implementation + "'");){
                    if (ProgressIndicatorProvider.getGlobalProgressIndicator() == null) {
                        this.myInitializedComponentInstance = this.createAndInitialize(container);
                    } else {
                        ProgressManager.getInstance().executeNonCancelableSection(() -> {
                            this.myInitializedComponentInstance = this.createAndInitialize(container);
                        });
                    }
                    Object object = this.myInitializedComponentInstance;
                    return object;
                }
            }
        }

        @NotNull
        private Object createAndInitialize(@NotNull PicoContainer container) {
            if (container == null) {
                MyComponentAdapter.$$$reportNull$$$0(4);
            }
            long startTime = StartUpMeasurer.getCurrentTime();
            Object instance = this.getDelegate().getComponentInstance(container);
            if (instance instanceof Disposable) {
                Disposer.register((Disposable)this.myComponentManager, (Disposable)((Disposable)instance));
            }
            this.myComponentManager.initializeComponent(instance, this.myDescriptor);
            ParallelActivity.SERVICE.record(startTime, instance.getClass(), DefaultPicoContainer.getActivityLevel((PicoContainer)container));
            Object object = instance;
            if (object == null) {
                MyComponentAdapter.$$$reportNull$$$0(5);
            }
            return object;
        }

        @NotNull
        private synchronized ComponentAdapter getDelegate() {
            if (this.myDelegate == null) {
                Class<?> implClass;
                try {
                    ClassLoader classLoader = this.myPluginDescriptor.getPluginClassLoader();
                    implClass = Class.forName(this.myDescriptor.getImplementation(), true, classLoader);
                }
                catch (ClassNotFoundException e) {
                    throw new PluginException("Failed to load class: " + this.myDescriptor, (Throwable)e, this.myPluginDescriptor.getPluginId());
                }
                this.myDelegate = new CachingConstructorInjectionComponentAdapter((Object)this.getComponentKey(), implClass, null, true);
            }
            ComponentAdapter componentAdapter = this.myDelegate;
            if (componentAdapter == null) {
                MyComponentAdapter.$$$reportNull$$$0(6);
            }
            return componentAdapter;
        }

        public void verify(PicoContainer container) throws PicoIntrospectionException {
            this.getDelegate().verify(container);
        }

        public void accept(PicoVisitor visitor) {
            visitor.visitComponentAdapter((ComponentAdapter)this);
        }

        public String getAssignableToClassName() {
            return this.myDescriptor.getInterface();
        }

        public String toString() {
            return "ServiceComponentAdapter(descriptor=" + this.myDescriptor + ", pluginDescriptor=" + this.myPluginDescriptor + ")";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginDescriptor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "componentManager";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "container";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/components/impl/ServiceManagerImpl$MyComponentAdapter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/components/impl/ServiceManagerImpl$MyComponentAdapter";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createAndInitialize";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDelegate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getComponentInstance";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createAndInitialize";
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

