/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.ex.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterClient;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class EmptyEditorHighlighter
implements EditorHighlighter,
PrioritizedDocumentListener {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.ex.util.EmptyEditorHighlighter");
    private TextAttributes myAttributes;
    private int myTextLength = 0;
    private HighlighterClient myEditor;

    public EmptyEditorHighlighter(TextAttributes attributes) {
        this.myAttributes = attributes;
    }

    public void setAttributes(TextAttributes attributes) {
        this.myAttributes = attributes;
    }

    public void setText(@NotNull CharSequence text2) {
        if (text2 == null) {
            EmptyEditorHighlighter.$$$reportNull$$$0(0);
        }
        this.myTextLength = text2.length();
    }

    public void setEditor(@NotNull HighlighterClient editor) {
        if (editor == null) {
            EmptyEditorHighlighter.$$$reportNull$$$0(1);
        }
        LOG.assertTrue(this.myEditor == null, (Object)"Highlighters cannot be reused with different editors");
        this.myEditor = editor;
    }

    public void setColorScheme(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            EmptyEditorHighlighter.$$$reportNull$$$0(2);
        }
        this.setAttributes(scheme.getAttributes(HighlighterColors.TEXT));
    }

    public void documentChanged(@NotNull DocumentEvent e) {
        if (e == null) {
            EmptyEditorHighlighter.$$$reportNull$$$0(3);
        }
        this.myTextLength += e.getNewLength() - e.getOldLength();
    }

    @Override
    public int getPriority() {
        return 2;
    }

    @NotNull
    public HighlighterIterator createIterator(int startOffset) {
        HighlighterIterator highlighterIterator = new HighlighterIterator(){
            private int index = 0;

            public TextAttributes getTextAttributes() {
                return EmptyEditorHighlighter.this.myAttributes;
            }

            public int getStart() {
                return 0;
            }

            public int getEnd() {
                return EmptyEditorHighlighter.this.myTextLength;
            }

            public void advance() {
                ++this.index;
            }

            public void retreat() {
                --this.index;
            }

            public boolean atEnd() {
                return this.index != 0;
            }

            @NotNull
            public Document getDocument() {
                Document document = EmptyEditorHighlighter.this.myEditor.getDocument();
                if (document == null) {
                    1.$$$reportNull$$$0(0);
                }
                return document;
            }

            public IElementType getTokenType() {
                return IElementType.find((short)1);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/ex/util/EmptyEditorHighlighter$1", "getDocument"));
            }
        };
        if (highlighterIterator == null) {
            EmptyEditorHighlighter.$$$reportNull$$$0(4);
        }
        return highlighterIterator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/ex/util/EmptyEditorHighlighter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/ex/util/EmptyEditorHighlighter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createIterator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setEditor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setColorScheme";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "documentChanged";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

